/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.model;

import fr.labri.harmony.core.model.ActionKind;
import fr.labri.harmony.core.model.Event;
import fr.labri.harmony.core.model.Item;
import fr.labri.harmony.core.model.Source;
import fr.labri.harmony.core.model.SourceElement;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class Action
extends SourceElement {
    @Enumerated
    private ActionKind kind;
    @ManyToOne
    @JoinColumn(name="eventId", nullable=false)
    private Event event;
    @ManyToOne
    @JoinColumn(name="parentEventId", nullable=true)
    private Event parentEvent;
    @ManyToOne
    @JoinColumn(name="itemId", nullable=false)
    private Item item;

    public Action() {
    }

    public Action(Item item, ActionKind kind, Event event, Event parentEvent, Source source) {
        this();
        this.item = item;
        this.kind = kind;
        this.event = event;
        this.parentEvent = parentEvent;
        this.setSource(source);
    }

    public ActionKind getKind() {
        return this.kind;
    }

    public void setKind(ActionKind kind) {
        this.kind = kind;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public Event getParentEvent() {
        return this.parentEvent;
    }

    public void setParentEvent(Event parentEvent) {
        this.parentEvent = parentEvent;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.kind) + " " + this.item;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.parentEvent == null ? 0 : this.parentEvent.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Action other = (Action)obj;
        if (this.event == null ? other.event != null : !this.event.equals(other.event)) {
            return false;
        }
        if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
            return false;
        }
        if (this.kind != other.kind) {
            return false;
        }
        return !(this.parentEvent == null ? other.parentEvent != null : !this.parentEvent.equals(other.parentEvent));
    }
}

