/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.model;

import fr.labri.harmony.core.model.Action;
import fr.labri.harmony.core.model.Author;
import fr.labri.harmony.core.model.Source;
import fr.labri.harmony.core.model.SourceElement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;

@Entity
public class Event
extends SourceElement {
    @ManyToMany
    private List<Author> authors = new ArrayList<Author>();
    @ManyToMany
    private Set<Event> parents = new HashSet<Event>();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="event")
    private List<Action> actions = new ArrayList<Action>();
    @Basic
    private long timestamp;
    @ElementCollection
    private Set<String> tags = new HashSet<String>();

    public Event() {
    }

    public Event(Source source, String nativeId, long timestamp, Set<Event> parents, List<Author> authors) {
        this();
        this.source = source;
        this.nativeId = nativeId;
        this.timestamp = timestamp;
        this.parents = parents;
        this.authors = authors;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<Author> authors) {
        this.authors = authors;
    }

    public List<Event> getParents() {
        return new ArrayList<Event>(this.parents);
    }

    public void setParents(Set<Event> parents) {
        this.parents = parents;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public Set<Action> getActions(Event parent) {
        if (parent == null) {
            throw new IllegalArgumentException("null parent");
        }
        HashSet<Action> result = new HashSet<Action>();
        for (Action a : this.actions) {
            if (a.getParentEvent() == null || !a.getParentEvent().equals(parent)) continue;
            result.add(a);
        }
        return result;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public String getTimestampAsString() {
        DateFormat f = DateFormat.getDateTimeInstance(2, 2);
        return f.format(new Date(this.timestamp));
    }
}

