/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.model;

import fr.labri.harmony.core.model.Action;
import fr.labri.harmony.core.model.Author;
import fr.labri.harmony.core.model.Source;
import fr.labri.harmony.core.model.SourceElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;

@Entity
public class Item
extends SourceElement {
    public static final String METADATA_PATHS = "paths";
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="item")
    private List<Action> actions;

    public Item() {
        this.actions = new ArrayList<Action>();
    }

    public Item(Source source, String path) {
        this.setSource(source);
        this.setNativeId(path);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    @Deprecated
    public Set<Author> getAuthors() {
        HashSet<Author> authors = new HashSet<Author>();
        for (Action ac : this.getActions()) {
            authors.addAll(ac.getEvent().getAuthors());
        }
        return authors;
    }

    public List<String> getPaths() {
        String pathsMetadata = this.getMetadata().get(METADATA_PATHS);
        if (pathsMetadata == null) {
            return Arrays.asList(this.nativeId);
        }
        return Arrays.asList(pathsMetadata.split("\n"));
    }
}

