/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.model;

import fr.labri.harmony.core.config.model.SourceConfiguration;
import fr.labri.harmony.core.model.Action;
import fr.labri.harmony.core.model.Author;
import fr.labri.harmony.core.model.Event;
import fr.labri.harmony.core.model.HarmonyModelElement;
import fr.labri.harmony.core.model.Item;
import fr.labri.harmony.core.source.Workspace;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.Index;

@Entity
public class Source
implements HarmonyModelElement {
    @Id
    @GeneratedValue
    private int id;
    @Basic
    @Index
    private String url;
    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="source")
    private List<Item> items;
    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="source")
    private List<Event> events = new ArrayList<Event>();
    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="source")
    private List<Author> authors = new ArrayList<Author>();
    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="source")
    private List<Action> actions;
    @Transient
    private Workspace workspace;
    @Transient
    private SourceConfiguration config;

    public Source() {
        this.items = new ArrayList<Item>();
        this.actions = new ArrayList<Action>();
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public Workspace getWorkspace() {
        if (this.workspace == null) {
            throw new RuntimeException("No workspace available for this source");
        }
        return this.workspace;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<Author> authors) {
        this.authors = authors;
    }

    public SourceConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(SourceConfiguration config) {
        this.config = config;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String toString() {
        return "Source: " + this.url;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

