/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.output;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class FileUtils {
    public static void copyFile(String srcPlugin, String srcLocation, IFolder dest, IProgressMonitor monitor) {
        Bundle bundle = Platform.getBundle((String)srcPlugin);
        try {
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(srcLocation), null);
            if (url != null) {
                InputStream is = FileLocator.resolve((URL)url).openStream();
                IFile newFile = dest.getFile(FilenameUtils.getName((String)url.getPath()));
                newFile.create(is, true, monitor);
            } else {
                System.err.println("Could not found file");
            }
        }
        catch (Exception e) {
            System.err.println("Could not copy the file: " + e.getMessage());
        }
    }

    public static void copyFile(String srcPlugin, String srcLocation, java.nio.file.Path dest) {
        Bundle bundle = Platform.getBundle((String)srcPlugin);
        try {
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(srcLocation), null);
            if (url != null) {
                InputStream is = FileLocator.resolve((URL)url).openStream();
                CopyOption[] options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(is, dest, options);
            } else {
                System.err.println("Could not found file");
            }
        }
        catch (Exception e) {
            System.err.println("Could not copy the file: " + e.getMessage());
        }
    }

    public static void copyDirectory(String srcPlugin, String srcLocation, String dest) {
        Bundle bundle = Platform.getBundle((String)srcPlugin);
        try {
            if (bundle != null) {
                URL[] files = FileLocator.findEntries((Bundle)bundle, (IPath)new Path(srcLocation));
                Enumeration contents = bundle.getEntryPaths(new File(files[0].getPath()).getPath());
                while (contents.hasMoreElements()) {
                    String file = (String)contents.nextElement();
                    FileUtils.copyFile(srcPlugin, file, Paths.get(String.valueOf(dest) + "/" + new File(file).getName(), new String[0]));
                }
            } else {
                System.err.println("Could not found file");
            }
        }
        catch (Exception e) {
            System.err.println("Could not copy the file: " + e.getMessage());
        }
    }

    public static String getFileContent(String srcPlugin, String srcLocation, IProgressMonitor monitor) {
        Bundle bundle = Platform.getBundle((String)srcPlugin);
        String content = "";
        try {
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(srcLocation), null);
            if (url != null) {
                InputStream is = FileLocator.resolve((URL)url).openStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
                String cLine = null;
                while ((cLine = in.readLine()) != null) {
                    content = String.valueOf(content) + "\t \t\t" + cLine + System.getProperty("line.separator");
                }
                in.close();
            } else {
                System.err.println("Could not found file");
            }
        }
        catch (Exception e) {
            System.err.println("Could not copy the file: " + e.getMessage());
        }
        return content;
    }
}

