/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.output;

import fr.labri.harmony.core.analysis.AbstractAnalysis;
import fr.labri.harmony.core.analysis.AbstractPostProcessingAnalysis;
import fr.labri.harmony.core.model.Source;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class OutputUtils {
    public static Path buildOutputPath(Source src, AbstractAnalysis analysis, String fileName) throws IOException {
        String baseUrl = analysis.getConfig().getFoldersConfiguration().getOutFolder();
        String pathOnServer = "";
        if (src.getConfig().getPathOnServer() != null) {
            pathOnServer = src.getConfig().getPathOnServer();
        }
        String urlFolder = OutputUtils.convertToFolderName(String.valueOf(src.getUrl()) + pathOnServer);
        Path outputPath = Paths.get(baseUrl, urlFolder, analysis.getName());
        File outputFolder = outputPath.toFile();
        if (!outputFolder.exists()) {
            outputFolder.mkdirs();
        }
        outputPath = Paths.get(outputPath.toString(), fileName);
        return outputPath;
    }

    public static Path buildOutputPath(Source src, AbstractPostProcessingAnalysis analysis, String fileName) throws IOException {
        String baseUrl = analysis.getConfig().getFoldersConfiguration().getOutFolder();
        String pathOnServer = "";
        if (src.getConfig().getPathOnServer() != null) {
            pathOnServer = src.getConfig().getPathOnServer();
        }
        String urlFolder = OutputUtils.convertToFolderName(String.valueOf(src.getUrl()) + pathOnServer);
        Path outputPath = Paths.get(baseUrl, urlFolder, analysis.getName());
        File outputFolder = outputPath.toFile();
        if (!outputFolder.exists()) {
            outputFolder.mkdirs();
        }
        outputPath = Paths.get(outputPath.toString(), fileName);
        return outputPath;
    }

    private static String convertToFolderName(String src) {
        return src.replaceAll("http://", "").replaceAll("https://", "").replaceAll("/", "-").replaceAll(":", "").replaceAll("$", "");
    }
}

