/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.source;

import fr.labri.harmony.core.log.HarmonyLogger;
import fr.labri.harmony.core.model.Action;
import fr.labri.harmony.core.model.ActionKind;
import fr.labri.harmony.core.source.AbstractWorkspace;
import fr.labri.harmony.core.source.SourceExtractor;
import fr.labri.harmony.core.source.WorkspaceException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;

public abstract class AbstractLocalWorkspace
extends AbstractWorkspace {
    protected String path;

    public AbstractLocalWorkspace(SourceExtractor<?> sourceExtractor) {
        super(sourceExtractor);
    }

    @Override
    public void init() {
        try {
            URL url = new URL(this.getUrl());
            File workspaceDir = new File(String.valueOf(this.getTmpPath()) + "/" + url.getHost() + url.getPath());
            FileUtils.forceMkdir((File)workspaceDir);
            this.path = workspaceDir.getAbsolutePath();
            if (this.isInitialized()) {
                HarmonyLogger.info("Initializing existing local workspace at: " + this.getPath());
                this.initExistingWorkspace();
            } else {
                HarmonyLogger.info("Initializing new local workspace at: " + this.getPath());
                FileUtils.cleanDirectory((File)workspaceDir);
                this.initNewWorkspace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public abstract boolean isInitialized();

    public abstract void initNewWorkspace();

    public abstract void initExistingWorkspace();

    @Override
    public void clean() throws WorkspaceException {
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getFileContentAfter(Action action) {
        if (action.getKind().equals((Object)ActionKind.Delete)) {
            return null;
        }
        this.update(action.getEvent(), action.getItem());
        String itemPath = String.valueOf(this.getPath()) + "/" + action.getItem().getNativeId();
        try {
            return FileUtils.readFileToString((File)new File(itemPath));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getFileContentBefore(Action action) {
        if (action.getKind().equals((Object)ActionKind.Create)) {
            return null;
        }
        this.update(action.getParentEvent(), action.getItem());
        String itemPath = String.valueOf(this.getPath()) + "/" + action.getItem().getNativeId();
        try {
            return FileUtils.readFileToString((File)new File(itemPath));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

