/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.source;

import fr.labri.harmony.core.AbstractHarmonyService;
import fr.labri.harmony.core.analysis.Analysis;
import fr.labri.harmony.core.config.model.SourceConfiguration;
import fr.labri.harmony.core.dao.Dao;
import fr.labri.harmony.core.log.HarmonyLogger;
import fr.labri.harmony.core.model.Action;
import fr.labri.harmony.core.model.Author;
import fr.labri.harmony.core.model.Event;
import fr.labri.harmony.core.model.Item;
import fr.labri.harmony.core.model.Source;
import fr.labri.harmony.core.source.SourceExtractor;
import fr.labri.harmony.core.source.Workspace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public abstract class AbstractSourceExtractor<W extends Workspace>
extends AbstractHarmonyService
implements SourceExtractor<W> {
    public static final String COMMIT_MESSAGE = "commit_message";
    public static final String COMMITTER = "committer";
    public static final String BRANCH = "branch";
    private static final int EVENT_CACHE_SIZE = 1000;
    private static final int ACTION_CACHE_SIZE = 1000;
    protected W workspace;
    protected Source source;
    protected List<Analysis> analyses;
    private HashMap<String, Event> eventsCache;
    private HashMap<String, Author> authors;
    private List<Author> authorsCache;
    private HashMap<String, Item> items;
    private List<Item> itemsCache;
    private List<Action> actionsCache;
    protected SourceConfiguration config;

    public AbstractSourceExtractor(SourceConfiguration config, Dao dao, Properties properties) {
        super(dao, properties);
        this.config = config;
        this.analyses = new ArrayList<Analysis>();
        this.eventsCache = new HashMap();
        this.authors = new HashMap();
        this.authorsCache = new ArrayList<Author>();
        this.items = new HashMap();
        this.itemsCache = new ArrayList<Item>();
        this.actionsCache = new ArrayList<Action>();
    }

    public AbstractSourceExtractor() {
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public W getWorkspace() {
        return this.workspace;
    }

    public String getUrl() {
        return this.config.getRepositoryURL();
    }

    @Override
    public SourceConfiguration getConfig() {
        return this.config;
    }

    @Override
    public String getPersitenceUnitName() {
        return "harmony";
    }

    @Override
    public void initializeSource(boolean extractHarmonyModel, boolean extractActions) {
        HarmonyLogger.info("Initializing Workspace for source " + this.getUrl());
        this.initializeWorkspace();
        this.source = new Source();
        this.source.setUrl(this.getUrl());
        this.source.setWorkspace((Workspace)this.workspace);
        this.dao.saveSource(this.source);
        if (extractHarmonyModel) {
            HarmonyLogger.info("Extracting Events for source " + this.getUrl());
            this.extractEvents();
            this.saveAuthorsAndEvents();
            if (extractActions) {
                HarmonyLogger.info("Extracting Actions for source " + this.getUrl());
                for (Event e : this.dao.getEvents(this.source)) {
                    this.extractActions(e);
                }
                this.saveItemsAndActions();
            }
            this.source = this.dao.reloadSource(this.source);
        }
        this.source.setConfig(this.getConfig());
        this.onExtractionFinished();
    }

    @Override
    public void initializeExistingSource(Source src) {
        this.source = src;
        try {
            this.initializeWorkspace();
        }
        catch (Exception exception) {
            HarmonyLogger.info("Workspace couldn't be initialized for source: " + src.getUrl());
        }
        this.source.setWorkspace((Workspace)this.workspace);
        this.source.setConfig(this.getConfig());
    }

    protected void onExtractionFinished() {
        HarmonyLogger.info("Extraction finished for source " + this.source.getUrl());
    }

    protected Event getEvent(String nativeId) {
        Event e = this.eventsCache.get(nativeId);
        if (e == null) {
            e = this.dao.getEvent(this.source, nativeId);
        }
        return e;
    }

    protected void saveEvent(Event e) {
        this.eventsCache.put(e.getNativeId(), e);
        if (this.eventsCache.size() >= 1000) {
            this.saveAuthorsAndEvents();
        }
    }

    protected Author getAuthor(String name) {
        return this.authors.get(name);
    }

    protected void saveAuthor(Author a) {
        this.authors.put(a.getName(), a);
        this.authorsCache.add(a);
    }

    protected void saveAuthorsAndEvents() {
        this.dao.saveAuthors(this.authorsCache);
        this.authorsCache.clear();
        this.dao.saveEvents(this.eventsCache.values());
        this.eventsCache.clear();
    }

    protected Item getItem(String path) {
        return this.items.get(path);
    }

    protected void saveItem(Item i) {
        this.items.put(i.getNativeId(), i);
        this.itemsCache.add(i);
    }

    protected void saveAction(Action a) {
        this.actionsCache.add(a);
        if (this.actionsCache.size() >= 1000) {
            this.saveItemsAndActions();
        }
    }

    protected void saveItemsAndActions() {
        this.dao.saveItems(this.itemsCache);
        this.itemsCache.clear();
        this.dao.saveActions(this.actionsCache);
        this.actionsCache.clear();
    }
}

