/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.core.source;

import fr.labri.harmony.core.AbstractHarmonyService;
import fr.labri.harmony.core.config.model.SourceConfiguration;
import fr.labri.harmony.core.dao.Dao;
import fr.labri.harmony.core.log.HarmonyLogger;
import fr.labri.harmony.core.source.SourceExtractor;
import java.util.Collection;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class SourceExtractorFactory {
    private Dao dao;

    public SourceExtractorFactory(Dao dao) {
        this.dao = dao;
    }

    public SourceExtractor<?> createSourceExtractor(SourceConfiguration config) {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        try {
            Collection refs = context.getServiceReferences(SourceExtractor.class, AbstractHarmonyService.getFilter(config.getSourceExtractorName()));
            if (refs != null && !refs.isEmpty()) {
                ServiceReference ref = (ServiceReference)refs.iterator().next();
                if (refs.size() > 1) {
                    HarmonyLogger.info("Multiple implementations of the source extractor +config.getSourceExtractorName()+ have been found. The first one found has been selected");
                }
                Properties properties = this.extractProperties(ref);
                SourceExtractor serviceDef = (SourceExtractor)context.getService(ref);
                SourceExtractor service = (SourceExtractor)serviceDef.getClass().getConstructor(SourceConfiguration.class, Dao.class, Properties.class).newInstance(config, this.dao, properties);
                return service;
            }
            HarmonyLogger.error("The source extractor: " + config.getSourceExtractorName() + " required for: " + config.getRepositoryURL() + " could not be found");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Properties extractProperties(ServiceReference<?> ref) {
        Properties properties = new Properties();
        String[] stringArray = ref.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            properties.put(key, ref.getProperty(key));
            ++n2;
        }
        return properties;
    }
}

