/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.io.CharTypes;
import java.util.Set;

public final class XmlReadContext
extends JsonStreamContext {
    protected final XmlReadContext _parent;
    protected int _lineNr;
    protected int _columnNr;
    protected String _currentName;
    protected Set<String> _namesToWrap;
    protected String _wrappedName;
    protected XmlReadContext _child = null;

    public XmlReadContext(XmlReadContext xmlReadContext, int n, int n2, int n3) {
        this._type = n;
        this._parent = xmlReadContext;
        this._lineNr = n2;
        this._columnNr = n3;
        this._index = -1;
    }

    protected final void reset(int n, int n2, int n3) {
        this._type = n;
        this._index = -1;
        this._lineNr = n2;
        this._columnNr = n3;
        this._currentName = null;
        this._namesToWrap = null;
    }

    public static XmlReadContext createRootContext(int n, int n2) {
        return new XmlReadContext(null, 0, n, n2);
    }

    public static XmlReadContext createRootContext() {
        return new XmlReadContext(null, 0, 1, 0);
    }

    public final XmlReadContext createChildArrayContext(int n, int n2) {
        XmlReadContext xmlReadContext = this._child;
        if (xmlReadContext == null) {
            this._child = xmlReadContext = new XmlReadContext(this, 1, n, n2);
            return xmlReadContext;
        }
        xmlReadContext.reset(1, n, n2);
        return xmlReadContext;
    }

    public final XmlReadContext createChildObjectContext(int n, int n2) {
        XmlReadContext xmlReadContext = this._child;
        if (xmlReadContext == null) {
            this._child = xmlReadContext = new XmlReadContext(this, 2, n, n2);
            return xmlReadContext;
        }
        xmlReadContext.reset(2, n, n2);
        return xmlReadContext;
    }

    public final String getCurrentName() {
        return this._currentName;
    }

    public final XmlReadContext getParent() {
        return this._parent;
    }

    public final boolean expectComma() {
        throw new UnsupportedOperationException();
    }

    public void setCurrentName(String string) {
        this._currentName = string;
    }

    public final JsonLocation getStartLocation(Object object) {
        long l = -1L;
        return new JsonLocation(object, l, this._lineNr, this._columnNr);
    }

    public void setNamesToWrap(Set<String> set) {
        this._namesToWrap = set;
    }

    public Set<String> getNamesToWrap() {
        return this._namesToWrap;
    }

    protected void convertToArray() {
        this._type = 1;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                stringBuilder.append("/");
                break;
            }
            case 1: {
                stringBuilder.append('[');
                stringBuilder.append(this.getCurrentIndex());
                stringBuilder.append(']');
                break;
            }
            case 2: {
                stringBuilder.append('{');
                if (this._currentName != null) {
                    stringBuilder.append('\"');
                    CharTypes.appendQuoted((StringBuilder)stringBuilder, (String)this._currentName);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append('}');
            }
        }
        return stringBuilder.toString();
    }
}

