/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.actions;

import fr.labri.gumtree.actions.Action;
import fr.labri.gumtree.actions.ClassifyTrees;
import fr.labri.gumtree.actions.Delete;
import fr.labri.gumtree.actions.Insert;
import fr.labri.gumtree.actions.Move;
import fr.labri.gumtree.actions.Update;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.Tree;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassifyRootsAndLeaves
extends ClassifyTrees {
    private Set<Tree> srcModifiedTrees;
    private Set<Tree> dstModifiedTrees;

    public ClassifyRootsAndLeaves(Tree src, Tree dst, Set<Mapping> rawMappings, List<Action> actions) {
        super(src, dst, rawMappings, actions);
    }

    public ClassifyRootsAndLeaves(Tree src, Tree dst, Matcher m) {
        super(src, dst, m);
    }

    @Override
    public void classify() {
        this.srcModifiedTrees = new HashSet<Tree>();
        this.dstModifiedTrees = new HashSet<Tree>();
        for (Action a : this.actions) {
            if (a instanceof Insert) {
                this.dstModifiedTrees.add(a.getNode());
                this.dstAddTrees.add(a.getNode());
                continue;
            }
            if (a instanceof Delete) {
                this.srcModifiedTrees.add(a.getNode());
                this.srcDelTrees.add(a.getNode());
                continue;
            }
            if (a instanceof Update) {
                this.srcModifiedTrees.add(a.getNode());
                this.srcUpdTrees.add(a.getNode());
                this.dstModifiedTrees.add(this.mappings.getDst(a.getNode()));
                this.dstUpdTrees.add(this.mappings.getDst(a.getNode()));
                continue;
            }
            if (!(a instanceof Move)) continue;
            this.srcModifiedTrees.add(a.getNode());
            this.srcMvTrees.add(a.getNode());
            this.dstModifiedTrees.add(this.mappings.getDst(a.getNode()));
            this.dstMvTrees.add(this.mappings.getDst(a.getNode()));
        }
        HashSet fDstAddTrees = new HashSet(this.dstAddTrees);
        for (Tree t : this.dstAddTrees) {
            if (!this.dstAddTrees.containsAll(t.getDescendants())) continue;
            fDstAddTrees.removeAll(t.getDescendants());
        }
        this.dstAddTrees = fDstAddTrees;
        HashSet fSrcDelTrees = new HashSet(this.srcDelTrees);
        for (Tree t : this.srcDelTrees) {
            if (!this.srcDelTrees.containsAll(t.getDescendants())) continue;
            fSrcDelTrees.removeAll(t.getDescendants());
        }
        this.srcDelTrees = fSrcDelTrees;
    }

    public int dstDepth(Tree dst) {
        int d = 1;
        for (Tree p : dst.getParents()) {
            if (!this.dstModifiedTrees.contains(p)) continue;
            ++d;
        }
        return d;
    }

    public int srcDepth(Tree src) {
        int d = 1;
        for (Tree p : src.getParents()) {
            if (!this.srcModifiedTrees.contains(p)) continue;
            ++d;
        }
        return d;
    }
}

