/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.actions;

import fr.labri.gumtree.actions.Action;
import fr.labri.gumtree.actions.GenerateActions;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ClassifyTrees {
    protected Set<Tree> srcUpdTrees;
    protected Set<Tree> dstUpdTrees;
    protected Set<Tree> srcMvTrees;
    protected Set<Tree> dstMvTrees;
    protected Set<Tree> srcDelTrees;
    protected Set<Tree> dstAddTrees;
    protected Tree src;
    protected Tree dst;
    protected MappingStore mappings;
    protected List<Action> actions;

    public ClassifyTrees(Tree src, Tree dst, Set<Mapping> rawMappings, List<Action> actions) {
        this(src, dst, rawMappings);
        this.actions = actions;
        this.classify();
    }

    public ClassifyTrees(Tree src, Tree dst, Matcher m) {
        this(src, dst, m.getMappingSet());
        GenerateActions g = new GenerateActions(src, dst, m.getMappingSet());
        this.actions = g.getActions();
        this.classify();
    }

    private ClassifyTrees(Tree src, Tree dst, Set<Mapping> rawMappings) {
        this.src = src;
        this.dst = dst;
        this.mappings = new MappingStore(rawMappings);
        this.srcDelTrees = new HashSet<Tree>();
        this.srcMvTrees = new HashSet<Tree>();
        this.srcUpdTrees = new HashSet<Tree>();
        this.dstMvTrees = new HashSet<Tree>();
        this.dstAddTrees = new HashSet<Tree>();
        this.dstUpdTrees = new HashSet<Tree>();
    }

    public abstract void classify();

    public Set<Tree> getSrcUpdTrees() {
        return this.srcUpdTrees;
    }

    public Set<Tree> getDstUpdTrees() {
        return this.dstUpdTrees;
    }

    public Set<Tree> getSrcMvTrees() {
        return this.srcMvTrees;
    }

    public Set<Tree> getDstMvTrees() {
        return this.dstMvTrees;
    }

    public Set<Tree> getSrcDelTrees() {
        return this.srcDelTrees;
    }

    public Set<Tree> getDstAddTrees() {
        return this.dstAddTrees;
    }
}

