/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client;

import fr.labri.gumtree.client.DiffOptions;
import fr.labri.gumtree.client.MatcherFactory;
import fr.labri.gumtree.client.TreeGeneratorRegistry;
import fr.labri.gumtree.client.ui.swing.SwingDiff;
import fr.labri.gumtree.client.ui.web.WebDiff;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Tree;
import java.io.IOException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public abstract class DiffClient {
    protected DiffOptions diffOptions;

    public static void main(String[] args) {
        DiffOptions diffOptions = new DiffOptions();
        CmdLineParser parser = new CmdLineParser(diffOptions);
        try {
            parser.parseArgument(args);
            DiffClient client = "swing".equals(diffOptions.getOutput()) ? new SwingDiff(diffOptions) : new WebDiff(diffOptions);
            client.start();
        }
        catch (CmdLineException e) {
            e.printStackTrace();
        }
    }

    public DiffClient(DiffOptions diffOptions) {
        this.diffOptions = diffOptions;
    }

    public abstract void start();

    protected Matcher getMatcher() {
        return MatcherFactory.createMatcher(this.getSrcTree(), this.getDstTree(), this.diffOptions.getMatcher());
    }

    private Tree getSrcTree() {
        return this.getTree(this.diffOptions.getSrc());
    }

    private Tree getDstTree() {
        return this.getTree(this.diffOptions.getDst());
    }

    private Tree getTree(String file) {
        try {
            Tree t = TreeGeneratorRegistry.getInstance().getTree(file, this.diffOptions.getGenerators());
            return t;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

