/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client;

import fr.labri.gumtree.matchers.composite.GumtreeMatcher;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Tree;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class MatcherFactory {
    public static Matcher createMatcher(Tree src, Tree dst, String name) {
        if (name != null) {
            try {
                Class<?> clazz = Class.forName(name);
                Constructor<?> constructor = clazz.getConstructor(Tree.class, Tree.class);
                Matcher m = (Matcher)constructor.newInstance(src, dst);
                return m;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return new GumtreeMatcher(src, dst);
    }

    public static Matcher createMatcher(Tree src, Tree dst) {
        return MatcherFactory.createMatcher(src, dst, null);
    }
}

