/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client;

import fr.labri.gumtree.gen.jdt.JdtTreeGenerator;
import fr.labri.gumtree.gen.jdt.cd.CdJdtTreeGenerator;
import fr.labri.gumtree.gen.js.RhinoTreeGenerator;
import fr.labri.gumtree.gen.xml.XMLTreeGenerator;
import fr.labri.gumtree.io.TreeGenerator;
import fr.labri.gumtree.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TreeGeneratorRegistry {
    private final List<TreeGenerator> producers = new ArrayList<TreeGenerator>();
    private static TreeGeneratorRegistry registry;

    public static final TreeGeneratorRegistry getInstance() {
        if (registry == null) {
            registry = new TreeGeneratorRegistry();
        }
        return registry;
    }

    private TreeGeneratorRegistry() {
        this.producers.add(new JdtTreeGenerator());
        this.producers.add(new CdJdtTreeGenerator());
        this.producers.add(new RhinoTreeGenerator());
        this.producers.add(new XMLTreeGenerator());
    }

    private TreeGenerator getGenerator(String file, String[] generators) {
        TreeGenerator fallback = null;
        for (TreeGenerator p : this.producers) {
            if (!p.handleFile(file)) continue;
            if (generators == null) {
                return p;
            }
            if (fallback == null) {
                fallback = p;
            }
            if (Arrays.binarySearch(generators, p.getName()) == -1) continue;
            return p;
        }
        if (fallback != null) {
            return fallback;
        }
        return null;
    }

    public Tree getTree(String file) throws IOException {
        TreeGenerator p = this.getGenerator(file, null);
        return p.generate(file);
    }

    public Tree getTree(String file, String[] generators) throws IOException {
        TreeGenerator p = this.getGenerator(file, generators);
        return p.generate(file);
    }
}

