/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.batch;

import fr.labri.gumtree.client.batch.AbstractProcessor;
import fr.labri.gumtree.tree.Pair;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;

public abstract class AbstractFilePairsProcessor
extends AbstractProcessor {
    public AbstractFilePairsProcessor(String folder) {
        super(folder);
    }

    @Override
    public void process() {
        this.init();
        ArrayList<Pair<String, String>> filePairs = new ArrayList<Pair<String, String>>();
        for (File file : new TreeSet<File>(Arrays.asList(new File(this.inFolder).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("_v0.");
            }
        })))) {
            String dst = file.getAbsolutePath().replace("_v0.", "_v1.");
            if (!file.exists() || !new File(dst).exists()) continue;
            filePairs.add(new Pair<String, String>(file.getAbsolutePath(), dst));
        }
        for (Pair pair : filePairs) {
            try {
                LOGGER.info("Processing files:\n\t" + (String)pair.getFirst() + "\n\t" + (String)pair.getSecond());
                this.processFilePair((String)pair.getFirst(), (String)pair.getSecond());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.finish();
    }

    public abstract void processFilePair(String var1, String var2) throws IOException;
}

