/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.batch;

import fr.labri.gumtree.client.batch.AbstractProcessor;
import fr.labri.gumtree.client.batch.FileUtils;
import java.io.File;
import java.io.IOException;

public abstract class AbstractFileProcessor
extends AbstractProcessor {
    protected String outFolder;
    public static final String DEFAULT_OUT_FOLDER = "out";

    public AbstractFileProcessor(String inFolder, String outFolder) {
        super(inFolder);
        this.outFolder = outFolder;
    }

    public AbstractFileProcessor(String inFolder) {
        this(inFolder, String.valueOf(inFolder) + File.separatorChar + DEFAULT_OUT_FOLDER);
    }

    @Override
    public void process() {
        this.init();
        File f = new File(this.inFolder);
        if (f.exists() && f.isDirectory()) {
            for (File file : FileUtils.listAllFiles(f)) {
                try {
                    LOGGER.info("Processing file: " + file);
                    if (!file.isFile()) continue;
                    this.process(file.getAbsolutePath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.finish();
    }

    public abstract void process(String var1) throws IOException;
}

