/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.batch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.logging.Logger;

public abstract class AbstractProcessor {
    public static final Logger LOGGER = Logger.getLogger("fr.labri.gumtree.client.batch");
    protected String inFolder;

    public AbstractProcessor(String folder) {
        this.inFolder = folder;
    }

    public abstract void process();

    protected void init() {
    }

    protected void finish() {
    }

    protected void ensureFolder(String name) {
        File f = new File(String.valueOf(this.inFolder) + File.separatorChar + name);
        if (f.exists() && !f.isDirectory()) {
            f.delete();
        }
        if (!f.exists()) {
            f.mkdir();
        }
    }

    protected String nextFile(String folder, String prefix, String ext) {
        int nb = 0;
        HashSet<String> files = new HashSet<String>();
        String[] stringArray = new File(String.valueOf(this.inFolder) + File.separatorChar + folder).list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            files.add(f);
            ++n2;
        }
        String next = String.valueOf(prefix) + "_" + nb + "." + ext;
        while (files.contains(next)) {
            next = String.valueOf(prefix) + "_" + ++nb + "." + ext;
        }
        return String.valueOf(this.inFolder) + File.separatorChar + folder + File.separatorChar + next;
    }

    protected void copyResource(String url, String dest) {
        try {
            InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream(url);
            FileOutputStream out = new FileOutputStream(String.valueOf(this.inFolder) + File.separatorChar + dest);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = in.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String fileName(String file) {
        return new File(file).getName();
    }

    protected String fileExtension(String file) {
        return file.substring(file.lastIndexOf("."));
    }

    protected long tic() {
        return System.currentTimeMillis();
    }
}

