/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.batch;

import fr.labri.gumtree.actions.ClassifyRoots;
import fr.labri.gumtree.client.MatcherFactory;
import fr.labri.gumtree.client.TreeGeneratorRegistry;
import fr.labri.gumtree.client.batch.AbstractFilePairsProcessor;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class ActionDistributionProcessor
extends AbstractFilePairsProcessor {
    private Map<String, Integer> dist;

    public static void main(String[] args) {
        ActionDistributionProcessor g = new ActionDistributionProcessor(args[0]);
        g.process();
    }

    public ActionDistributionProcessor(String folder) {
        super(folder);
    }

    @Override
    protected void init() {
        this.ensureFolder("out");
        this.dist = new HashMap<String, Integer>();
    }

    @Override
    public void processFilePair(String fsrc, String fdst) throws IOException {
        Tree src = TreeGeneratorRegistry.getInstance().getTree(fsrc);
        Tree dst = TreeGeneratorRegistry.getInstance().getTree(fdst);
        Matcher matcher = MatcherFactory.createMatcher(src, dst);
        ClassifyRoots c = new ClassifyRoots(src, dst, matcher);
        c.classify();
        MappingStore mappings = matcher.getMappings();
        for (Tree t : c.getDstUpdTrees()) {
            this.inc("UPD " + t.getTypeLabel() + " IN " + t.getParent().getTypeLabel());
        }
        for (Tree t : c.getSrcDelTrees()) {
            if (c.getSrcDelTrees().contains(t.getParent())) continue;
            this.inc("DEL " + t.getTypeLabel() + " IN " + t.getParent().getTypeLabel());
        }
        for (Tree t : c.getDstAddTrees()) {
            if (c.getDstAddTrees().contains(t.getParent())) continue;
            this.inc("ADD " + t.getTypeLabel() + " IN " + t.getParent().getTypeLabel());
        }
        for (Tree t : c.getSrcMvTrees()) {
            if (c.getSrcMvTrees().contains(t.getParent())) continue;
            this.inc("MOV " + t.getTypeLabel() + " FROM " + t.getParent().getTypeLabel() + " TO " + mappings.getDst(t).getParent().getTypeLabel());
        }
    }

    private void inc(String key) {
        if (!this.dist.containsKey(key)) {
            this.dist.put(key, 1);
        } else {
            this.dist.put(key, this.dist.get(key) + 1);
        }
    }

    @Override
    protected void finish() {
        try {
            String name = this.nextFile("out", "dist", "csv");
            FileWriter w = new FileWriter(name);
            w.append("ACTION;NB\n");
            TreeSet<String> keys = new TreeSet<String>(this.dist.keySet());
            for (String key : keys) {
                w.append(String.format("%s;%d\n", key, this.dist.get(key)));
            }
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

