/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.batch;

import fr.labri.gumtree.client.TreeGeneratorRegistry;
import fr.labri.gumtree.client.batch.AbstractFileProcessor;
import fr.labri.gumtree.tree.DigestGenerator;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DigestProcessor
extends AbstractFileProcessor {
    private int stdTime;
    private int rStdTime;
    private int md5Time;
    private int rMd5Time;
    private int rRdmTime;
    private Map<Integer, Set<String>> stdDigests;
    private Map<Integer, Set<String>> rStdDigests;
    private Map<Integer, Set<String>> md5Digests;
    private Map<Integer, Set<String>> rMd5Digests;
    private Map<Integer, Set<String>> rRdmDigests;

    public static void main(String[] args) {
        DigestProcessor g = new DigestProcessor(args[0], "/home/falleri/Out/");
        g.process();
    }

    public DigestProcessor(String inFolder, String outFolder) {
        super(inFolder, outFolder);
    }

    @Override
    public void init() {
        this.stdTime = 0;
        this.rStdTime = 0;
        this.md5Time = 0;
        this.rMd5Time = 0;
        this.rRdmTime = 0;
        this.stdDigests = new HashMap<Integer, Set<String>>();
        this.rStdDigests = new HashMap<Integer, Set<String>>();
        this.md5Digests = new HashMap<Integer, Set<String>>();
        this.rMd5Digests = new HashMap<Integer, Set<String>>();
        this.rRdmDigests = new HashMap<Integer, Set<String>>();
    }

    @Override
    public void process(String file) throws IOException {
        Tree tree = TreeGeneratorRegistry.getInstance().getTree(file);
        long tic = this.tic();
        TreeUtils.computeDigest(tree, new DigestGenerator.StdHashGenerator());
        this.stdTime = (int)((long)this.stdTime + (this.tic() - tic));
        this.updateDigests(tree, this.stdDigests);
        tic = this.tic();
        TreeUtils.computeDigest(tree, new DigestGenerator.RollingStdHashGenerator());
        this.rStdTime = (int)((long)this.rStdTime + (this.tic() - tic));
        this.updateDigests(tree, this.rStdDigests);
        tic = this.tic();
        TreeUtils.computeDigest(tree, new DigestGenerator.Md5HashGenerator());
        this.md5Time = (int)((long)this.md5Time + (this.tic() - tic));
        this.updateDigests(tree, this.md5Digests);
        tic = this.tic();
        TreeUtils.computeDigest(tree, new DigestGenerator.RollingMd5HashGenerator());
        this.rMd5Time = (int)((long)this.rMd5Time + (this.tic() - tic));
        this.updateDigests(tree, this.rMd5Digests);
        tic = this.tic();
        TreeUtils.computeDigest(tree, new DigestGenerator.RollingMd5HashGenerator());
        this.rRdmTime = (int)((long)this.rRdmTime + (this.tic() - tic));
        this.updateDigests(tree, this.rRdmDigests);
    }

    private void updateDigests(Tree tree, Map<Integer, Set<String>> digests) {
        for (Tree t : tree.getTrees()) {
            int digest = t.getDigest();
            if (!digests.containsKey(digest)) {
                digests.put(digest, new HashSet());
            }
            digests.get(digest).add(t.toDigestTreeString());
        }
    }

    @Override
    public void finish() {
        LOGGER.info("Results for standard hash:");
        this.result(this.stdTime, this.stdDigests);
        LOGGER.info("Results for rolling standard hash:");
        this.result(this.rStdTime, this.rStdDigests);
        LOGGER.info("Results for md5 hash:");
        this.result(this.md5Time, this.md5Digests);
        LOGGER.info("Results for rolling md5 hash:");
        this.result(this.rMd5Time, this.rMd5Digests);
        LOGGER.info("Results for rolling random hash:");
        this.result(this.rRdmTime, this.rRdmDigests);
    }

    private void result(int time, Map<Integer, Set<String>> digests) {
        LOGGER.info(String.format("Total time: %d", time));
        int collisions = 0;
        for (int digest : digests.keySet()) {
            if (digests.get(digest).size() <= 1) continue;
            LOGGER.fine("Collision detected for digest: " + digest);
            LOGGER.fine(digests.get(digest).toString());
            collisions += digests.get(digest).size() - 1;
        }
        LOGGER.info(String.format("Total collisions: %d", collisions));
    }
}

