/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.batch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FileUtils {
    private FileUtils() {
    }

    public static String getExtension(String path) {
        return path.substring(path.lastIndexOf(".") + 1).toLowerCase();
    }

    public static void deleteFolder(String path) {
        FileUtils.deleteFolder(new File(path));
    }

    public static void deleteFolder(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                FileUtils.deleteFolder(new File(dir, children[i]));
                ++i;
            }
        }
        dir.delete();
    }

    public static String createTmpFolder(String prefix, String path) {
        try {
            File fTmpPath;
            File folder = null;
            folder = "".equals(path) ? ((fTmpPath = new File(path)).exists() && fTmpPath.canWrite() ? File.createTempFile(prefix, "", fTmpPath) : File.createTempFile(prefix, "")) : File.createTempFile(prefix, "");
            folder.delete();
            folder.mkdir();
            return folder.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void listAllFiles(File path, List<String> allFiles, String extension) {
        if (path.isDirectory()) {
            File[] list = path.listFiles();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    FileUtils.listAllFiles(list[i], allFiles, extension);
                    ++i;
                }
            }
        } else {
            String currentFilePath = path.getAbsolutePath();
            if (currentFilePath.toLowerCase().endsWith(extension)) {
                allFiles.add(currentFilePath);
            }
        }
    }

    public static List<File> listAllFiles(File path) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtils.listAllFiles(path, files);
        Collections.sort(files);
        return files;
    }

    public static void listAllFiles(File path, List<File> allFiles) {
        if (path.isDirectory()) {
            File[] list = path.listFiles();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    FileUtils.listAllFiles(list[i], allFiles);
                    ++i;
                }
            }
        } else {
            allFiles.add(path);
        }
    }
}

