/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.batch;

import fr.labri.gumtree.actions.Action;
import fr.labri.gumtree.actions.Delete;
import fr.labri.gumtree.actions.GenerateActions;
import fr.labri.gumtree.actions.Insert;
import fr.labri.gumtree.actions.Move;
import fr.labri.gumtree.actions.Update;
import fr.labri.gumtree.client.MatcherFactory;
import fr.labri.gumtree.client.TreeGeneratorRegistry;
import fr.labri.gumtree.client.batch.AbstractFilePairsProcessor;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Tree;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class MetricsProcessor
extends AbstractFilePairsProcessor {
    private FileWriter csv;

    public static void main(String[] args) {
        MetricsProcessor g = new MetricsProcessor(args[0]);
        g.process();
    }

    public MetricsProcessor(String folder) {
        super(folder);
    }

    @Override
    protected void init() {
        this.ensureFolder("out");
        this.copyResource("assets/gen_metrics_stats.r", "out/gen_metrics_stats.r");
        try {
            String fcsv = this.nextFile("out", "metrics", "csv");
            this.csv = new FileWriter(fcsv);
            this.csv.append("FILE_0;FILE_1;SIZE_0;SIZE_1;SIZE_SCRIPT;NB_INS;NB_UP;NB_DEL;NB_MV;T_PARSE;T_MATCH;T_SCRIPT;T_TOTAL\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processFilePair(String fsrc, String fdst) throws IOException {
        long tic = System.currentTimeMillis();
        Tree src = TreeGeneratorRegistry.getInstance().getTree(fsrc);
        Tree dst = TreeGeneratorRegistry.getInstance().getTree(fdst);
        long toc = System.currentTimeMillis();
        int sSrc = src.getSize();
        int sDst = dst.getSize();
        long tParse = toc - tic;
        tic = System.currentTimeMillis();
        Matcher matcher = MatcherFactory.createMatcher(src, dst);
        toc = System.currentTimeMillis();
        long tMatch = toc - tic;
        tic = System.currentTimeMillis();
        GenerateActions g = new GenerateActions(src, dst, matcher.getMappingSet());
        toc = System.currentTimeMillis();
        long tScript = toc - tic;
        long tTotal = tParse + tMatch + tScript;
        List<Action> actions = g.getActions();
        int sScript = actions.size();
        int sIns = 0;
        int sUp = 0;
        int sDel = 0;
        int sMv = 0;
        for (Action a : actions) {
            if (a instanceof Insert) {
                ++sIns;
                continue;
            }
            if (a instanceof Delete) {
                ++sDel;
                continue;
            }
            if (a instanceof Move) {
                ++sMv;
                continue;
            }
            if (!(a instanceof Update)) continue;
            ++sUp;
        }
        try {
            this.csv.append(String.format("%s;%s;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d\n", fsrc, fdst, sSrc, sDst, sScript, sIns, sDel, sUp, sMv, tParse, tMatch, tScript, tTotal));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void finish() {
        try {
            this.csv.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

