/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.batch;

import fr.labri.gumtree.client.MatcherFactory;
import fr.labri.gumtree.client.TreeGeneratorRegistry;
import fr.labri.gumtree.client.batch.AbstractFilePairsProcessor;
import fr.labri.gumtree.client.ui.web.BootstrapGenerator;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Tree;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public final class WebDiffProcessor
extends AbstractFilePairsProcessor {
    private static final String[] BOOTSTRAP_RESOURCES = new String[]{"assets/gumtree.js", "assets/gumtree.css", "assets/bootstrap.min.js", "assets/bootstrap.min.css", "assets/jquery.min.js"};

    public static void main(String[] args) {
        WebDiffProcessor g = new WebDiffProcessor(args[0]);
        g.process();
    }

    public WebDiffProcessor(String folder) {
        super(folder);
        this.ensureBootstrap();
    }

    @Override
    public void processFilePair(String fsrc, String fdst) throws IOException {
        Tree src = TreeGeneratorRegistry.getInstance().getTree(fsrc);
        Tree dst = TreeGeneratorRegistry.getInstance().getTree(fdst);
        Matcher matcher = MatcherFactory.createMatcher(src, dst);
        String diff = BootstrapGenerator.produceHTML(fsrc, fdst, src, dst, matcher);
        String f = String.valueOf(this.inFolder) + File.separatorChar + "diffs" + File.separatorChar + this.fileName(fsrc).replace("_v0.", "_diff.") + ".html";
        LOGGER.info("Generating file: " + f);
        FileWriter w = new FileWriter(f);
        w.append(diff);
        w.close();
    }

    private void ensureBootstrap() {
        this.ensureFolder("diffs");
        this.ensureFolder("diffs" + File.separatorChar + "assets");
        String[] stringArray = BOOTSTRAP_RESOURCES;
        int n = BOOTSTRAP_RESOURCES.length;
        int n2 = 0;
        while (n2 < n) {
            String res = stringArray[n2];
            this.copyResource(res, "diffs" + File.separatorChar + res);
            ++n2;
        }
    }
}

