/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.ui.swing;

import fr.labri.gumtree.actions.ClassifyRoots;
import fr.labri.gumtree.actions.ClassifyTrees;
import fr.labri.gumtree.client.ui.swing.TreePanel;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class MappingsPanel
extends JPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private Tree src;
    private Tree dst;
    private ClassifyTrees classifyTrees;
    private MappingStore mappings;
    private TreePanel panSrc;
    private TreePanel panDst;
    private JTextArea txtSrc;
    private JTextArea txtDst;
    private static final Color DEL_COLOR = new Color(190, 0, 0);
    private static final Color ADD_COLOR = new Color(0, 158, 0);
    private static final Color UPD_COLOR = new Color(189, 162, 0);
    private static final Color MV_COLOR = new Color(128, 0, 128);

    public MappingsPanel(String srcPath, String dstPath, Tree src, Tree dst, Matcher m) {
        super(new GridLayout(1, 0));
        this.src = src;
        this.dst = dst;
        this.classifyTrees = new ClassifyRoots(src, dst, m);
        this.mappings = new MappingStore(m.getMappingSet());
        this.panSrc = new TreePanel(src, new MappingsCellRenderer(true));
        this.panSrc.getJTree().addTreeSelectionListener(this);
        this.panDst = new TreePanel(dst, new MappingsCellRenderer(false));
        this.panDst.getJTree().addTreeSelectionListener(this);
        this.txtSrc = new JTextArea();
        this.txtDst = new JTextArea();
        JPanel top = new JPanel();
        top.setLayout(new GridLayout(1, 2));
        top.add(this.panSrc);
        top.add(this.panDst);
        JPanel bottom = new JPanel();
        bottom.setLayout(new GridLayout(1, 2));
        bottom.add(new JScrollPane(this.txtSrc));
        bottom.add(new JScrollPane(this.txtDst));
        JSplitPane split = new JSplitPane(0, top, bottom);
        split.setDividerLocation(650);
        this.add(split);
        try {
            this.txtSrc.getUI().getEditorKit(this.txtSrc).read(new FileReader(srcPath), this.txtSrc.getDocument(), 0);
            this.txtDst.getUI().getEditorKit(this.txtDst).read(new FileReader(dstPath), this.txtDst.getDocument(), 0);
        }
        catch (IOException | BadLocationException e) {
            e.printStackTrace();
        }
        this.setPreferredSize(new Dimension(1024, 768));
        this.openNodes();
    }

    private void openNodes() {
        for (Tree t : this.classifyTrees.getSrcDelTrees()) {
            this.openNode(this.panSrc, t);
        }
        for (Tree t : this.classifyTrees.getDstAddTrees()) {
            this.openNode(this.panDst, t);
        }
        for (Tree t : this.classifyTrees.getSrcUpdTrees()) {
            this.openNode(this.panSrc, t);
        }
        for (Tree t : this.classifyTrees.getDstUpdTrees()) {
            this.openNode(this.panDst, t);
        }
        for (Tree t : this.classifyTrees.getSrcMvTrees()) {
            this.openNode(this.panSrc, t);
        }
        for (Tree t : this.classifyTrees.getDstMvTrees()) {
            this.openNode(this.panDst, t);
        }
        this.panSrc.getJTree().scrollPathToVisible(new TreePath(this.panSrc.getTrees().get(this.src).getPath()));
        this.panDst.getJTree().scrollPathToVisible(new TreePath(this.panDst.getTrees().get(this.dst).getPath()));
    }

    private void openNode(TreePanel p, Tree t) {
        DefaultMutableTreeNode n = p.getTrees().get(t);
        p.getJTree().scrollPathToVisible(new TreePath(n.getPath()));
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        JTree jtree = (JTree)e.getSource();
        if (jtree.getSelectionPath() == null) {
            return;
        }
        Tree sel = (Tree)((DefaultMutableTreeNode)jtree.getLastSelectedPathComponent()).getUserObject();
        JTextArea selJTextArea = null;
        boolean isMapped = false;
        Tree match = null;
        TreePanel matchTreePanel = null;
        JTextArea matchJTextArea = null;
        if (jtree == this.panSrc.getJTree()) {
            selJTextArea = this.txtSrc;
            matchTreePanel = this.panDst;
            matchJTextArea = this.txtDst;
            if (this.mappings.hasSrc(sel)) {
                isMapped = true;
                match = this.mappings.getDst(sel);
            }
        } else {
            selJTextArea = this.txtDst;
            matchTreePanel = this.panSrc;
            matchJTextArea = this.txtSrc;
            if (this.mappings.hasDst(sel)) {
                isMapped = true;
                match = this.mappings.getSrc(sel);
            }
        }
        try {
            this.updateJTreeAndJTextArea(sel, selJTextArea, isMapped, match, matchTreePanel, matchJTextArea);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    private void updateJTreeAndJTextArea(Tree sel, JTextArea selJTextArea, boolean isMapped, Tree match, TreePanel matchTreePanel, JTextArea matchJTextArea) throws BadLocationException {
        selJTextArea.getHighlighter().removeAllHighlights();
        selJTextArea.getHighlighter().addHighlight(sel.getPos(), sel.getEndPos(), DefaultHighlighter.DefaultPainter);
        selJTextArea.setCaretPosition(sel.getPos());
        if (isMapped) {
            DefaultMutableTreeNode node = matchTreePanel.getTrees().get(match);
            matchTreePanel.getJTree().scrollPathToVisible(new TreePath(node.getPath()));
            matchTreePanel.getJTree().setSelectionPath(new TreePath(node.getPath()));
            matchJTextArea.getHighlighter().removeAllHighlights();
            matchJTextArea.getHighlighter().addHighlight(match.getPos(), match.getEndPos(), DefaultHighlighter.DefaultPainter);
            matchJTextArea.setCaretPosition(match.getPos());
        } else {
            matchTreePanel.getJTree().clearSelection();
            matchJTextArea.getHighlighter().removeAllHighlights();
        }
    }

    private class MappingsCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private boolean isSrc;

        public MappingsCellRenderer(boolean left) {
            this.isSrc = left;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jtree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(jtree, value, selected, expanded, leaf, row, hasFocus);
            Tree tree = (Tree)((DefaultMutableTreeNode)value).getUserObject();
            if (this.isSrc && MappingsPanel.this.classifyTrees.getSrcDelTrees().contains(tree)) {
                this.setForeground(DEL_COLOR);
            } else if (!this.isSrc && MappingsPanel.this.classifyTrees.getDstAddTrees().contains(tree)) {
                this.setForeground(ADD_COLOR);
            } else if (this.isSrc && MappingsPanel.this.classifyTrees.getSrcUpdTrees().contains(tree)) {
                this.setForeground(UPD_COLOR);
            } else if (!this.isSrc && MappingsPanel.this.classifyTrees.getDstUpdTrees().contains(tree)) {
                this.setForeground(UPD_COLOR);
            } else if (this.isSrc && MappingsPanel.this.classifyTrees.getSrcMvTrees().contains(tree)) {
                this.setForeground(MV_COLOR);
            } else if (!this.isSrc && MappingsPanel.this.classifyTrees.getDstMvTrees().contains(tree)) {
                this.setForeground(MV_COLOR);
            }
            return this;
        }
    }
}

