/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.ui.swing;

import fr.labri.gumtree.tree.Tree;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class TreePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTree jtree;
    private Tree tree;
    private Map<Tree, DefaultMutableTreeNode> trees = new HashMap<Tree, DefaultMutableTreeNode>();

    public TreePanel(Tree tree, TreeCellRenderer renderer) {
        super(new GridLayout(1, 0));
        this.tree = tree;
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(tree);
        this.trees.put(tree, top);
        for (Tree child : tree.getChildren()) {
            this.createNodes(top, child);
        }
        this.jtree = new JTree(top);
        this.jtree.setCellRenderer(renderer);
        this.jtree.getSelectionModel().setSelectionMode(1);
        JScrollPane treeView = new JScrollPane(this.jtree);
        Dimension minimumSize = new Dimension(100, 50);
        treeView.setMinimumSize(minimumSize);
        this.add(treeView);
    }

    public TreePanel(Tree tree) {
        this(tree, new DefaultTreeCellRenderer());
    }

    public JTree getJTree() {
        return this.jtree;
    }

    public Map<Tree, DefaultMutableTreeNode> getTrees() {
        return this.trees;
    }

    public Tree getTree() {
        return this.tree;
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jtree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        System.out.println(nodeInfo);
    }

    private void createNodes(DefaultMutableTreeNode parent, Tree tree) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(tree);
        this.trees.put(tree, node);
        parent.add(node);
        for (Tree child : tree.getChildren()) {
            this.createNodes(node, child);
        }
    }
}

