/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.ui.web;

import fr.labri.gumtree.actions.GenerateActions;
import fr.labri.gumtree.client.ui.web.BootstrapGenerator;
import fr.labri.gumtree.client.ui.web.NanoHTTPD;
import fr.labri.gumtree.io.SerializeEditScript;
import fr.labri.gumtree.io.TreeIoUtils;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Tree;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class DiffServer
extends NanoHTTPD {
    public static final int PORT = 4754;
    private String fSrc;
    private String fDst;
    private Tree tSrc;
    private Tree tDst;
    private Matcher matcher;

    public DiffServer(String fSrc, String fDst, Tree tSrc, Tree tDst, Matcher matcher) {
        super(4754);
        this.fSrc = fSrc;
        this.fDst = fDst;
        this.tSrc = tSrc;
        this.tDst = tDst;
        this.matcher = matcher;
    }

    public static void start(NanoHTTPD server) {
        try {
            server.start();
        }
        catch (IOException ioe) {
            System.err.println("Couldn't start server:" + ioe);
            System.exit(-1);
        }
        System.out.println("Server running on url: http://localhost:4754");
        try {
            System.in.read();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        server.stop();
        System.out.println("Server stopped.\n");
    }

    @Override
    public NanoHTTPD.Response serve(String uri, NanoHTTPD.Method method, Map<String, String> header, Map<String, String> parms, Map<String, String> files) {
        System.out.println("Requested: " + uri);
        try {
            if ("/src".equals(uri)) {
                return this.respond("text/plain", new FileInputStream(this.fSrc));
            }
            if ("/src/xml".equals(uri)) {
                return this.respond("text/xml", TreeIoUtils.toXML(this.tSrc));
            }
            if ("/src/cxml".equals(uri)) {
                return this.respond("text/xml", TreeIoUtils.toCompactXML(this.tSrc));
            }
            if ("/src/dot".equals(uri)) {
                return this.respond("text/plain", TreeIoUtils.toDot(this.tSrc));
            }
            if ("/dst".equals(uri)) {
                return this.respond("text/plain", new FileInputStream(this.fDst));
            }
            if ("/dst/xml".equals(uri)) {
                return this.respond("text/xml", TreeIoUtils.toXML(this.tDst));
            }
            if ("/dst/cxml".equals(uri)) {
                return this.respond("text/xml", TreeIoUtils.toCompactXML(this.tDst));
            }
            if ("/dst/dot".equals(uri)) {
                return this.respond("text/plain", TreeIoUtils.toDot(this.tDst));
            }
            if ("/diff".equals(uri) || "/".equals(uri)) {
                return this.respond(BootstrapGenerator.produceHTML(this.fSrc, this.fDst, this.tSrc, this.tDst, this.matcher));
            }
            if ("/script".equals(uri)) {
                return this.respond("text/plain", SerializeEditScript.toText(new GenerateActions(this.tSrc, this.tDst, this.matcher.getMappingSet()).getActions()));
            }
            if ("/quit".equals(uri)) {
                System.exit(0);
            } else if (uri.startsWith("/assets")) {
                String res = uri.substring(1);
                InputStream data = ClassLoader.getSystemClassLoader().getResourceAsStream(res);
                if (uri.endsWith(".css")) {
                    return new NanoHTTPD.Response(NanoHTTPD.Response.Status.OK, "text/css", data);
                }
                if (uri.endsWith(".js")) {
                    return new NanoHTTPD.Response(NanoHTTPD.Response.Status.OK, "text/javascript", data);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private NanoHTTPD.Response respond(String s) {
        return new NanoHTTPD.Response(s);
    }

    private NanoHTTPD.Response respond(String mimeType, String s) {
        return new NanoHTTPD.Response(NanoHTTPD.Response.Status.OK, mimeType, s);
    }

    private NanoHTTPD.Response respond(String mimeType, InputStream s) {
        return new NanoHTTPD.Response(NanoHTTPD.Response.Status.OK, mimeType, s);
    }
}

