/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.client.ui.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;

public abstract class NanoHTTPD {
    public static final String QUERY_STRING_PARAMETER = "NanoHttpd.QUERY_STRING";
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
    private final String hostname;
    private final int myPort;
    private ServerSocket myServerSocket;
    private Thread myThread;
    private TempFileManagerFactory tempFileManagerFactory;
    private AsyncRunner asyncRunner;

    public NanoHTTPD(int port) {
        this(null, port);
    }

    public NanoHTTPD(String hostname, int port) {
        this.hostname = hostname;
        this.myPort = port;
        this.tempFileManagerFactory = new DefaultTempFileManagerFactory();
        this.asyncRunner = new DefaultAsyncRunner();
    }

    public void start() throws IOException {
        this.myServerSocket = new ServerSocket();
        this.myServerSocket.bind(this.hostname != null ? new InetSocketAddress(this.hostname, this.myPort) : new InetSocketAddress(this.myPort));
        this.myThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            final Socket finalAccept = NanoHTTPD.this.myServerSocket.accept();
                            InputStream inputStream = finalAccept.getInputStream();
                            OutputStream outputStream = finalAccept.getOutputStream();
                            TempFileManager tempFileManager = NanoHTTPD.this.tempFileManagerFactory.create();
                            final HTTPSession session = new HTTPSession(tempFileManager, inputStream, outputStream);
                            NanoHTTPD.this.asyncRunner.exec(new Runnable(){

                                @Override
                                public void run() {
                                    session.run();
                                    if (finalAccept != null) {
                                        try {
                                            finalAccept.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                        }
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    break;
                }
            }
        });
        this.myThread.setDaemon(true);
        this.myThread.start();
    }

    public void stop() {
        try {
            this.myServerSocket.close();
            this.myThread.join();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setTempFileManagerFactory(TempFileManagerFactory tempFileManagerFactory) {
        this.tempFileManagerFactory = tempFileManagerFactory;
    }

    public void setAsyncRunner(AsyncRunner asyncRunner) {
        this.asyncRunner = asyncRunner;
    }

    public abstract Response serve(String var1, Method var2, Map<String, String> var3, Map<String, String> var4, Map<String, String> var5);

    protected String decodePercent(String str) throws InterruptedException {
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                switch (c) {
                    case '+': {
                        sb.append(' ');
                        break;
                    }
                    case '%': {
                        sb.append((char)Integer.parseInt(str.substring(i + 1, i + 3), 16));
                        i += 2;
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new InterruptedException();
        }
    }

    protected Map<String, List<String>> decodeParameters(Map<String, String> parms) {
        return this.decodeParameters(parms.get(QUERY_STRING_PARAMETER));
    }

    protected Map<String, List<String>> decodeParameters(String queryString) {
        HashMap<String, List<String>> parms = new HashMap<String, List<String>>();
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int sep = e.indexOf(61);
                try {
                    String propertyValue;
                    String propertyName;
                    String string = propertyName = sep >= 0 ? this.decodePercent(e.substring(0, sep)).trim() : this.decodePercent(e).trim();
                    if (!parms.containsKey(propertyName)) {
                        parms.put(propertyName, new ArrayList());
                    }
                    String string2 = propertyValue = sep >= 0 ? this.decodePercent(e.substring(sep + 1)) : null;
                    if (propertyValue == null) continue;
                    ((List)parms.get(propertyName)).add(propertyValue);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return parms;
    }

    public static interface AsyncRunner {
        public void exec(Runnable var1);
    }

    private class DefaultAsyncRunner
    implements AsyncRunner {
        private DefaultAsyncRunner() {
        }

        @Override
        public void exec(Runnable code) {
            Thread t = new Thread(code);
            t.setDaemon(true);
            t.start();
        }
    }

    public static class DefaultTempFile
    implements TempFile {
        private File file;
        private OutputStream fstream;

        public DefaultTempFile(String tempdir) throws IOException {
            this.file = File.createTempFile("NanoHTTPD-", "", new File(tempdir));
            this.fstream = new FileOutputStream(this.file);
        }

        @Override
        public OutputStream open() throws Exception {
            return this.fstream;
        }

        @Override
        public void delete() throws Exception {
            this.file.delete();
        }

        @Override
        public String getName() {
            return this.file.getAbsolutePath();
        }
    }

    public static class DefaultTempFileManager
    implements TempFileManager {
        private final String tmpdir = System.getProperty("java.io.tmpdir");
        private final List<TempFile> tempFiles = new ArrayList<TempFile>();

        @Override
        public TempFile createTempFile() throws Exception {
            DefaultTempFile tempFile = new DefaultTempFile(this.tmpdir);
            this.tempFiles.add(tempFile);
            return tempFile;
        }

        @Override
        public void clear() {
            for (TempFile file : this.tempFiles) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.tempFiles.clear();
        }
    }

    private class DefaultTempFileManagerFactory
    implements TempFileManagerFactory {
        private DefaultTempFileManagerFactory() {
        }

        @Override
        public TempFileManager create() {
            return new DefaultTempFileManager();
        }
    }

    protected class HTTPSession
    implements Runnable {
        public static final int BUFSIZE = 8192;
        private final TempFileManager tempFileManager;
        private InputStream inputStream;
        private OutputStream outputStream;

        public HTTPSession(TempFileManager tempFileManager, InputStream inputStream, OutputStream outputStream) {
            this.tempFileManager = tempFileManager;
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            try {
                if (this.inputStream == null) {
                    return;
                }
                try {
                    Response r;
                    byte[] buf = new byte[8192];
                    int splitbyte = 0;
                    int rlen = 0;
                    int read = this.inputStream.read(buf, 0, 8192);
                    while (read > 0) {
                        splitbyte = this.findHeaderEnd(buf, rlen += read);
                        if (splitbyte > 0) break;
                        read = this.inputStream.read(buf, rlen, 8192 - rlen);
                    }
                    BufferedReader hin = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf, 0, rlen)));
                    HashMap<String, String> pre = new HashMap<String, String>();
                    HashMap<String, String> parms = new HashMap<String, String>();
                    HashMap<String, String> header = new HashMap<String, String>();
                    HashMap<String, String> files = new HashMap<String, String>();
                    this.decodeHeader(hin, pre, parms, header);
                    Method method = Method.lookup((String)pre.get("method"));
                    if (method == null) {
                        Response.error(this.outputStream, Response.Status.BAD_REQUEST, "BAD REQUEST: Syntax error.");
                        throw new InterruptedException();
                    }
                    String uri = (String)pre.get("uri");
                    long size = this.extractContentLength(header);
                    RandomAccessFile f = this.getTmpBucket();
                    if (splitbyte < rlen) {
                        f.write(buf, splitbyte, rlen - splitbyte);
                    }
                    if (splitbyte < rlen) {
                        size -= (long)(rlen - splitbyte + 1);
                    } else if (splitbyte == 0 || size == Long.MAX_VALUE) {
                        size = 0L;
                    }
                    buf = new byte[512];
                    while (rlen >= 0 && size > 0L) {
                        rlen = this.inputStream.read(buf, 0, 512);
                        size -= (long)rlen;
                        if (rlen <= 0) continue;
                        f.write(buf, 0, rlen);
                    }
                    MappedByteBuffer fbuf = f.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, f.length());
                    f.seek(0L);
                    FileInputStream bin = new FileInputStream(f.getFD());
                    BufferedReader in = new BufferedReader(new InputStreamReader(bin));
                    if (Method.POST.equals((Object)method)) {
                        String contentType = "";
                        String contentTypeHeader = (String)header.get("content-type");
                        StringTokenizer st = null;
                        if (contentTypeHeader != null && (st = new StringTokenizer(contentTypeHeader, ",; ")).hasMoreTokens()) {
                            contentType = st.nextToken();
                        }
                        if ("multipart/form-data".equalsIgnoreCase(contentType)) {
                            if (!st.hasMoreTokens()) {
                                Response.error(this.outputStream, Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but boundary missing. Usage: GET /example/file.html");
                                throw new InterruptedException();
                            }
                            String boundaryStartString = "boundary=";
                            int boundaryContentStart = contentTypeHeader.indexOf(boundaryStartString) + boundaryStartString.length();
                            String boundary = contentTypeHeader.substring(boundaryContentStart, contentTypeHeader.length());
                            if (boundary.startsWith("\"") && boundary.startsWith("\"")) {
                                boundary = boundary.substring(1, boundary.length() - 1);
                            }
                            this.decodeMultipartData(boundary, fbuf, in, parms, files);
                        } else {
                            String postLine = "";
                            char[] pbuf = new char[512];
                            int read2 = in.read(pbuf);
                            while (read2 >= 0 && !postLine.endsWith("\r\n")) {
                                postLine = String.valueOf(postLine) + String.valueOf(pbuf, 0, read2);
                                read2 = in.read(pbuf);
                            }
                            postLine = postLine.trim();
                            this.decodeParms(postLine, parms);
                        }
                    }
                    if (Method.PUT.equals((Object)method)) {
                        files.put("content", this.saveTmpFile(fbuf, 0, fbuf.limit()));
                    }
                    if ((r = NanoHTTPD.this.serve(uri, method, header, parms, files)) == null) {
                        Response.error(this.outputStream, Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                        throw new InterruptedException();
                    }
                    r.send(this.outputStream);
                    in.close();
                    this.inputStream.close();
                }
                catch (IOException ioe) {
                    try {
                        Response.error(this.outputStream, Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                        throw new InterruptedException();
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                this.tempFileManager.clear();
            }
        }

        private long extractContentLength(Map<String, String> header) {
            long size = Long.MAX_VALUE;
            String contentLength = header.get("content-length");
            if (contentLength != null) {
                try {
                    size = Integer.parseInt(contentLength);
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            return size;
        }

        private void decodeHeader(BufferedReader in, Map<String, String> pre, Map<String, String> parms, Map<String, String> header) throws InterruptedException {
            try {
                String inLine = in.readLine();
                if (inLine == null) {
                    return;
                }
                StringTokenizer st = new StringTokenizer(inLine);
                if (!st.hasMoreTokens()) {
                    Response.error(this.outputStream, Response.Status.BAD_REQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                    throw new InterruptedException();
                }
                pre.put("method", st.nextToken());
                if (!st.hasMoreTokens()) {
                    Response.error(this.outputStream, Response.Status.BAD_REQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                    throw new InterruptedException();
                }
                String uri = st.nextToken();
                int qmi = uri.indexOf(63);
                if (qmi >= 0) {
                    this.decodeParms(uri.substring(qmi + 1), parms);
                    uri = NanoHTTPD.this.decodePercent(uri.substring(0, qmi));
                } else {
                    uri = NanoHTTPD.this.decodePercent(uri);
                }
                if (st.hasMoreTokens()) {
                    String line = in.readLine();
                    while (line != null && line.trim().length() > 0) {
                        int p = line.indexOf(58);
                        if (p >= 0) {
                            header.put(line.substring(0, p).trim().toLowerCase(), line.substring(p + 1).trim());
                        }
                        line = in.readLine();
                    }
                }
                pre.put("uri", uri);
            }
            catch (IOException ioe) {
                Response.error(this.outputStream, Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                throw new InterruptedException();
            }
        }

        private void decodeMultipartData(String boundary, ByteBuffer fbuf, BufferedReader in, Map<String, String> parms, Map<String, String> files) throws InterruptedException {
            try {
                int[] bpositions = this.getBoundaryPositions(fbuf, boundary.getBytes());
                int boundarycount = 1;
                String mpline = in.readLine();
                while (mpline != null) {
                    if (!mpline.contains(boundary)) {
                        Response.error(this.outputStream, Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but next chunk does not start with boundary. Usage: GET /example/file.html");
                        throw new InterruptedException();
                    }
                    ++boundarycount;
                    HashMap<String, String> item = new HashMap<String, String>();
                    mpline = in.readLine();
                    while (mpline != null && mpline.trim().length() > 0) {
                        int p = mpline.indexOf(58);
                        if (p != -1) {
                            item.put(mpline.substring(0, p).trim().toLowerCase(), mpline.substring(p + 1).trim());
                        }
                        mpline = in.readLine();
                    }
                    if (mpline == null) continue;
                    String contentDisposition = (String)item.get("content-disposition");
                    if (contentDisposition == null) {
                        Response.error(this.outputStream, Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data but no content-disposition info found. Usage: GET /example/file.html");
                        throw new InterruptedException();
                    }
                    StringTokenizer st = new StringTokenizer(contentDisposition, "; ");
                    HashMap<String, String> disposition = new HashMap<String, String>();
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        int p = token.indexOf(61);
                        if (p == -1) continue;
                        disposition.put(token.substring(0, p).trim().toLowerCase(), token.substring(p + 1).trim());
                    }
                    String pname = (String)disposition.get("name");
                    pname = pname.substring(1, pname.length() - 1);
                    String value = "";
                    if (item.get("content-type") == null) {
                        while (mpline != null && !mpline.contains(boundary)) {
                            mpline = in.readLine();
                            if (mpline == null) continue;
                            int d = mpline.indexOf(boundary);
                            value = d == -1 ? String.valueOf(value) + mpline : String.valueOf(value) + mpline.substring(0, d - 2);
                        }
                    } else {
                        if (boundarycount > bpositions.length) {
                            Response.error(this.outputStream, Response.Status.INTERNAL_ERROR, "Error processing request");
                            throw new InterruptedException();
                        }
                        int offset = this.stripMultipartHeaders(fbuf, bpositions[boundarycount - 2]);
                        String path = this.saveTmpFile(fbuf, offset, bpositions[boundarycount - 1] - offset - 4);
                        files.put(pname, path);
                        value = (String)disposition.get("filename");
                        value = value.substring(1, value.length() - 1);
                        while ((mpline = in.readLine()) != null && !mpline.contains(boundary)) {
                        }
                    }
                    parms.put(pname, value);
                }
            }
            catch (IOException ioe) {
                Response.error(this.outputStream, Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                throw new InterruptedException();
            }
        }

        private int findHeaderEnd(byte[] buf, int rlen) {
            int splitbyte = 0;
            while (splitbyte + 3 < rlen) {
                if (buf[splitbyte] == 13 && buf[splitbyte + 1] == 10 && buf[splitbyte + 2] == 13 && buf[splitbyte + 3] == 10) {
                    return splitbyte + 4;
                }
                ++splitbyte;
            }
            return 0;
        }

        public int[] getBoundaryPositions(ByteBuffer b, byte[] boundary) {
            int matchcount = 0;
            int matchbyte = -1;
            ArrayList<Integer> matchbytes = new ArrayList<Integer>();
            int i = 0;
            while (i < b.limit()) {
                if (b.get(i) == boundary[matchcount]) {
                    if (matchcount == 0) {
                        matchbyte = i;
                    }
                    if (++matchcount == boundary.length) {
                        matchbytes.add(matchbyte);
                        matchcount = 0;
                        matchbyte = -1;
                    }
                } else {
                    i -= matchcount;
                    matchcount = 0;
                    matchbyte = -1;
                }
                ++i;
            }
            int[] ret = new int[matchbytes.size()];
            int i2 = 0;
            while (i2 < ret.length) {
                ret[i2] = (Integer)matchbytes.get(i2);
                ++i2;
            }
            return ret;
        }

        private String saveTmpFile(ByteBuffer b, int offset, int len) {
            String path = "";
            if (len > 0) {
                try {
                    TempFile tempFile = this.tempFileManager.createTempFile();
                    ByteBuffer src = b.duplicate();
                    FileOutputStream fos = new FileOutputStream(tempFile.getName());
                    FileChannel dest = fos.getChannel();
                    src.position(offset).limit(offset + len);
                    dest.write(src.slice());
                    fos.close();
                    path = tempFile.getName();
                }
                catch (Exception e) {
                    System.err.println("Error: " + e.getMessage());
                }
            }
            return path;
        }

        private RandomAccessFile getTmpBucket() throws IOException {
            try {
                TempFile tempFile = this.tempFileManager.createTempFile();
                return new RandomAccessFile(tempFile.getName(), "rw");
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
                return null;
            }
        }

        private int stripMultipartHeaders(ByteBuffer b, int offset) {
            int i = offset;
            while (i < b.limit()) {
                if (b.get(i) == 13 && b.get(++i) == 10 && b.get(++i) == 13 && b.get(++i) == 10) break;
                ++i;
            }
            return i + 1;
        }

        private void decodeParms(String parms, Map<String, String> p) throws InterruptedException {
            if (parms == null) {
                p.put(NanoHTTPD.QUERY_STRING_PARAMETER, "");
                return;
            }
            p.put(NanoHTTPD.QUERY_STRING_PARAMETER, parms);
            StringTokenizer st = new StringTokenizer(parms, "&");
            try {
                while (st.hasMoreTokens()) {
                    String e = st.nextToken();
                    int sep = e.indexOf(61);
                    if (sep >= 0) {
                        p.put(NanoHTTPD.this.decodePercent(e.substring(0, sep)).trim(), NanoHTTPD.this.decodePercent(e.substring(sep + 1)));
                        continue;
                    }
                    p.put(NanoHTTPD.this.decodePercent(e).trim(), "");
                }
            }
            catch (InterruptedException e) {
                Response.error(this.outputStream, Response.Status.BAD_REQUEST, "BAD REQUEST: Bad percent-encoding.");
            }
        }
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE;


        static Method lookup(String method) {
            Method[] methodArray = Method.values();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.toString().equalsIgnoreCase(method)) {
                    return m;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class Response {
        public Status status;
        public String mimeType;
        public InputStream data;
        public Map<String, String> header = new HashMap<String, String>();

        public Response(String msg) {
            this(Status.OK, NanoHTTPD.MIME_HTML, msg);
        }

        public Response(Status status, String mimeType, InputStream data) {
            this.status = status;
            this.mimeType = mimeType;
            this.data = data;
        }

        public Response(Status status, String mimeType, String txt) {
            this.status = status;
            this.mimeType = mimeType;
            try {
                this.data = new ByteArrayInputStream(txt.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }

        public static void error(OutputStream outputStream, Status error, String message) {
            new Response(error, NanoHTTPD.MIME_PLAINTEXT, message).send(outputStream);
        }

        public void addHeader(String name, String value) {
            this.header.put(name, value);
        }

        private void send(OutputStream outputStream) {
            String mime = this.mimeType;
            SimpleDateFormat gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                if (this.status == null) {
                    throw new Error("sendResponse(): Status can't be null.");
                }
                PrintWriter pw = new PrintWriter(outputStream);
                pw.print("HTTP/1.0 " + this.status.getDescription() + " \r\n");
                if (mime != null) {
                    pw.print("Content-Type: " + mime + "\r\n");
                }
                if (this.header == null || this.header.get("Date") == null) {
                    pw.print("Date: " + gmtFrmt.format(new Date()) + "\r\n");
                }
                if (this.header != null) {
                    for (String key : this.header.keySet()) {
                        String value = this.header.get(key);
                        pw.print(String.valueOf(key) + ": " + value + "\r\n");
                    }
                }
                pw.print("\r\n");
                pw.flush();
                if (this.data != null) {
                    int pending = this.data.available();
                    int BUFFER_SIZE = 16384;
                    byte[] buff = new byte[BUFFER_SIZE];
                    while (pending > 0) {
                        int read = this.data.read(buff, 0, pending > BUFFER_SIZE ? BUFFER_SIZE : pending);
                        if (read <= 0) break;
                        outputStream.write(buff, 0, read);
                        pending -= read;
                    }
                }
                outputStream.flush();
                outputStream.close();
                if (this.data != null) {
                    this.data.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public static enum Status {
            OK(200, "OK"),
            CREATED(201, "Created"),
            NO_CONTENT(204, "No Content"),
            PARTIAL_CONTENT(206, "Partial Content"),
            REDIRECT(301, "Moved Permanently"),
            NOT_MODIFIED(304, "Not Modified"),
            BAD_REQUEST(400, "Bad Request"),
            UNAUTHORIZED(401, "Unauthorized"),
            FORBIDDEN(403, "Forbidden"),
            NOT_FOUND(404, "Not Found"),
            RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
            INTERNAL_ERROR(500, "Internal Server Error");

            private int requestStatus;
            private String descr;

            private Status(int requestStatus, String descr) {
                this.requestStatus = requestStatus;
                this.descr = descr;
            }

            public int getRequestStatus() {
                return this.requestStatus;
            }

            public String getDescription() {
                return this.requestStatus + " " + this.descr;
            }
        }
    }

    public static interface TempFile {
        public OutputStream open() throws Exception;

        public void delete() throws Exception;

        public String getName();
    }

    public static interface TempFileManager {
        public TempFile createTempFile() throws Exception;

        public void clear();
    }

    public static interface TempFileManagerFactory {
        public TempFileManager create();
    }
}

