/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.gen.antlr;

import fr.labri.gumtree.io.TreeGenerator;
import fr.labri.gumtree.tree.Tree;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;

public abstract class AbstractAntlrTreeGenerator
extends TreeGenerator {
    protected Map<CommonTree, Tree> trees;
    protected static Map<Integer, String> names;
    protected static Map<Integer, Integer> chars;
    protected CommonTokenStream tokens;

    public AbstractAntlrTreeGenerator() {
        this.loadNames();
    }

    protected abstract CommonTree getStartSymbol(String var1) throws RecognitionException, IOException;

    @Override
    public Tree doGenerate(String file) throws IOException {
        try {
            this.loadChars(file);
            CommonTree ct = this.getStartSymbol(file);
            this.trees = new HashMap<CommonTree, Tree>();
            return this.toTree(ct);
        }
        catch (RecognitionException e) {
            System.out.println("at " + e.line + ":" + e.charPositionInLine);
            e.printStackTrace();
            return null;
        }
    }

    protected abstract Parser getEmptyParser();

    protected Tree toTree(CommonTree ct) {
        Tree t = null;
        t = ct.getText().equals(names.get(ct.getType())) ? new Tree(ct.getType()) : new Tree(ct.getType(), ct.getText());
        t.setTypeLabel(names.get(ct.getType()));
        int[] pos = this.getPosAndLength(ct);
        t.setPos(pos[0]);
        t.setLength(pos[1]);
        if (ct.getParent() != null) {
            t.setParentAndUpdateChildren(this.trees.get(ct.getParent()));
        }
        if (ct.getChildCount() > 0) {
            this.trees.put(ct, t);
            for (CommonTree cct : ct.getChildren()) {
                this.toTree(cct);
            }
        }
        return t;
    }

    private void loadNames() {
        names = new HashMap<Integer, String>();
        Parser p = this.getEmptyParser();
        Field[] fieldArray = p.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.getType().equals(Integer.TYPE)) {
                try {
                    names.put(f.getInt(p), f.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void loadChars(String file) throws IOException {
        chars = new HashMap<Integer, Integer>();
        BufferedReader r = new BufferedReader(new FileReader(file));
        int line = 0;
        int chrs = 0;
        while (r.ready()) {
            String cur = r.readLine();
            chars.put(line, chrs += cur.length() + 1);
            ++line;
        }
        r.close();
    }

    private int[] getPosAndLength(CommonTree ct) {
        int start = ct.getTokenStartIndex() == -1 ? 0 : new CommonToken(this.tokens.get(ct.getTokenStartIndex())){

            int getPos() {
                return this.start;
            }
        }.getPos();
        int stop = ct.getTokenStopIndex() == -1 ? 0 : new CommonToken(this.tokens.get(ct.getTokenStopIndex())){

            int getPos() {
                return this.stop;
            }
        }.getPos();
        return new int[]{start, stop - start + 1};
    }
}

