/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.gen.jdt;

import fr.labri.gumtree.gen.jdt.AbstractJdtVisitor;
import fr.labri.gumtree.tree.Tree;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;

public class JdtVisitor
extends AbstractJdtVisitor {
    private Stack<Tree> trees;

    public JdtVisitor() {
        this.root = null;
        this.trees = new Stack();
    }

    public Tree getRoot() {
        return this.root;
    }

    @Override
    public void preVisit(ASTNode n) {
        int type = n.getNodeType();
        String label = "";
        if (n instanceof Name) {
            label = ((Name)n).getFullyQualifiedName();
        } else if (n instanceof Type) {
            label = n.toString();
        } else if (n instanceof Modifier) {
            label = n.toString();
        } else if (n instanceof StringLiteral) {
            label = ((StringLiteral)n).getEscapedValue();
        } else if (n instanceof NumberLiteral) {
            label = ((NumberLiteral)n).getToken();
        } else if (n instanceof CharacterLiteral) {
            label = ((CharacterLiteral)n).getEscapedValue();
        } else if (n instanceof BooleanLiteral) {
            label = ((BooleanLiteral)n).toString();
        } else if (n instanceof InfixExpression) {
            label = ((InfixExpression)n).getOperator().toString();
        } else if (n instanceof PrefixExpression) {
            label = ((PrefixExpression)n).getOperator().toString();
        } else if (n instanceof PostfixExpression) {
            label = ((PostfixExpression)n).getOperator().toString();
        }
        Tree t = new Tree(type, label, n.getClass().getSimpleName());
        t.setPos(n.getStartPosition());
        t.setLength(n.getLength());
        if (this.root == null) {
            this.root = t;
        } else {
            Tree parent = this.trees.peek();
            t.setParentAndUpdateChildren(parent);
        }
        this.trees.push(t);
    }

    @Override
    public boolean visit(QualifiedName name) {
        return false;
    }

    @Override
    public void postVisit(ASTNode n) {
        this.trees.pop();
    }
}

