/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.gen.jdt.cd;

import fr.labri.gumtree.gen.jdt.AbstractJdtVisitor;
import fr.labri.gumtree.gen.jdt.cd.EntityType;
import fr.labri.gumtree.tree.Tree;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;

public class CdJdtVisitor
extends AbstractJdtVisitor {
    private static final String COLON_SPACE = ": ";
    private boolean fEmptyJavaDoc;
    private Stack<Tree> fNodeStack = new Stack();
    private boolean fInMethodDeclaration;
    private Tree root;
    private ASTNode fLastVisitedNode;
    private Tree fLastAddedNode;
    private static final String COLON = ":";

    public CdJdtVisitor(Tree root) {
        this.fNodeStack.clear();
        this.fNodeStack.push(root);
    }

    public CdJdtVisitor() {
        this.fNodeStack.clear();
    }

    @Override
    public boolean visit(Block node) {
        return true;
    }

    @Override
    public void endVisit(Block node) {
    }

    @Override
    public boolean visit(FieldDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.push(node, node.toString());
        this.visitList(EntityType.MODIFIERS, node.modifiers());
        node.getType().accept(this);
        this.visitList(EntityType.FRAGMENTS, node.fragments());
        return false;
    }

    @Override
    public void endVisit(FieldDeclaration node) {
        this.pop();
    }

    @Override
    public boolean visit(Javadoc node) {
        String string = "";
        if (this.checkEmptyJavaDoc(string)) {
            this.pushValuedNode(node, string);
        } else {
            this.fEmptyJavaDoc = true;
        }
        return false;
    }

    @Override
    public void endVisit(Javadoc node) {
        if (!this.fEmptyJavaDoc) {
            this.pop();
        }
        this.fEmptyJavaDoc = false;
    }

    private boolean checkEmptyJavaDoc(String doc) {
        String[] splittedDoc = doc.split("/\\*+\\s*");
        String result = "";
        String[] stringArray = splittedDoc;
        int n = splittedDoc.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            result = String.valueOf(result) + s;
            ++n2;
        }
        try {
            result = result.split("\\s*\\*/")[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            result = result.replace('/', ' ');
        }
        result = result.replace('*', ' ').trim();
        return !result.equals("");
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.fInMethodDeclaration = true;
        this.push(node, node.getName().toString());
        this.visitList(EntityType.MODIFIERS, node.modifiers());
        if (node.getReturnType2() != null) {
            node.getReturnType2().accept(this);
        }
        this.visitList(EntityType.TYPE_ARGUMENTS, node.typeParameters());
        this.visitList(EntityType.PARAMETERS, node.parameters());
        this.visitList(EntityType.THROW, node.thrownExceptions());
        if (node.getBody() != null) {
            node.getBody().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MethodDeclaration node) {
        this.fInMethodDeclaration = false;
        this.pop();
    }

    @Override
    public boolean visit(Modifier node) {
        this.pushValuedNode(node, node.getKeyword().toString());
        return false;
    }

    @Override
    public void endVisit(Modifier node) {
        this.pop();
    }

    @Override
    public boolean visit(ParameterizedType node) {
        this.pushEmptyNode(node);
        node.getType().accept(this);
        this.visitList(EntityType.TYPE_ARGUMENTS, node.typeArguments());
        return false;
    }

    @Override
    public void endVisit(ParameterizedType node) {
        this.pop();
    }

    @Override
    public boolean visit(PrimitiveType node) {
        String vName = "";
        if (this.fInMethodDeclaration) {
            vName = String.valueOf(vName) + this.getCurrentParent().getLabel() + COLON_SPACE;
        }
        this.pushValuedNode(node, String.valueOf(vName) + node.getPrimitiveTypeCode().toString());
        return false;
    }

    @Override
    public void endVisit(PrimitiveType node) {
        this.pop();
    }

    @Override
    public boolean visit(QualifiedType node) {
        this.pushEmptyNode(node);
        return true;
    }

    @Override
    public void endVisit(QualifiedType node) {
        this.pop();
    }

    @Override
    public boolean visit(SimpleType node) {
        String vName = "";
        if (this.fInMethodDeclaration) {
            vName = String.valueOf(vName) + this.getCurrentParent().getLabel() + COLON_SPACE;
        }
        this.pushValuedNode(node, String.valueOf(vName) + node.getName().getFullyQualifiedName());
        return false;
    }

    @Override
    public void endVisit(SimpleType node) {
        this.pop();
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        boolean isNotParam = this.getCurrentParent().getLabel() != EntityType.PARAMETERS.toString();
        this.pushValuedNode(node, node.getName().getIdentifier());
        node.getType().accept(this);
        return false;
    }

    @Override
    public void endVisit(SingleVariableDeclaration node) {
        this.pop();
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.push(node, node.getName().toString());
        this.visitList(EntityType.MODIFIERS, node.modifiers());
        this.visitList(EntityType.TYPE_ARGUMENTS, node.typeParameters());
        if (node.getSuperclassType() != null) {
            node.getSuperclassType().accept(this);
        }
        this.visitList(EntityType.SUPER_INTERFACE_TYPES, node.superInterfaceTypes());
        BodyDeclaration[] bodyDeclarationArray = node.getFields();
        int n = bodyDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fd = bodyDeclarationArray[n2];
            fd.accept(this);
            ++n2;
        }
        bodyDeclarationArray = node.getMethods();
        n = bodyDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            BodyDeclaration md = bodyDeclarationArray[n2];
            md.accept(this);
            ++n2;
        }
        return false;
    }

    @Override
    public void endVisit(TypeDeclaration node) {
        this.pop();
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        return true;
    }

    @Override
    public void endVisit(TypeDeclarationStatement node) {
    }

    @Override
    public boolean visit(TypeLiteral node) {
        this.pushEmptyNode(node);
        return true;
    }

    @Override
    public void endVisit(TypeLiteral node) {
        this.pop();
    }

    @Override
    public boolean visit(TypeParameter node) {
        this.pushValuedNode(node, node.getName().getFullyQualifiedName());
        this.visitList(node.typeBounds());
        return false;
    }

    @Override
    public void endVisit(TypeParameter node) {
        this.pop();
    }

    @Override
    public boolean visit(VariableDeclarationExpression node) {
        this.pushEmptyNode(node);
        this.visitList(EntityType.MODIFIERS, node.modifiers());
        node.getType().accept(this);
        this.visitList(EntityType.FRAGMENTS, node.fragments());
        return false;
    }

    @Override
    public void endVisit(VariableDeclarationExpression node) {
        this.pop();
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        this.pushValuedNode(node, node.getName().getFullyQualifiedName());
        return false;
    }

    @Override
    public void endVisit(VariableDeclarationFragment node) {
        this.pop();
    }

    @Override
    public boolean visit(WildcardType node) {
        String bound = node.isUpperBound() ? "extends" : "super";
        this.pushValuedNode(node, bound);
        return true;
    }

    @Override
    public void endVisit(WildcardType node) {
        this.pop();
    }

    private void visitList(List<ASTNode> list) {
        for (ASTNode node : list) {
            node.accept(this);
        }
    }

    private void visitList(EntityType parentLabel, List<ASTNode> list) {
        int[] position = this.extractPosition(list);
        this.push(-parentLabel.ordinal(), parentLabel.name(), "", position[0], position[1]);
        if (!list.isEmpty()) {
            this.visitList(list);
        }
        this.pop();
    }

    private void pushEmptyNode(ASTNode node) {
        this.push(node, "");
    }

    private void pushValuedNode(ASTNode node, String value) {
        this.push(node, value);
    }

    public Tree getRoot() {
        return this.root;
    }

    private void push(ASTNode node, String label) {
        int type = node.getNodeType();
        Tree t = new Tree(type, label, node.getClass().getSimpleName());
        t.setPos(node.getStartPosition());
        t.setLength(node.getLength());
        if (this.root == null) {
            this.root = t;
        } else if (this.fNodeStack.isEmpty()) {
            System.err.println("Stack is empty");
        } else {
            Tree parent = this.fNodeStack.peek();
            t.setParentAndUpdateChildren(parent);
        }
        this.fNodeStack.push(t);
    }

    private void push(int nType, String type, String label, int startPosition, int length) {
        Tree t = new Tree(nType, label, type);
        t.setPos(startPosition);
        t.setLength(length);
        if (this.root == null) {
            this.root = t;
        } else if (this.fNodeStack.isEmpty()) {
            System.err.println("Stack is empty");
        } else {
            Tree parent = this.fNodeStack.peek();
            t.setParentAndUpdateChildren(parent);
        }
        this.fNodeStack.push(t);
    }

    private void pop() {
        this.fNodeStack.pop();
    }

    private void pop(ASTNode node) {
        this.fLastVisitedNode = node;
        this.fLastAddedNode = this.fNodeStack.pop();
    }

    private Tree getCurrentParent() {
        return this.fNodeStack.peek();
    }

    private int[] extractPosition(List<ASTNode> list) {
        int offset = -1;
        int length = -1;
        if (!list.isEmpty()) {
            ASTNode first = list.get(0);
            ASTNode last = list.get(list.size() - 1);
            offset = first.getStartPosition();
            length = last.getStartPosition() + last.getLength() - offset;
        }
        return new int[]{offset, length};
    }

    @Override
    public boolean visit(AssertStatement node) {
        String value = node.getExpression().toString();
        if (node.getMessage() != null) {
            value = String.valueOf(value) + COLON + node.getMessage().toString();
        }
        this.pushValuedNode(node, value);
        return false;
    }

    @Override
    public void endVisit(AssertStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(BreakStatement node) {
        this.pushValuedNode(node, node.getLabel() != null ? node.getLabel().toString() : "");
        return false;
    }

    @Override
    public void endVisit(BreakStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(CatchClause node) {
        this.pushValuedNode(node, ((SimpleType)node.getException().getType()).getName().getFullyQualifiedName());
        node.getBody().accept(this);
        return false;
    }

    @Override
    public void endVisit(CatchClause node) {
        this.pop(node);
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        this.pushValuedNode(node, node.toString());
        return false;
    }

    @Override
    public void endVisit(ConstructorInvocation node) {
        this.pop(node);
    }

    @Override
    public boolean visit(ContinueStatement node) {
        this.pushValuedNode(node, node.getLabel() != null ? node.getLabel().toString() : "");
        return false;
    }

    @Override
    public void endVisit(ContinueStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(DoStatement node) {
        this.pushValuedNode(node, node.getExpression().toString());
        return true;
    }

    @Override
    public void endVisit(DoStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(EmptyStatement node) {
        this.pushEmptyNode(node);
        return false;
    }

    @Override
    public void endVisit(EmptyStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(EnhancedForStatement node) {
        this.pushValuedNode(node, String.valueOf(node.getParameter().toString()) + COLON + node.getExpression().toString());
        return true;
    }

    @Override
    public void endVisit(EnhancedForStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(ExpressionStatement node) {
        this.pushValuedNode(node.getExpression(), node.toString());
        return false;
    }

    @Override
    public void endVisit(ExpressionStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(ForStatement node) {
        String value = "";
        if (node.getExpression() != null) {
            value = node.getExpression().toString();
        }
        this.pushValuedNode(node, value);
        return true;
    }

    @Override
    public void endVisit(ForStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(IfStatement node) {
        String expression = node.getExpression().toString();
        this.push(node, expression);
        if (node.getThenStatement() != null) {
            this.push(EntityType.THEN_STATEMENT.ordinal(), EntityType.THEN_STATEMENT.name(), expression, node.getThenStatement().getStartPosition(), node.getThenStatement().getLength());
            node.getThenStatement().accept(this);
            this.pop(node.getThenStatement());
        }
        if (node.getElseStatement() != null) {
            this.push(EntityType.ELSE_STATEMENT.ordinal(), EntityType.ELSE_STATEMENT.name(), expression, node.getElseStatement().getStartPosition(), node.getElseStatement().getLength());
            node.getElseStatement().accept(this);
            this.pop(node.getElseStatement());
        }
        return false;
    }

    @Override
    public void endVisit(IfStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(LabeledStatement node) {
        this.pushValuedNode(node, node.getLabel().getFullyQualifiedName());
        node.getBody().accept(this);
        return false;
    }

    @Override
    public void endVisit(LabeledStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(ReturnStatement node) {
        this.pushValuedNode(node, node.getExpression() != null ? node.getExpression().toString() : "");
        return false;
    }

    @Override
    public void endVisit(ReturnStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        this.pushValuedNode(node, node.toString());
        return false;
    }

    @Override
    public void endVisit(SuperConstructorInvocation node) {
        this.pop(node);
    }

    @Override
    public boolean visit(SwitchCase node) {
        this.pushValuedNode(node, node.getExpression() != null ? node.getExpression().toString() : "default");
        return false;
    }

    @Override
    public void endVisit(SwitchCase node) {
        this.pop(node);
    }

    @Override
    public boolean visit(SwitchStatement node) {
        this.pushValuedNode(node, node.getExpression().toString());
        this.visitList(node.statements());
        return false;
    }

    @Override
    public void endVisit(SwitchStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(SynchronizedStatement node) {
        this.pushValuedNode(node, node.getExpression().toString());
        return true;
    }

    @Override
    public void endVisit(SynchronizedStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(ThrowStatement node) {
        this.pushValuedNode(node, node.getExpression().toString());
        return false;
    }

    @Override
    public void endVisit(ThrowStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(TryStatement node) {
        this.pushEmptyNode(node);
        this.push(EntityType.BODY.ordinal(), EntityType.BODY.name(), "", node.getBody().getStartPosition(), node.getBody().getLength());
        node.getBody().accept(this);
        this.pop(node.getBody());
        this.visitList(EntityType.CATCH_CLAUSES, node.catchClauses());
        if (node.getFinally() != null) {
            this.push(EntityType.FINALLY.ordinal(), EntityType.FINALLY.name(), "", node.getFinally().getStartPosition(), node.getFinally().getLength());
            node.getFinally().accept(this);
            this.pop(node.getFinally());
        }
        return false;
    }

    @Override
    public void endVisit(TryStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        this.pushValuedNode(node, node.toString());
        return false;
    }

    @Override
    public void endVisit(VariableDeclarationStatement node) {
        this.pop(node);
    }

    @Override
    public boolean visit(WhileStatement node) {
        this.push(node, node.getExpression().toString());
        return true;
    }

    @Override
    public void endVisit(WhileStatement node) {
        this.pop(node);
    }
}

