/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.gen.xml;

import fr.labri.gumtree.gen.antlr.AbstractAntlrTreeGenerator;
import fr.labri.gumtree.gen.xml.XMLLexer;
import fr.labri.gumtree.gen.xml.XMLParser;
import fr.labri.gumtree.tree.Tree;
import java.io.IOException;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.tree.CommonTree;

public class XMLTreeGenerator
extends AbstractAntlrTreeGenerator {
    @Override
    public Tree doGenerate(String file) throws IOException {
        Tree t = super.doGenerate(file);
        for (Tree c : t.getTrees()) {
            if (!c.getTypeLabel().equals("PCDATA") || !c.getLabel().trim().equals("")) continue;
            c.setParentAndUpdateChildren(null);
        }
        return t;
    }

    @Override
    protected CommonTree getStartSymbol(String file) throws RecognitionException, IOException {
        ANTLRFileStream stream = new ANTLRFileStream(file);
        XMLLexer l = new XMLLexer(stream);
        this.tokens = new TokenRewriteStream(l);
        XMLParser p = new XMLParser(this.tokens);
        return (CommonTree)p.document().getTree();
    }

    @Override
    protected Parser getEmptyParser() {
        ANTLRStringStream stream = new ANTLRStringStream();
        XMLLexer l = new XMLLexer(stream);
        TokenRewriteStream tokens = new TokenRewriteStream(l);
        return new XMLParser(tokens);
    }

    @Override
    public final boolean handleFile(String file) {
        return file.toLowerCase().endsWith(".xml") || file.toLowerCase().endsWith(".wadl");
    }

    @Override
    public final String getName() {
        return "xml-antlr";
    }
}

