/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.matchers.heuristic.AbstractSubtreeMatcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.MultiMappingStore;
import fr.labri.gumtree.tree.Tree;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class GreedySubtreeMatcher
extends AbstractSubtreeMatcher {
    public GreedySubtreeMatcher(Tree src, Tree dst) {
        super(src, dst);
    }

    public GreedySubtreeMatcher(Tree src, Tree dst, MappingStore mappings) {
        super(src, dst, mappings);
    }

    @Override
    protected void filterRawMappings(MultiMappingStore rawMappings) {
        LinkedList<Mapping> ambiguousList = new LinkedList<Mapping>();
        HashSet<Tree> ignored = new HashSet<Tree>();
        for (Tree src : rawMappings.getSrcs()) {
            if (rawMappings.isSrcUnique(src)) {
                this.addFullMapping(src, rawMappings.getDst(src).iterator().next());
                continue;
            }
            if (ignored.contains(src)) continue;
            List<Tree> adsts = rawMappings.getDst(src);
            List<Tree> asrcs = rawMappings.getSrc(rawMappings.getDst(src).iterator().next());
            for (Tree asrc : asrcs) {
                for (Tree adst : adsts) {
                    ambiguousList.add(new Mapping(asrc, adst));
                }
            }
            ignored.addAll(asrcs);
        }
        HashSet<Tree> srcIgnored = new HashSet<Tree>();
        HashSet<Tree> dstIgnored = new HashSet<Tree>();
        Collections.sort(ambiguousList, new MappingComparator());
        while (ambiguousList.size() > 0) {
            Mapping ambiguous = (Mapping)ambiguousList.remove(0);
            if (srcIgnored.contains(ambiguous.getFirst()) || dstIgnored.contains(ambiguous.getSecond())) continue;
            this.addFullMapping((Tree)ambiguous.getFirst(), (Tree)ambiguous.getSecond());
            srcIgnored.add((Tree)ambiguous.getFirst());
            dstIgnored.add((Tree)ambiguous.getSecond());
        }
    }

    private class MappingComparator
    implements Comparator<Mapping> {
        private MappingComparator() {
        }

        @Override
        public int compare(Mapping m1, Mapping m2) {
            return Double.compare(GreedySubtreeMatcher.this.subtreeSim((Tree)m2.getFirst(), (Tree)m2.getSecond()), GreedySubtreeMatcher.this.subtreeSim((Tree)m1.getFirst(), (Tree)m1.getSecond()));
        }
    }
}

