/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XyBottomUpMatcher
extends Matcher {
    private static final double SIM_THRESHOLD = 0.001;
    private Map<Integer, Tree> srcs = new HashMap<Integer, Tree>();
    private Map<Integer, Tree> dsts = new HashMap<Integer, Tree>();

    public XyBottomUpMatcher(Tree src, Tree dst, MappingStore mappings) {
        super(src, dst, mappings);
        this.match();
    }

    @Override
    public void match() {
        List<Tree> poSrc = TreeUtils.postOrder(this.src);
        List<Tree> poDst = TreeUtils.postOrder(this.dst);
        for (Tree t : poSrc) {
            this.srcs.put(t.getId(), t);
        }
        for (Tree t : poDst) {
            this.dsts.put(t.getId(), t);
        }
        this.match(poSrc, poDst);
        this.clean();
    }

    private void match(List<Tree> poSrc, List<Tree> poDst) {
        for (Tree src : poSrc) {
            if (src.isRoot()) {
                this.addMapping(src, this.dst);
                this.lastChanceMatch(src, this.dst);
                continue;
            }
            if (src.isMatched() || src.isLeaf()) continue;
            Set<Tree> candidates = this.getDstCandidates(src);
            Tree best = null;
            double max = -1.0;
            for (Tree cand : candidates) {
                double sim = this.jaccardSimilarity(src, cand);
                if (!(sim > max) || !(sim >= 0.001)) continue;
                max = sim;
                best = cand;
            }
            if (best == null) continue;
            this.lastChanceMatch(src, best);
            this.addMapping(src, best);
        }
    }

    private Set<Tree> getDstCandidates(Tree src) {
        HashSet<Tree> seeds = new HashSet<Tree>();
        for (Tree c : src.getDescendants()) {
            Tree m = this.mappings.getDst(c);
            if (m == null) continue;
            seeds.add(m);
        }
        HashSet<Tree> candidates = new HashSet<Tree>();
        HashSet<Tree> visited = new HashSet<Tree>();
        block1: for (Tree seed : seeds) {
            while (seed.getParent() != null) {
                Tree parent = seed.getParent();
                if (visited.contains(parent)) continue block1;
                visited.add(parent);
                if (parent.getType() == src.getType() && !parent.isMatched()) {
                    candidates.add(parent);
                }
                seed = parent;
            }
        }
        return candidates;
    }

    private void lastChanceMatch(Tree src, Tree dst) {
        HashMap srcKinds = new HashMap();
        HashMap dstKinds = new HashMap();
        for (Tree c : src.getChildren()) {
            if (!srcKinds.containsKey(c.getType())) {
                srcKinds.put(c.getType(), new ArrayList());
            }
            ((List)srcKinds.get(c.getType())).add(c);
        }
        for (Tree c : dst.getChildren()) {
            if (!dstKinds.containsKey(c.getType())) {
                dstKinds.put(c.getType(), new ArrayList());
            }
            ((List)dstKinds.get(c.getType())).add(c);
        }
        Iterator<Tree> iterator = srcKinds.keySet().iterator();
        while (iterator.hasNext()) {
            int t = (Integer)((Object)iterator.next());
            if (((List)srcKinds.get(t)).size() != ((List)dstKinds.get(t)).size() || ((List)srcKinds.get(t)).size() != 1) continue;
            this.addMapping((Tree)((List)srcKinds.get(t)).get(0), (Tree)((List)dstKinds.get(t)).get(0));
        }
    }
}

