/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.optimal.rted;

import fr.labri.gumtree.matchers.optimal.rted.InfoTree;
import fr.labri.gumtree.matchers.optimal.rted.LabelDictionary;
import fr.labri.gumtree.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;

public class RtedAlgorithm {
    private static final byte LEFT = 0;
    private static final byte RIGHT = 1;
    private static final byte HEAVY = 2;
    private static final byte BOTH = 3;
    private static final byte REVLEFT = 4;
    private static final byte REVRIGHT = 5;
    private static final byte REVHEAVY = 6;
    private static final byte POST2_SIZE = 0;
    private static final byte POST2_KR_SUM = 1;
    private static final byte POST2_REV_KR_SUM = 2;
    private static final byte POST2_DESC_SUM = 3;
    private static final byte POST2_PRE = 4;
    private static final byte POST2_PARENT = 5;
    private static final byte POST2_LABEL = 6;
    private static final byte KR = 7;
    private static final byte POST2_LLD = 8;
    private static final byte POST2_MIN_KR = 9;
    private static final byte RKR = 10;
    private static final byte RPOST2_RLD = 11;
    private static final byte RPOST2_MIN_RKR = 12;
    private static final byte RPOST2_POST = 13;
    private static final byte POST2_STRATEGY = 14;
    private static final byte PRE2_POST = 15;
    private InfoTree it1;
    private InfoTree it2;
    private int size1;
    private int size2;
    private LabelDictionary ld;
    private int[][] str;
    private double[][] delta;
    private byte[][] deltaBit;
    private int[][] ij;
    private long[][][] costV;
    private long[][] costW;
    private double[][] t;
    private double[][] tCOPY;
    private double[][] tTMP;
    private double[][] s;
    private double[] q;
    private double da;
    private double db;
    private double dc;
    private int previousStrategy;
    private int[] strStat = new int[5];
    private double costDel;
    private double costIns;
    private double costMatch;

    public RtedAlgorithm(double delCost, double insCost, double matchCost) {
        this.costDel = delCost;
        this.costIns = insCost;
        this.costMatch = matchCost;
    }

    public double nonNormalizedTreeDist(Tree t1, Tree t2) {
        this.init(t1, t2);
        this.str = new int[this.size1][this.size2];
        this.computeOptimalStrategy();
        return this.computeDistUsingStrArray(this.it1, this.it2);
    }

    public double nonNormalizedTreeDist() {
        if (this.it1 == null || this.it2 == null) {
            System.err.println("No stored trees to compare.");
        }
        if (this.str == null) {
            System.err.println("No strategy to use.");
        }
        return this.computeDistUsingStrArray(this.it1, this.it2);
    }

    public void init(Tree t1, Tree t2) {
        this.ld = new LabelDictionary();
        this.it1 = new InfoTree(t1, this.ld);
        this.it2 = new InfoTree(t2, this.ld);
        this.size1 = this.it1.getSize();
        this.size2 = this.it2.getSize();
        this.ij = new int[Math.max(this.size1, this.size2)][Math.max(this.size1, this.size2)];
        this.delta = new double[this.size1][this.size2];
        this.deltaBit = new byte[this.size1][this.size2];
        this.costV = new long[3][this.size1][this.size2];
        this.costW = new long[3][this.size2];
        int[] labels1 = this.it1.getInfoArray(6);
        int[] labels2 = this.it2.getInfoArray(6);
        int[] sizes1 = this.it1.getInfoArray(0);
        int[] sizes2 = this.it2.getInfoArray(0);
        int x = 0;
        while (x < sizes1.length) {
            int y = 0;
            while (y < sizes2.length) {
                this.deltaBit[x][y] = labels1[x] == labels2[y] ? (byte)0 : 1;
                if (sizes1[x] == 1 && sizes2[y] == 1) {
                    this.delta[x][y] = 0.0;
                } else {
                    if (sizes1[x] == 1) {
                        this.delta[x][y] = sizes2[y] - 1;
                    }
                    if (sizes2[y] == 1) {
                        this.delta[x][y] = sizes1[x] - 1;
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    public void computeOptimalStrategy() {
        long min = -1L;
        int strategy = -1;
        int parent1 = -1;
        int parent2 = -1;
        boolean[] nodeTypeLeft1 = this.it1.nodeType[0];
        boolean[] nodeTypeLeft2 = this.it2.nodeType[0];
        boolean[] nodeTypeRigt1 = this.it1.nodeType[1];
        boolean[] nodeTypeRight2 = this.it2.nodeType[1];
        boolean[] nodeTypeHeavy1 = this.it1.nodeType[2];
        boolean[] nodeTypeHeavy2 = this.it2.nodeType[2];
        int[] post2size1 = this.it1.info[0];
        int[] post2size2 = this.it2.info[0];
        int[] post2descSum1 = this.it1.info[3];
        int[] post2descSum2 = this.it2.info[3];
        int[] post2krSum1 = this.it1.info[1];
        int[] post2krSum2 = this.it2.info[1];
        int[] post2revkrSum1 = this.it1.info[2];
        int[] post2revkrSum2 = this.it2.info[2];
        int[] post2parent1 = this.it1.info[5];
        int[] post2parent2 = this.it2.info[5];
        this.str = new int[this.size1][this.size2];
        int v = 0;
        while (v < this.size1) {
            Arrays.fill(this.costW[0], 0L);
            Arrays.fill(this.costW[1], 0L);
            Arrays.fill(this.costW[2], 0L);
            int w = 0;
            while (w < this.size2) {
                if (post2size2[w] == 1) {
                    this.costW[0][w] = 0L;
                    this.costW[1][w] = 0L;
                    this.costW[2][w] = 0L;
                }
                if (post2size1[v] == 1) {
                    this.costV[0][v][w] = 0L;
                    this.costV[1][v][w] = 0L;
                    this.costV[2][v][w] = 0L;
                }
                long heavyMin = (long)post2size1[v] * (long)post2descSum2[w] + this.costV[2][v][w];
                long revHeavyMin = (long)post2size2[w] * (long)post2descSum1[v] + this.costW[2][w];
                long leftMin = (long)post2size1[v] * (long)post2krSum2[w] + this.costV[0][v][w];
                long revLeftMin = (long)post2size2[w] * (long)post2krSum1[v] + this.costW[0][w];
                long rightMin = (long)post2size1[v] * (long)post2revkrSum2[w] + this.costV[1][v][w];
                long revRightMin = (long)post2size2[w] * (long)post2revkrSum1[v] + this.costW[1][w];
                long[] mins = new long[]{leftMin, rightMin, heavyMin, Long.MAX_VALUE, revLeftMin, revRightMin, revHeavyMin};
                min = leftMin;
                strategy = 0;
                int i = 1;
                while (i <= 6) {
                    if (mins[i] < min) {
                        min = mins[i];
                        strategy = i;
                    }
                    ++i;
                }
                this.str[v][w] = strategy;
                parent1 = post2parent1[v];
                if (parent1 != -1) {
                    long[] lArray = this.costV[2][parent1];
                    int n = w;
                    lArray[n] = lArray[n] + (nodeTypeHeavy1[v] ? this.costV[2][v][w] : min);
                    long[] lArray2 = this.costV[1][parent1];
                    int n2 = w;
                    lArray2[n2] = lArray2[n2] + (nodeTypeRigt1[v] ? this.costV[1][v][w] : min);
                    long[] lArray3 = this.costV[0][parent1];
                    int n3 = w;
                    lArray3[n3] = lArray3[n3] + (nodeTypeLeft1[v] ? this.costV[0][v][w] : min);
                }
                if ((parent2 = post2parent2[w]) != -1) {
                    long[] lArray = this.costW[2];
                    int n = parent2;
                    lArray[n] = lArray[n] + (nodeTypeHeavy2[w] ? this.costW[2][w] : min);
                    long[] lArray4 = this.costW[0];
                    int n4 = parent2;
                    lArray4[n4] = lArray4[n4] + (nodeTypeLeft2[w] ? this.costW[0][w] : min);
                    long[] lArray5 = this.costW[1];
                    int n5 = parent2;
                    lArray5[n5] = lArray5[n5] + (nodeTypeRight2[w] ? this.costW[1][w] : min);
                }
                ++w;
            }
            ++v;
        }
    }

    private double computeDistUsingStrArray(InfoTree it1, InfoTree it2) {
        int postorder1 = it1.getCurrentNode();
        int postorder2 = it2.getCurrentNode();
        int stepStrategy = this.str[postorder1][postorder2];
        switch (stepStrategy) {
            case 0: {
                int tmpPostorder = postorder1;
                int[] stepPath = it1.getPath(0);
                while (stepPath[postorder1] > -1) {
                    int[] stepRelSubtrees = it1.getNodeRelSubtrees(0, postorder1);
                    if (stepRelSubtrees != null) {
                        int[] nArray = stepRelSubtrees;
                        int n = stepRelSubtrees.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int rs = nArray[n2];
                            it1.setCurrentNode(rs);
                            this.computeDistUsingStrArray(it1, it2);
                            ++n2;
                        }
                    }
                    postorder1 = stepPath[postorder1];
                }
                it1.setCurrentNode(tmpPostorder);
                it1.setSwitched(false);
                it2.setSwitched(false);
                this.strStat[3] = this.strStat[3] + 1;
                this.strStat[0] = this.strStat[0] + 1;
                return this.spfL(it1, it2);
            }
            case 1: {
                int tmpPostorder = postorder1;
                int[] stepPath = it1.getPath(1);
                while (stepPath[postorder1] > -1) {
                    int[] stepRelSubtrees = it1.getNodeRelSubtrees(1, postorder1);
                    if (stepRelSubtrees != null) {
                        int[] nArray = stepRelSubtrees;
                        int n = stepRelSubtrees.length;
                        int n3 = 0;
                        while (n3 < n) {
                            int rs = nArray[n3];
                            it1.setCurrentNode(rs);
                            this.computeDistUsingStrArray(it1, it2);
                            ++n3;
                        }
                    }
                    postorder1 = stepPath[postorder1];
                }
                it1.setCurrentNode(tmpPostorder);
                it1.setSwitched(false);
                it2.setSwitched(false);
                this.strStat[3] = this.strStat[3] + 1;
                this.strStat[1] = this.strStat[1] + 1;
                return this.spfR(it1, it2);
            }
            case 2: {
                int tmpPostorder = postorder1;
                int[] stepPath = it1.getPath(2);
                ArrayList<Integer> heavyPath = new ArrayList<Integer>();
                heavyPath.add(postorder1);
                while (stepPath[postorder1] > -1) {
                    int[] stepRelSubtrees = it1.getNodeRelSubtrees(2, postorder1);
                    if (stepRelSubtrees != null) {
                        int[] nArray = stepRelSubtrees;
                        int n = stepRelSubtrees.length;
                        int n4 = 0;
                        while (n4 < n) {
                            int rs = nArray[n4];
                            it1.setCurrentNode(rs);
                            this.computeDistUsingStrArray(it1, it2);
                            ++n4;
                        }
                    }
                    postorder1 = stepPath[postorder1];
                    heavyPath.add(postorder1);
                }
                it1.setCurrentNode(tmpPostorder);
                it1.setSwitched(false);
                it2.setSwitched(false);
                this.strStat[3] = this.strStat[3] + 1;
                this.strStat[2] = this.strStat[2] + 1;
                return this.spfH(it1, it2, InfoTree.toIntArray(heavyPath));
            }
            case 4: {
                int tmpPostorder = postorder2;
                int[] stepPath = it2.getPath(0);
                while (stepPath[postorder2] > -1) {
                    int[] stepRelSubtrees = it2.getNodeRelSubtrees(0, postorder2);
                    if (stepRelSubtrees != null) {
                        int[] nArray = stepRelSubtrees;
                        int n = stepRelSubtrees.length;
                        int n5 = 0;
                        while (n5 < n) {
                            int rs = nArray[n5];
                            it2.setCurrentNode(rs);
                            this.computeDistUsingStrArray(it1, it2);
                            ++n5;
                        }
                    }
                    postorder2 = stepPath[postorder2];
                }
                it2.setCurrentNode(tmpPostorder);
                it1.setSwitched(true);
                it2.setSwitched(true);
                this.strStat[3] = this.strStat[3] + 1;
                this.strStat[0] = this.strStat[0] + 1;
                return this.spfL(it2, it1);
            }
            case 5: {
                int tmpPostorder = postorder2;
                int[] stepPath = it2.getPath(1);
                while (stepPath[postorder2] > -1) {
                    int[] stepRelSubtrees = it2.getNodeRelSubtrees(1, postorder2);
                    if (stepRelSubtrees != null) {
                        int[] nArray = stepRelSubtrees;
                        int n = stepRelSubtrees.length;
                        int n6 = 0;
                        while (n6 < n) {
                            int rs = nArray[n6];
                            it2.setCurrentNode(rs);
                            this.computeDistUsingStrArray(it1, it2);
                            ++n6;
                        }
                    }
                    postorder2 = stepPath[postorder2];
                }
                it2.setCurrentNode(tmpPostorder);
                it1.setSwitched(true);
                it2.setSwitched(true);
                this.strStat[3] = this.strStat[3] + 1;
                this.strStat[1] = this.strStat[1] + 1;
                return this.spfR(it2, it1);
            }
            case 6: {
                int tmpPostorder = postorder2;
                int[] stepPath = it2.getPath(2);
                ArrayList<Integer> heavyPath = new ArrayList<Integer>();
                heavyPath.add(postorder2);
                while (stepPath[postorder2] > -1) {
                    int[] stepRelSubtrees = it2.getNodeRelSubtrees(2, postorder2);
                    if (stepRelSubtrees != null) {
                        int[] nArray = stepRelSubtrees;
                        int n = stepRelSubtrees.length;
                        int n7 = 0;
                        while (n7 < n) {
                            int rs = nArray[n7];
                            it2.setCurrentNode(rs);
                            this.computeDistUsingStrArray(it1, it2);
                            ++n7;
                        }
                    }
                    postorder2 = stepPath[postorder2];
                    heavyPath.add(postorder2);
                }
                it2.setCurrentNode(tmpPostorder);
                it1.setSwitched(true);
                it2.setSwitched(true);
                this.strStat[3] = this.strStat[3] + 1;
                this.strStat[2] = this.strStat[2] + 1;
                return this.spfH(it2, it1, InfoTree.toIntArray(heavyPath));
            }
        }
        return -1.0;
    }

    private double spfL(InfoTree it1, InfoTree it2) {
        int fPostorder = it1.getCurrentNode();
        int gPostorder = it2.getCurrentNode();
        int minKR = it2.info[9][gPostorder];
        int[] kr = it2.info[7];
        if (minKR > -1) {
            int j = minKR;
            while (kr[j] < gPostorder) {
                this.treeEditDist(it1, it2, fPostorder, kr[j]);
                ++j;
            }
        }
        this.treeEditDist(it1, it2, fPostorder, gPostorder);
        return it1.isSwitched() ? this.delta[gPostorder][fPostorder] + (double)this.deltaBit[gPostorder][fPostorder] * this.costMatch : this.delta[fPostorder][gPostorder] + (double)this.deltaBit[fPostorder][gPostorder] * this.costMatch;
    }

    private void treeEditDist(InfoTree it1, InfoTree it2, int i, int j) {
        int m = i - it1.info[8][i] + 2;
        int n = j - it2.info[8][j] + 2;
        double[][] forestdist = new double[m][n];
        int ioff = it1.info[8][i] - 1;
        int joff = it2.info[8][j] - 1;
        boolean switched = it1.isSwitched();
        forestdist[0][0] = 0.0;
        int i1 = 1;
        while (i1 <= i - ioff) {
            forestdist[i1][0] = forestdist[i1 - 1][0] + 1.0;
            ++i1;
        }
        int j1 = 1;
        while (j1 <= j - joff) {
            forestdist[0][j1] = forestdist[0][j1 - 1] + 1.0;
            ++j1;
        }
        i1 = 1;
        while (i1 <= i - ioff) {
            int j12 = 1;
            while (j12 <= j - joff) {
                double u;
                if (it1.info[8][i1 + ioff] == it1.info[8][i] && it2.info[8][j12 + joff] == it2.info[8][j]) {
                    u = 0.0;
                    if (it1.info[6][i1 + ioff] != it2.info[6][j12 + joff]) {
                        u = this.costMatch;
                    }
                    this.da = forestdist[i1 - 1][j12] + this.costDel;
                    this.db = forestdist[i1][j12 - 1] + this.costIns;
                    this.dc = forestdist[i1 - 1][j12 - 1] + u;
                    forestdist[i1][j12] = this.da < this.db ? (this.da < this.dc ? this.da : this.dc) : (this.db < this.dc ? this.db : this.dc);
                    this.setDeltaValue(i1 + ioff, j12 + joff, forestdist[i1 - 1][j12 - 1], switched);
                    this.setDeltaBitValue(i1 + ioff, j12 + joff, (byte)(forestdist[i1][j12] - forestdist[i1 - 1][j12 - 1] > 0.0 ? 1 : 0), switched);
                } else {
                    u = 0.0;
                    u = switched ? (double)this.deltaBit[j12 + joff][i1 + ioff] * this.costMatch : (double)this.deltaBit[i1 + ioff][j12 + joff] * this.costMatch;
                    this.da = forestdist[i1 - 1][j12] + this.costDel;
                    this.db = forestdist[i1][j12 - 1] + this.costIns;
                    this.dc = forestdist[it1.info[8][i1 + ioff] - 1 - ioff][it2.info[8][j12 + joff] - 1 - joff] + (switched ? this.delta[j12 + joff][i1 + ioff] : this.delta[i1 + ioff][j12 + joff]) + u;
                    forestdist[i1][j12] = this.da < this.db ? (this.da < this.dc ? this.da : this.dc) : (this.db < this.dc ? this.db : this.dc);
                }
                ++j12;
            }
            ++i1;
        }
    }

    private double spfR(InfoTree it1, InfoTree it2) {
        int fReversedPostorder = it1.getSize() - 1 - it1.info[4][it1.getCurrentNode()];
        int gReversedPostorder = it2.getSize() - 1 - it2.info[4][it2.getCurrentNode()];
        int minRKR = it2.info[12][gReversedPostorder];
        int[] rkr = it2.info[10];
        if (minRKR > -1) {
            int j = minRKR;
            while (rkr[j] < gReversedPostorder) {
                this.treeEditDistRev(it1, it2, fReversedPostorder, rkr[j]);
                ++j;
            }
        }
        this.treeEditDistRev(it1, it2, fReversedPostorder, gReversedPostorder);
        return it1.isSwitched() ? this.delta[it2.getCurrentNode()][it1.getCurrentNode()] + (double)this.deltaBit[it2.getCurrentNode()][it1.getCurrentNode()] * this.costMatch : this.delta[it1.getCurrentNode()][it2.getCurrentNode()] + (double)this.deltaBit[it1.getCurrentNode()][it2.getCurrentNode()] * this.costMatch;
    }

    private void treeEditDistRev(InfoTree it1, InfoTree it2, int i, int j) {
        int m = i - it1.info[11][i] + 2;
        int n = j - it2.info[11][j] + 2;
        double[][] forestdist = new double[m][n];
        int ioff = it1.info[11][i] - 1;
        int joff = it2.info[11][j] - 1;
        boolean switched = it1.isSwitched();
        forestdist[0][0] = 0.0;
        int i1 = 1;
        while (i1 <= i - ioff) {
            forestdist[i1][0] = forestdist[i1 - 1][0] + 1.0;
            ++i1;
        }
        int j1 = 1;
        while (j1 <= j - joff) {
            forestdist[0][j1] = forestdist[0][j1 - 1] + 1.0;
            ++j1;
        }
        i1 = 1;
        while (i1 <= i - ioff) {
            int j12 = 1;
            while (j12 <= j - joff) {
                double u;
                if (it1.info[11][i1 + ioff] == it1.info[11][i] && it2.info[11][j12 + joff] == it2.info[11][j]) {
                    u = 0.0;
                    if (it1.info[6][it1.info[13][i1 + ioff]] != it2.info[6][it2.info[13][j12 + joff]]) {
                        u = this.costMatch;
                    }
                    this.da = forestdist[i1 - 1][j12] + this.costDel;
                    this.db = forestdist[i1][j12 - 1] + this.costIns;
                    this.dc = forestdist[i1 - 1][j12 - 1] + u;
                    forestdist[i1][j12] = this.da < this.db ? (this.da < this.dc ? this.da : this.dc) : (this.db < this.dc ? this.db : this.dc);
                    this.setDeltaValue(it1.info[13][i1 + ioff], it2.info[13][j12 + joff], forestdist[i1 - 1][j12 - 1], switched);
                    this.setDeltaBitValue(it1.info[13][i1 + ioff], it2.info[13][j12 + joff], (byte)(forestdist[i1][j12] - forestdist[i1 - 1][j12 - 1] > 0.0 ? 1 : 0), switched);
                } else {
                    u = 0.0;
                    u = switched ? (double)this.deltaBit[it2.info[13][j12 + joff]][it1.info[13][i1 + ioff]] * this.costMatch : (double)this.deltaBit[it1.info[13][i1 + ioff]][it2.info[13][j12 + joff]] * this.costMatch;
                    this.da = forestdist[i1 - 1][j12] + this.costDel;
                    this.db = forestdist[i1][j12 - 1] + this.costIns;
                    this.dc = forestdist[it1.info[11][i1 + ioff] - 1 - ioff][it2.info[11][j12 + joff] - 1 - joff] + (switched ? this.delta[it2.info[13][j12 + joff]][it1.info[13][i1 + ioff]] : this.delta[it1.info[13][i1 + ioff]][it2.info[13][j12 + joff]]) + u;
                    forestdist[i1][j12] = this.da < this.db ? (this.da < this.dc ? this.da : this.dc) : (this.db < this.dc ? this.db : this.dc);
                }
                ++j12;
            }
            ++i1;
        }
    }

    private double spfH(InfoTree it1, InfoTree it2, int[] heavyPath) {
        int fSize = it1.info[0][it1.getCurrentNode()];
        int gSize = it2.info[0][it2.getCurrentNode()];
        int gRevPre = it2.getSize() - 1 - it2.getCurrentNode();
        int gPre = it2.info[4][it2.getCurrentNode()];
        int gTreeSize = it2.getSize();
        this.t = new double[gSize][gSize];
        this.tCOPY = new double[gSize][gSize];
        this.s = new double[fSize][gSize];
        this.q = new double[fSize];
        int vp = -1;
        int nextVp = -1;
        int it = heavyPath.length - 1;
        while (it >= 0) {
            int j;
            int jOfi;
            int i;
            vp = heavyPath[it];
            int strategy = it1.info[14][vp];
            if (strategy != 3) {
                if (it1.info[0][vp] == 1) {
                    i = gSize - 1;
                    while (i >= 0) {
                        j = jOfi = this.jOfI(it2, i, gSize, gRevPre, gPre, strategy, gTreeSize);
                        while (j >= 0) {
                            this.t[i][j] = (double)(gSize - (i + j)) * this.costIns;
                            --j;
                        }
                        --i;
                    }
                    this.previousStrategy = strategy;
                }
                this.computePeriod(it1, vp, nextVp, it2, strategy);
            } else {
                if (it1.info[0][vp] == 1) {
                    i = gSize - 1;
                    while (i >= 0) {
                        j = jOfi = this.jOfI(it2, i, gSize, gRevPre, gPre, 0, gTreeSize);
                        while (j >= 0) {
                            this.t[i][j] = (double)(gSize - (i + j)) * this.costIns;
                            --j;
                        }
                        --i;
                    }
                    this.previousStrategy = 0;
                }
                this.computePeriod(it1, vp, nextVp, it2, 0);
                if (it1.info[0][vp] == 1) {
                    i = gSize - 1;
                    while (i >= 0) {
                        j = jOfi = this.jOfI(it2, i, gSize, gRevPre, gPre, 1, gTreeSize);
                        while (j >= 0) {
                            this.t[i][j] = (double)(gSize - (i + j)) * this.costIns;
                            --j;
                        }
                        --i;
                    }
                    this.previousStrategy = 1;
                }
                this.computePeriod(it1, vp, nextVp, it2, 1);
            }
            nextVp = vp;
            --it;
        }
        return this.t[0][0];
    }

    private void computePeriod(InfoTree it1, int aVp, int aNextVp, InfoTree it2, int aStrategy) {
        int k;
        int fTreeSize = it1.getSize();
        int gTreeSize = it2.getSize();
        int vpPreorder = it1.info[4][aVp];
        int vpRevPreorder = fTreeSize - 1 - aVp;
        int vpSize = it1.info[0][aVp];
        int gSize = it2.info[0][it2.getCurrentNode()];
        int gPreorder = it2.info[4][it2.getCurrentNode()];
        int gRevPreorder = gTreeSize - 1 - it2.getCurrentNode();
        int nextVpPreorder = -1;
        int nextVpRevPreorder = -1;
        int nextVpSize = -1;
        if (aNextVp != -1) {
            nextVpPreorder = it1.info[4][aNextVp];
            nextVpRevPreorder = fTreeSize - 1 - aNextVp;
            nextVpSize = it1.info[0][aNextVp];
            int n = k = aStrategy == 0 ? nextVpPreorder - vpPreorder : nextVpRevPreorder - vpRevPreorder;
            if (aStrategy != this.previousStrategy) {
                this.computeIJTable(it2, gPreorder, gRevPreorder, gSize, aStrategy, gTreeSize);
            }
        } else {
            k = 1;
            this.computeIJTable(it2, gPreorder, gRevPreorder, gSize, aStrategy, gTreeSize);
        }
        int realStrategy = it1.info[14][aVp];
        boolean switched = it1.isSwitched();
        this.tTMP = this.tCOPY;
        this.tCOPY = this.t;
        this.t = this.tTMP;
        if (vpSize - nextVpSize == 1) {
            if (gSize == 1) {
                this.setDeltaValue(it1.info[15][vpPreorder], it2.info[15][gPreorder], vpSize - 1, switched);
            } else {
                this.setDeltaValue(it1.info[15][vpPreorder], it2.info[15][gPreorder], this.t[1][0], switched);
            }
        }
        int i = gSize - 1;
        while (i >= 0) {
            int previousI;
            int jOfI = this.jOfI(it2, i, gSize, gRevPreorder, gPreorder, aStrategy, gTreeSize);
            int kPrime = 1;
            while (kPrime <= k) {
                int fForestPreorderKPrime = aStrategy == 0 ? vpPreorder + (k - kPrime) : it1.info[4][fTreeSize - 1 - (vpRevPreorder + (k - kPrime))];
                int kBis = kPrime - it1.info[0][it1.info[15][fForestPreorderKPrime]];
                double deleteFromRight = this.costIns;
                double deleteFromLeft = this.costDel;
                double match = 0.0;
                match += (double)(aStrategy == 0 ? kBis + nextVpSize : vpSize - k + kBis);
                deleteFromRight = i + jOfI == gSize - 1 ? (deleteFromRight += (double)(vpSize - (k - kPrime))) : (deleteFromRight += this.q[kPrime - 1]);
                int fLabel = it1.info[6][it1.info[15][fForestPreorderKPrime]];
                int j = jOfI;
                while (j >= 0) {
                    int gijForestPreorder;
                    int n = gijForestPreorder = aStrategy == 0 ? this.ij[i][j] : it2.info[4][gTreeSize - 1 - this.ij[i][j]];
                    if (kPrime == 1) {
                        if (aStrategy != this.previousStrategy) {
                            previousI = aStrategy == 0 ? gijForestPreorder - gPreorder : gTreeSize - 1 - it2.info[13][gTreeSize - 1 - gijForestPreorder] - gRevPreorder;
                            deleteFromLeft += this.tCOPY[previousI][i + j - previousI];
                        } else {
                            deleteFromLeft += this.tCOPY[i][j];
                        }
                    } else {
                        deleteFromLeft += this.s[kPrime - 1 - 1][j];
                    }
                    match += switched ? this.delta[it2.info[15][gijForestPreorder]][it1.info[15][fForestPreorderKPrime]] : this.delta[it1.info[15][fForestPreorderKPrime]][it2.info[15][gijForestPreorder]];
                    int jPrime = j + it2.info[0][it2.info[15][gijForestPreorder]];
                    int gLabel = it2.info[6][it2.info[15][gijForestPreorder]];
                    if (fLabel != gLabel) {
                        match += this.costMatch;
                    }
                    if (j != jOfI) {
                        deleteFromRight += this.s[kPrime - 1][j + 1];
                        if (kBis == 0) {
                            if (aStrategy != this.previousStrategy) {
                                previousI = aStrategy == 0 ? this.ij[i][jPrime] - gPreorder : this.ij[i][jPrime] - gRevPreorder;
                                match += this.tCOPY[previousI][i + jPrime - previousI];
                            } else {
                                match += this.tCOPY[i][jPrime];
                            }
                        } else {
                            match = kBis > 0 ? (match += this.s[kBis - 1][jPrime]) : (match += (double)(gSize - (i + jPrime)));
                        }
                    }
                    this.s[kPrime - 1][j] = deleteFromLeft < deleteFromRight ? (deleteFromLeft < match ? deleteFromLeft : match) : (deleteFromRight < match ? deleteFromRight : match);
                    deleteFromRight = this.costIns;
                    deleteFromLeft = this.costDel;
                    match = 0.0;
                    --j;
                }
                ++kPrime;
            }
            double[] dArray = this.t[i] = realStrategy == 3 && aStrategy == 0 ? (double[])this.s[k - 1 - 1].clone() : (double[])this.s[k - 1].clone();
            if (i > 0) {
                int jOfIminus1 = this.jOfI(it2, i - 1, gSize, gRevPreorder, gPreorder, aStrategy, gTreeSize);
                if (jOfIminus1 <= jOfI) {
                    int x = 0;
                    while (x < k) {
                        this.q[x] = this.s[x][jOfIminus1];
                        ++x;
                    }
                }
                if (i + jOfIminus1 < gSize) {
                    int gijOfIMinus1Preorder;
                    int n = gijOfIMinus1Preorder = aStrategy == 0 ? it2.info[4][gTreeSize - 1 - (gRevPreorder + (i - 1))] : gPreorder + (i - 1);
                    if (k - 1 - 1 < 0) {
                        if (aStrategy != this.previousStrategy) {
                            previousI = aStrategy == 0 ? this.ij[i][jOfIminus1] - gPreorder : this.ij[i][jOfIminus1] - gRevPreorder;
                            this.setDeltaValue(it1.info[15][vpPreorder], it2.info[15][gijOfIMinus1Preorder], this.tCOPY[previousI][i + jOfIminus1 - previousI], switched);
                        } else {
                            this.setDeltaValue(it1.info[15][vpPreorder], it2.info[15][gijOfIMinus1Preorder], this.tCOPY[i][jOfIminus1], switched);
                        }
                    } else {
                        this.setDeltaValue(it1.info[15][vpPreorder], it2.info[15][gijOfIMinus1Preorder], this.s[k - 1 - 1][jOfIminus1], switched);
                    }
                }
            }
            --i;
        }
        this.previousStrategy = aStrategy;
    }

    private void computeIJTable(InfoTree it, int subtreePreorder, int subtreeRevPreorder, int subtreeSize, int aStrategy, int treeSize) {
        int[] post2pre = it.info[4];
        int[] rpost2post = it.info[13];
        if (aStrategy == 0) {
            int x = 0;
            while (x < subtreeSize) {
                this.ij[0][x] = x + subtreePreorder;
                ++x;
            }
            x = 1;
            while (x < subtreeSize) {
                int change = post2pre[treeSize - 1 - (x - 1 + subtreeRevPreorder)];
                int z = 0;
                while (z < subtreeSize) {
                    this.ij[x][z] = this.ij[x - 1][z] >= change ? this.ij[x - 1][z] + 1 : this.ij[x - 1][z];
                    ++z;
                }
                ++x;
            }
        } else {
            int x = 0;
            while (x < subtreeSize) {
                this.ij[0][x] = x + subtreeRevPreorder;
                ++x;
            }
            x = 1;
            while (x < subtreeSize) {
                int change = treeSize - 1 - rpost2post[treeSize - 1 - (x - 1 + subtreePreorder)];
                int z = 0;
                while (z < subtreeSize) {
                    this.ij[x][z] = this.ij[x - 1][z] >= change ? this.ij[x - 1][z] + 1 : this.ij[x - 1][z];
                    ++z;
                }
                ++x;
            }
        }
    }

    private int jOfI(InfoTree it, int aI, int aSubtreeWeight, int aSubtreeRevPre, int aSubtreePre, int aStrategy, int treeSize) {
        return aStrategy == 0 ? aSubtreeWeight - aI - it.info[0][treeSize - 1 - (aSubtreeRevPre + aI)] : aSubtreeWeight - aI - it.info[0][it.info[13][treeSize - 1 - (aSubtreePre + aI)]];
    }

    private void setDeltaValue(int a, int b, double value, boolean switched) {
        if (switched) {
            this.delta[b][a] = value;
        } else {
            this.delta[a][b] = value;
        }
    }

    private void setDeltaBitValue(int a, int b, byte value, boolean switched) {
        if (switched) {
            this.deltaBit[b][a] = value;
        } else {
            this.deltaBit[a][b] = value;
        }
    }

    public void setCustomCosts(double costDel, double costIns, double costMatch) {
        this.costDel = costDel;
        this.costIns = costIns;
        this.costMatch = costMatch;
    }

    public void setCustomStrategy(int[][] strategyArray) {
        this.str = strategyArray;
    }

    public void setCustomStrategy(int strategy, boolean ifSwitch) {
        this.str = new int[this.size1][this.size2];
        if (ifSwitch) {
            int i = 0;
            while (i < this.size1) {
                int j = 0;
                while (j < this.size2) {
                    this.str[i][j] = this.it1.info[0][i] >= this.it2.info[0][j] ? strategy : strategy + 4;
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size1) {
                Arrays.fill(this.str[i], strategy);
                ++i;
            }
        }
    }

    public LinkedList<int[]> computeEditMapping() {
        double[][] treedist = new double[this.size1 + 1][this.size2 + 1];
        double[][] forestdist = new double[this.size1 + 1][this.size2 + 1];
        boolean rootNodePair = true;
        int i = 0;
        while (i < this.size1) {
            treedist[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j < this.size2) {
            treedist[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= this.size1) {
            int j2 = 1;
            while (j2 <= this.size2) {
                treedist[i][j2] = this.delta[i - 1][j2 - 1] + (double)this.deltaBit[i - 1][j2 - 1];
                ++j2;
            }
            ++i;
        }
        this.forestDist(this.it1, this.it2, this.size1, this.size2, treedist, forestdist);
        LinkedList<int[]> editMapping = new LinkedList<int[]>();
        LinkedList<int[]> treePairs = new LinkedList<int[]>();
        treePairs.push(new int[]{this.size1, this.size2});
        while (!treePairs.isEmpty()) {
            int[] treePair = (int[])treePairs.pop();
            int lastRow = treePair[0];
            int lastCol = treePair[1];
            if (!rootNodePair) {
                this.forestDist(this.it1, this.it2, lastRow, lastCol, treedist, forestdist);
            }
            rootNodePair = false;
            int firstRow = this.it1.getInfo(8, lastRow - 1) + 1 - 1;
            int firstCol = this.it2.getInfo(8, lastCol - 1) + 1 - 1;
            int row = lastRow;
            int col = lastCol;
            while (row > firstRow || col > firstCol) {
                if (row > firstRow && forestdist[row - 1][col] + this.costDel == forestdist[row][col]) {
                    int[] nArray = new int[2];
                    nArray[0] = row--;
                    editMapping.push(nArray);
                    continue;
                }
                if (col > firstCol && forestdist[row][col - 1] + this.costIns == forestdist[row][col]) {
                    int[] nArray = new int[2];
                    nArray[1] = col--;
                    editMapping.push(nArray);
                    continue;
                }
                if (this.it1.getInfo(8, row - 1) == this.it1.getInfo(8, lastRow - 1) && this.it2.getInfo(8, col - 1) == this.it2.getInfo(8, lastCol - 1)) {
                    editMapping.push(new int[]{row--, col--});
                    continue;
                }
                treePairs.push(new int[]{row, col});
                row = this.it1.getInfo(8, row - 1) + 1 - 1;
                col = this.it2.getInfo(8, col - 1) + 1 - 1;
            }
        }
        return editMapping;
    }

    private void forestDist(InfoTree ted1, InfoTree ted2, int i, int j, double[][] treedist, double[][] forestdist) {
        forestdist[ted1.getInfo((int)8, (int)(i - 1)) + 1 - 1][ted2.getInfo((int)8, (int)(j - 1)) + 1 - 1] = 0.0;
        int di = ted1.getInfo(8, i - 1) + 1;
        while (di <= i) {
            forestdist[di][ted2.getInfo((int)8, (int)(j - 1)) + 1 - 1] = forestdist[di - 1][ted2.getInfo(8, j - 1) + 1 - 1] + this.costDel;
            int dj = ted2.getInfo(8, j - 1) + 1;
            while (dj <= j) {
                forestdist[ted1.getInfo((int)8, (int)(i - 1)) + 1 - 1][dj] = forestdist[ted1.getInfo(8, i - 1) + 1 - 1][dj - 1] + this.costIns;
                if (ted1.getInfo(8, di - 1) == ted1.getInfo(8, i - 1) && ted2.getInfo(8, dj - 1) == ted2.getInfo(8, j - 1)) {
                    double costRen = 0.0;
                    if (ted1.getInfo(6, di - 1) != ted2.getInfo(6, dj - 1)) {
                        costRen = this.costMatch;
                    }
                    forestdist[di][dj] = Math.min(Math.min(forestdist[di - 1][dj] + this.costDel, forestdist[di][dj - 1] + this.costIns), forestdist[di - 1][dj - 1] + costRen);
                    treedist[di][dj] = forestdist[di][dj];
                } else {
                    forestdist[di][dj] = Math.min(Math.min(forestdist[di - 1][dj] + this.costDel, forestdist[di][dj - 1] + this.costIns), forestdist[ted1.getInfo(8, di - 1) + 1 - 1][ted2.getInfo(8, dj - 1) + 1 - 1] + treedist[di][dj]);
                }
                ++dj;
            }
            ++di;
        }
    }
}

