/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.optimal.zs;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.matchers.optimal.zs.ComputeTreeCost;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.Tree;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ZsMatcher
extends Matcher {
    private TreeInfo src;
    private TreeInfo dst;
    private double[][] dist;
    private ComputeTreeCost cost;

    public ZsMatcher(Tree src, Tree dst, Set<Mapping> mappings) {
        super(src, dst);
        this.src = new TreeInfo(src);
        this.dst = new TreeInfo(dst);
        this.dist = new double[src.getSize()][dst.getSize()];
        this.cost = new ComputeTreeCost();
        int i = 0;
        while (i < this.dist.length) {
            Arrays.fill(this.dist[i], -1.0);
            ++i;
        }
        this.match();
    }

    public ZsMatcher(Tree src, Tree dst) {
        this(src, dst, new HashSet<Mapping>());
    }

    private void computeMappings() {
        double[][] matrix = this.forestDist(this.src.size() - 1, this.dst.size() - 1);
        int prevCol = matrix[0].length - 1;
        int prevLine = matrix.length - 1;
        do {
            double lu;
            double l = (double)prevCol == 0.0 ? Double.MAX_VALUE : matrix[prevLine][prevCol - 1];
            double u = (double)prevLine == 0.0 ? Double.MAX_VALUE : matrix[prevLine - 1][prevCol];
            double d = lu = (double)prevCol == 0.0 || (double)prevLine == 0.0 ? Double.MAX_VALUE : matrix[prevLine - 1][prevCol - 1];
            if (l < u && l < lu) {
                --prevCol;
                continue;
            }
            if (u < lu && u < l) {
                --prevLine;
                continue;
            }
            this.addMapping(this.src.nodes[prevLine - 1], this.dst.nodes[prevCol - 1]);
            --prevCol;
            --prevLine;
        } while (prevCol >= 1 || prevLine >= 1);
    }

    private double align() {
        int startKrDst = 0;
        while (startKrDst < this.dst.kr.length) {
            if (this.dst.kr[startKrDst] != -1) break;
            ++startKrDst;
        }
        int i = 0;
        while (i < this.src.kr.length) {
            if (this.src.kr[i] != -1) {
                int j = startKrDst;
                while (j < this.dst.kr.length) {
                    this.treeDist(this.src.kr[i], this.dst.kr[j]);
                    ++j;
                }
            }
            ++i;
        }
        return this.dist[this.src.size() - 1][this.dst.size() - 1];
    }

    private double treeDist(int i, int j) {
        double d = this.dist[i][j];
        if (d != -1.0) {
            return d;
        }
        int li = this.src.lmd[i];
        int lj = this.dst.lmd[j];
        int ishift = i - li + 2;
        int jshift = j - lj + 2;
        double[][] fd = new double[ishift][jshift];
        int i1 = 1;
        while (i1 < ishift) {
            fd[i1][0] = fd[i1 - 1][0] + this.src.deleteCost(i1 - 1);
            ++i1;
        }
        int j1 = 1;
        while (j1 < jshift) {
            fd[0][j1] = fd[0][j1 - 1] + this.dst.insertCost(j1 - 1);
            ++j1;
        }
        int k = li;
        int kk = 1;
        while (k <= i) {
            int l = lj;
            int ll = 1;
            while (l <= j) {
                double up;
                double del;
                double ins;
                if (this.src.lmd[k] == li && this.dst.lmd[l] == lj) {
                    ins = fd[kk - 1][ll] + this.src.deleteCost(k);
                    del = fd[kk][ll - 1] + this.dst.insertCost(l);
                    up = fd[kk - 1][ll - 1] + this.updateCost(k, l);
                    double d2 = Math.min(ins, Math.min(del, up));
                    fd[kk][ll] = d2;
                    this.dist[k][l] = d2;
                } else {
                    ins = fd[kk - 1][ll] + this.src.deleteCost(k);
                    del = fd[kk][ll - 1] + this.dst.insertCost(l);
                    up = fd[this.src.lmd[k] - li][this.dst.lmd[l] - lj] + this.treeDist(k, l);
                    fd[kk][ll] = Math.min(ins, Math.min(del, up));
                }
                ++l;
                ++ll;
            }
            ++k;
            ++kk;
        }
        return this.dist[i][j];
    }

    private double[][] forestDist(int i, int j) {
        int li = this.src.lmd[i];
        int lj = this.dst.lmd[j];
        int ishift = i - li + 2;
        int jshift = j - lj + 2;
        double[][] fd = new double[ishift][jshift];
        int i1 = 1;
        while (i1 < ishift) {
            fd[i1][0] = fd[i1 - 1][0] + this.src.deleteCost(i1 - 1);
            ++i1;
        }
        int j1 = 1;
        while (j1 < jshift) {
            fd[0][j1] = fd[0][j1 - 1] + this.dst.insertCost(j1 - 1);
            ++j1;
        }
        int k = li;
        int kk = 1;
        while (k <= i) {
            int l = lj;
            int ll = 1;
            while (l <= j) {
                double up;
                double del;
                double ins;
                if (this.src.lmd[k] == li && this.dst.lmd[l] == lj) {
                    ins = fd[kk - 1][ll] + this.src.deleteCost(k);
                    del = fd[kk][ll - 1] + this.dst.insertCost(l);
                    up = fd[kk - 1][ll - 1] + this.updateCost(k, l);
                    double d = Math.min(ins, Math.min(del, up));
                    fd[kk][ll] = d;
                    this.dist[k][l] = d;
                } else {
                    ins = fd[kk - 1][ll] + this.src.deleteCost(k);
                    del = fd[kk][ll - 1] + this.dst.insertCost(l);
                    up = fd[this.src.lmd[k] - li][this.dst.lmd[l] - lj] + this.treeDist(k, l);
                    fd[kk][ll] = Math.min(ins, Math.min(del, up));
                }
                ++l;
                ++ll;
            }
            ++k;
            ++kk;
        }
        return fd;
    }

    private double updateCost(int node, int other) {
        return this.cost.updateCost(this.src.nodes[node], this.dst.nodes[other]);
    }

    @Override
    public void match() {
        this.align();
        this.computeMappings();
    }

    private final class TreeInfo {
        private Tree root;
        private Tree[] nodes;
        private int[] lmd;
        private int[] kr;

        private TreeInfo(Tree t) {
            this.root = t;
            int size = t.getSize();
            this.nodes = new Tree[size];
            this.lmd = new int[size];
            this.kr = new int[size];
            Arrays.fill(this.kr, -1);
            this.postOrderNumbering(this.root, 0);
            Arrays.sort(this.kr);
        }

        private double insertCost(int n) {
            return ZsMatcher.this.cost.insertCost(this.nodes[n]);
        }

        private double deleteCost(int n) {
            return ZsMatcher.this.cost.deleteCost(this.nodes[n]);
        }

        private int size() {
            return this.nodes.length;
        }

        private int postOrderNumbering(Tree t, int nb) {
            int l = nb;
            if (!t.isLeaf()) {
                for (Tree n : t.getChildren()) {
                    nb = this.postOrderNumbering(n, nb);
                }
            }
            this.nodes[nb] = t;
            this.lmd[nb] = l;
            this.kr[l] = nb;
            return nb + 1;
        }
    }
}

