/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.utils.collections;

import fr.labri.utils.collections.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DoubleMap<A, B> {
    private Map<A, B> srcMap = new HashMap<A, B>();
    private Map<B, A> dstMap = new HashMap<B, A>();

    public DoubleMap() {
    }

    public DoubleMap(Set<Pair<A, B>> pairs) {
        this();
        for (Pair<A, B> p : pairs) {
            this.add(p);
        }
    }

    public Set<Pair<A, B>> getPairs() {
        HashSet<Pair<A, B>> pairs = new HashSet<Pair<A, B>>();
        for (A src : this.srcMap.keySet()) {
            pairs.add(new Pair<A, B>(src, this.getDst(src)));
        }
        return pairs;
    }

    public void add(Pair<A, B> pair) {
        this.add(pair.getFirst(), pair.getSecond());
    }

    public void add(Set<Pair<A, B>> pairs) {
        for (Pair<A, B> p : pairs) {
            this.add(p);
        }
    }

    public void add(A src, B dst) {
        this.srcMap.put(src, dst);
        this.dstMap.put(dst, src);
    }

    public B getDst(A src) {
        return this.srcMap.get(src);
    }

    public A getSrc(B dst) {
        return this.dstMap.get(dst);
    }

    public Set<A> getSrcs() {
        return this.srcMap.keySet();
    }

    public Set<B> getDsts() {
        return this.dstMap.keySet();
    }

    public void clear() {
        this.srcMap.clear();
        this.dstMap.clear();
    }
}

