/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.utils.file;

import java.io.File;
import java.io.IOException;
import java.util.List;

public final class FileUtils {
    private FileUtils() {
    }

    public static String getExtension(String path) {
        return path.substring(path.lastIndexOf(".") + 1).toLowerCase();
    }

    public static void deleteFolder(String path) {
        FileUtils.deleteFolder(new File(path));
    }

    public static void deleteFolder(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.deleteFolder(new File(dir, children[i]));
            }
        }
        dir.delete();
    }

    public static String createTmpFolder(String prefix, String path) {
        try {
            File fTmpPath;
            File folder = null;
            folder = "".equals(path) ? ((fTmpPath = new File(path)).exists() && fTmpPath.canWrite() ? File.createTempFile(prefix, "", fTmpPath) : File.createTempFile(prefix, "")) : File.createTempFile(prefix, "");
            folder.delete();
            folder.mkdir();
            return folder.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void listAllFiles(File path, List<String> allFiles, String extension) {
        if (path.isDirectory()) {
            File[] list = path.listFiles();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    FileUtils.listAllFiles(list[i], allFiles, extension);
                }
            }
        } else {
            String currentFilePath = path.getAbsolutePath();
            if (currentFilePath.toLowerCase().endsWith(extension)) {
                allFiles.add(currentFilePath);
            }
        }
    }
}

