/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.utils.file;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class JavaFileUtils {
    private static Set<String> COMMON_ROOT_PACKAGES = new HashSet<String>(Arrays.asList("org", "com", "net", "fr", "de", "au", "net", "uk"));

    private JavaFileUtils() {
    }

    public static void main(String[] args) {
        System.out.println(JavaFileUtils.searchJars("../.."));
    }

    public static Set<File> searchJars(String path) {
        Set<File> files = JavaFileUtils.searchAllFiles(path);
        Iterator<File> fIt = files.iterator();
        while (fIt.hasNext()) {
            File f = fIt.next();
            if (!f.isFile()) {
                fIt.remove();
                continue;
            }
            if (f.getName().toLowerCase().endsWith(".jar")) continue;
            fIt.remove();
        }
        return files;
    }

    public static Set<File> searchJavaSourceFiles(String path) {
        Set<File> files = JavaFileUtils.searchAllFiles(path);
        Iterator<File> fIt = files.iterator();
        while (fIt.hasNext()) {
            File f = fIt.next();
            if (!f.isFile()) {
                fIt.remove();
                continue;
            }
            if (f.getName().toLowerCase().endsWith(".java")) continue;
            fIt.remove();
        }
        return files;
    }

    public static Set<File> searchJavaClassFiles(String path) {
        Set<File> files = JavaFileUtils.searchAllFiles(path);
        Iterator<File> fIt = files.iterator();
        while (fIt.hasNext()) {
            File f = fIt.next();
            if (!f.isFile()) {
                fIt.remove();
                continue;
            }
            if (f.getName().toLowerCase().endsWith(".class")) continue;
            fIt.remove();
        }
        return files;
    }

    public static Set<File> searchJavaSourceFolders(String path) {
        Set<File> files = JavaFileUtils.searchAllFiles(path);
        Iterator<File> fIt = files.iterator();
        while (fIt.hasNext()) {
            File f = fIt.next();
            if (!f.isDirectory()) {
                fIt.remove();
                continue;
            }
            if (!JavaFileUtils.isSourceFolder(f)) {
                fIt.remove();
                continue;
            }
            if (JavaFileUtils.searchJavaSourceFiles(f.getAbsolutePath()).size() != 0) continue;
            fIt.remove();
        }
        return files;
    }

    public static Set<File> searchJavaClassFolders(String path) {
        Set<File> files = JavaFileUtils.searchAllFiles(path);
        Iterator<File> fIt = files.iterator();
        while (fIt.hasNext()) {
            File f = fIt.next();
            if (!f.isDirectory()) {
                fIt.remove();
                continue;
            }
            if (!JavaFileUtils.isSourceFolder(f)) {
                fIt.remove();
                continue;
            }
            if (JavaFileUtils.searchJavaClassFiles(f.getAbsolutePath()).size() != 0) continue;
            fIt.remove();
        }
        return files;
    }

    private static boolean isSourceFolder(File folder) {
        File[] files;
        for (File unit : files = folder.listFiles()) {
            if (!unit.isDirectory() || !COMMON_ROOT_PACKAGES.contains(unit.getName())) continue;
            return true;
        }
        return false;
    }

    private static Set<File> searchAllFiles(String path) {
        HashSet<File> files = new HashSet<File>();
        File folder = new File(path);
        if (folder.isDirectory()) {
            JavaFileUtils.searchAllFiles(folder, files);
        }
        return files;
    }

    private static void searchAllFiles(File unit, Set<File> files) {
        if (unit.isDirectory() && (!unit.getName().startsWith(".") || unit.getName().equals(".") || unit.getName().equals(".."))) {
            files.add(unit);
            for (File f : unit.listFiles()) {
                JavaFileUtils.searchAllFiles(f, files);
            }
        } else {
            files.add(unit);
        }
    }
}

