/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.utils.match;

import fr.labri.utils.collections.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectThreshold<T> {
    private Map<T, List<Pair<T, Double>>> srcs = new HashMap<T, List<Pair<T, Double>>>();
    private Map<T, List<Pair<T, Double>>> dsts = new HashMap<T, List<Pair<T, Double>>>();
    private double threshold;

    public SelectThreshold(double threshold) {
    }

    public void addScore(T src, T dst, double score) {
        if (!this.srcs.containsKey(src)) {
            this.srcs.put(src, new ArrayList());
        }
        this.srcs.get(src).add(new Pair<T, Double>(dst, score));
        if (!this.dsts.containsKey(dst)) {
            this.dsts.put(src, new ArrayList());
        }
        this.srcs.get(dst).add(new Pair<T, Double>(src, score));
    }

    public List<Pair<T, T>> getMatches() {
        ArrayList<Pair<T, T>> matches = new ArrayList<Pair<T, T>>();
        for (T src : this.srcs.keySet()) {
            double bestSrcScore = this.getBestSrcScore(src);
            for (Pair<T, Double> match : this.srcs.get(src)) {
                T dst = match.getFirst();
                double currentScore = match.getSecond();
                double bestDstScore = this.getBestDstScore(dst);
                double relSrcScore = currentScore / bestSrcScore;
                double relDstScore = currentScore / bestDstScore;
                if (!(relSrcScore >= this.threshold) || !(relDstScore >= this.threshold)) continue;
                matches.add(new Pair<T, T>(src, dst));
            }
        }
        return matches;
    }

    private double getBestSrcScore(T src) {
        double best = Double.MIN_VALUE;
        for (Pair<T, Double> score : this.srcs.get(src)) {
            if (!(score.getSecond() >= best)) continue;
            best = score.getSecond();
        }
        return best;
    }

    private double getBestDstScore(T dst) {
        double best = Double.MIN_VALUE;
        for (Pair<T, Double> score : this.dsts.get(dst)) {
            if (!(score.getSecond() >= best)) continue;
            best = score.getSecond();
        }
        return best;
    }
}

