/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.CPJavaProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierQueries;
import org.eclipse.jdt.ui.PreferenceConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathModifier {
    private ClasspathModifier() {
    }

    public static BuildpathDelta setOutputLocation(CPListElement elementToChange, IPath outputPath, boolean allowInvalidCP, CPJavaProject cpProject) throws CoreException {
        IPath oldOutputLocation;
        BuildpathDelta result = new BuildpathDelta(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_tooltip);
        IJavaProject javaProject = cpProject.getJavaProject();
        IProject project = javaProject.getProject();
        IWorkspace workspace = project.getWorkspace();
        IPath projectPath = project.getFullPath();
        if (!allowInvalidCP && cpProject.getDefaultOutputLocation().segmentCount() == 1 && !projectPath.equals(elementToChange.getPath())) {
            String outputFolderName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            cpProject.setDefaultOutputLocation(cpProject.getDefaultOutputLocation().append(outputFolderName));
            List<CPListElement> existingEntries = cpProject.getCPListElements();
            CPListElement elem = ClasspathModifier.getListElement(javaProject.getPath(), existingEntries);
            if (elem != null) {
                existingEntries.remove(elem);
                result.removeEntry(elem);
            }
        }
        if (outputPath != null) {
            ClasspathModifier.exclude(outputPath, cpProject.getCPListElements(), new ArrayList<CPListElement>(), cpProject.getJavaProject(), null);
        }
        if ((oldOutputLocation = (IPath)elementToChange.getAttribute("output")) != null && oldOutputLocation.segmentCount() > 1 && !oldOutputLocation.equals(cpProject.getDefaultOutputLocation())) {
            ClasspathModifier.include(cpProject, oldOutputLocation);
            result.addDeletedResource(workspace.getRoot().getFolder(oldOutputLocation));
        }
        elementToChange.setAttribute("output", outputPath);
        result.setDefaultOutputLocation(cpProject.getDefaultOutputLocation());
        result.setNewEntries(cpProject.getCPListElements().toArray(new CPListElement[cpProject.getCPListElements().size()]));
        if (outputPath != null && outputPath.segmentCount() > 1) {
            result.addCreatedResource(workspace.getRoot().getFolder(outputPath));
        }
        return result;
    }

    public static IStatus checkSetOutputLocationPrecondition(CPListElement elementToChange, IPath outputPath, boolean allowInvalidCP, CPJavaProject cpProject) throws CoreException {
        IStatus pathValidation;
        IJavaProject javaProject = cpProject.getJavaProject();
        IProject project = javaProject.getProject();
        IWorkspace workspace = project.getWorkspace();
        IPath projectPath = project.getFullPath();
        if (outputPath == null) {
            outputPath = cpProject.getDefaultOutputLocation();
        }
        if (!(pathValidation = workspace.validatePath(outputPath.toString(), 6)).isOK()) {
            return new StatusInfo(4, Messages.format(NewWizardMessages.OutputLocationDialog_error_invalidpath, pathValidation.getMessage()));
        }
        IWorkspaceRoot root = workspace.getRoot();
        IResource res = root.findMember(outputPath);
        if (res != null && res.getType() == 1) {
            return new StatusInfo(4, NewWizardMessages.OutputLocationDialog_error_existingisfile);
        }
        IStatus result = StatusInfo.OK_STATUS;
        int index = cpProject.indexOf(elementToChange);
        cpProject = cpProject.createWorkingCopy();
        elementToChange = cpProject.get(index);
        if (!allowInvalidCP && cpProject.getDefaultOutputLocation().segmentCount() == 1 && !projectPath.equals(elementToChange.getPath())) {
            String outputFolderName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            cpProject.setDefaultOutputLocation(cpProject.getDefaultOutputLocation().append(outputFolderName));
            ClasspathModifier.removeFromClasspath(javaProject, cpProject.getCPListElements(), null);
            result = new StatusInfo(1, Messages.format(NewWizardMessages.OutputLocationDialog_removeProjectFromBP, BasicElementLabels.getPathLabel(cpProject.getDefaultOutputLocation(), false)));
        }
        ClasspathModifier.exclude(outputPath, cpProject.getCPListElements(), new ArrayList<CPListElement>(), cpProject.getJavaProject(), null);
        IPath oldOutputLocation = (IPath)elementToChange.getAttribute("output");
        if (oldOutputLocation != null && oldOutputLocation.segmentCount() > 1 && !oldOutputLocation.equals(cpProject.getDefaultOutputLocation())) {
            ClasspathModifier.include(cpProject, oldOutputLocation);
        }
        elementToChange.setAttribute("output", outputPath);
        IJavaModelStatus status = JavaConventions.validateClasspath(javaProject, cpProject.getClasspathEntries(), cpProject.getDefaultOutputLocation());
        if (!status.isOK()) {
            if (allowInvalidCP) {
                return new StatusInfo(2, status.getMessage());
            }
            return new StatusInfo(4, status.getMessage());
        }
        if (outputPath.segmentCount() - projectPath.segmentCount() < 1) {
            return result;
        }
        String lastSegment = outputPath.lastSegment();
        if (lastSegment == null) {
            return result;
        }
        if (lastSegment.equals(".settings") && outputPath.segmentCount() - projectPath.segmentCount() == 1) {
            StatusInfo statusInfo = new StatusInfo(2, NewWizardMessages.OutputLocation_SettingsAsLocation);
            if (result.isOK()) {
                return statusInfo;
            }
            MultiStatus ms = new MultiStatus(result.getPlugin(), result.getCode(), new IStatus[]{result, statusInfo}, statusInfo.getMessage(), null);
            return ms;
        }
        if (lastSegment.length() > 1 && lastSegment.charAt(0) == '.') {
            StatusInfo statusInfo = new StatusInfo(2, Messages.format(NewWizardMessages.OutputLocation_DotAsLocation, BasicElementLabels.getPathLabel(outputPath, false)));
            if (result.isOK()) {
                return statusInfo;
            }
            MultiStatus ms = new MultiStatus(result.getPlugin(), result.getCode(), new IStatus[]{result, statusInfo}, statusInfo.getMessage(), null);
            return ms;
        }
        return result;
    }

    public static IStatus checkAddExternalJarsPrecondition(IPath[] absolutePaths, CPJavaProject cpProject) {
        IStatus result = StatusInfo.OK_STATUS;
        IJavaProject javaProject = cpProject.getJavaProject();
        ArrayList<CPListElement> newEntries = new ArrayList<CPListElement>();
        ArrayList<CPListElement> duplicateEntries = new ArrayList<CPListElement>();
        List<CPListElement> existingEntries = cpProject.getCPListElements();
        int i = 0;
        while (i < absolutePaths.length) {
            CPListElement newEntry = new CPListElement(javaProject, 1, absolutePaths[i], null);
            if (existingEntries.contains(newEntry)) {
                duplicateEntries.add(newEntry);
            } else {
                newEntries.add(newEntry);
            }
            ++i;
        }
        if (duplicateEntries.size() > 0) {
            String message;
            if (duplicateEntries.size() > 1) {
                StringBuffer buf = new StringBuffer();
                for (CPListElement dup : duplicateEntries) {
                    buf.append('\n').append(BasicElementLabels.getResourceName(dup.getPath().lastSegment()));
                }
                message = Messages.format(NewWizardMessages.AddArchiveToBuildpathAction_DuplicateArchivesInfo_message, buf.toString());
            } else {
                message = Messages.format(NewWizardMessages.AddArchiveToBuildpathAction_DuplicateArchiveInfo_message, BasicElementLabels.getResourceName(((CPListElement)duplicateEntries.get(0)).getPath().lastSegment()));
            }
            result = new StatusInfo(1, message);
        }
        if (newEntries.size() == 0) {
            return result;
        }
        cpProject = cpProject.createWorkingCopy();
        existingEntries = cpProject.getCPListElements();
        for (CPListElement newEntry : newEntries) {
            ClasspathModifier.insertAtEndOfCategory(newEntry, existingEntries);
        }
        IJavaModelStatus cpStatus = JavaConventions.validateClasspath(javaProject, cpProject.getClasspathEntries(), cpProject.getDefaultOutputLocation());
        if (!cpStatus.isOK()) {
            return cpStatus;
        }
        return result;
    }

    public static BuildpathDelta addExternalJars(IPath[] absolutePaths, CPJavaProject cpProject) {
        BuildpathDelta result = new BuildpathDelta(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddJarCP_tooltip);
        IJavaProject javaProject = cpProject.getJavaProject();
        List<CPListElement> existingEntries = cpProject.getCPListElements();
        int i = 0;
        while (i < absolutePaths.length) {
            CPListElement newEntry = new CPListElement(javaProject, 1, absolutePaths[i], null);
            if (!existingEntries.contains(newEntry)) {
                ClasspathModifier.insertAtEndOfCategory(newEntry, existingEntries);
                result.addEntry(newEntry);
            }
            ++i;
        }
        result.setNewEntries(existingEntries.toArray(new CPListElement[existingEntries.size()]));
        result.setDefaultOutputLocation(cpProject.getDefaultOutputLocation());
        return result;
    }

    public static BuildpathDelta removeFromBuildpath(CPListElement[] toRemove, CPJavaProject cpProject) {
        IJavaProject javaProject = cpProject.getJavaProject();
        IPath projectPath = javaProject.getPath();
        IWorkspaceRoot workspaceRoot = javaProject.getProject().getWorkspace().getRoot();
        List<CPListElement> existingEntries = cpProject.getCPListElements();
        BuildpathDelta result = new BuildpathDelta(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip);
        int i = 0;
        while (i < toRemove.length) {
            CPListElement element = toRemove[i];
            existingEntries.remove(element);
            result.removeEntry(element);
            IPath path = element.getPath();
            ClasspathModifier.removeFilters(path, javaProject, existingEntries);
            if (!path.equals(projectPath)) {
                IResource member = workspaceRoot.findMember(path);
                if (member != null) {
                    result.addDeletedResource(member);
                }
            } else if (cpProject.getDefaultOutputLocation().equals(projectPath) && ClasspathModifier.containsSourceFolders(cpProject)) {
                String outputFolderName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
                cpProject.setDefaultOutputLocation(cpProject.getDefaultOutputLocation().append(outputFolderName));
            }
            ++i;
        }
        result.setDefaultOutputLocation(cpProject.getDefaultOutputLocation());
        result.setNewEntries(existingEntries.toArray(new CPListElement[existingEntries.size()]));
        return result;
    }

    private static boolean containsSourceFolders(CPJavaProject cpProject) {
        List<CPListElement> elements = cpProject.getCPListElements();
        for (CPListElement element : elements) {
            if (element.getEntryKind() != 3) continue;
            return true;
        }
        return false;
    }

    private static void include(CPJavaProject cpProject, IPath path) {
        List<CPListElement> elements = cpProject.getCPListElements();
        for (CPListElement element : elements) {
            element.removeFromExclusions(path);
        }
    }

    public static List<CPListElement> getExistingEntries(IJavaProject project) throws JavaModelException {
        IClasspathEntry[] classpathEntries = project.getRawClasspath();
        ArrayList<CPListElement> newClassPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < classpathEntries.length) {
            IClasspathEntry curr = classpathEntries[i];
            newClassPath.add(CPListElement.createFromExisting(curr, project));
            ++i;
        }
        return newClassPath;
    }

    public static CPListElement getClasspathEntry(List<CPListElement> elements, IPackageFragmentRoot root) throws JavaModelException {
        IClasspathEntry entry = root.getRawClasspathEntry();
        int i = 0;
        while (i < elements.size()) {
            CPListElement element = elements.get(i);
            if (element.getPath().equals(root.getPath()) && element.getEntryKind() == entry.getEntryKind()) {
                return elements.get(i);
            }
            ++i;
        }
        CPListElement newElement = CPListElement.createFromExisting(entry, root.getJavaProject());
        elements.add(newElement);
        return newElement;
    }

    public static IPackageFragment getFragment(IResource resource) {
        IJavaElement elem = JavaCore.create(resource);
        if (elem instanceof IPackageFragment) {
            return (IPackageFragment)elem;
        }
        return null;
    }

    public static IPackageFragmentRoot getFragmentRoot(IResource resource, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IJavaElement javaElem = null;
        if (resource.getFullPath().equals(project.getPath())) {
            return project.getPackageFragmentRoot(resource);
        }
        IContainer container = resource.getParent();
        do {
            if (container instanceof IFolder) {
                javaElem = JavaCore.create((IFolder)container);
            }
            if (container.getFullPath().equals(project.getPath())) {
                javaElem = project;
                break;
            }
            if ((container = container.getParent()) != null) continue;
            return null;
        } while (javaElem == null || !(javaElem instanceof IPackageFragmentRoot));
        if (javaElem instanceof IJavaProject) {
            if (!ClasspathModifier.isSourceFolder((IJavaProject)javaElem)) {
                return null;
            }
            javaElem = project.getPackageFragmentRoot(project.getResource());
        }
        return (IPackageFragmentRoot)javaElem;
    }

    public static IClasspathEntry getClasspathEntryFor(IPath path, IJavaProject project, int entryKind) throws JavaModelException {
        IClasspathEntry[] entries = project.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getPath().equals(path) && ClasspathModifier.equalEntryKind(entry, entryKind)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public static boolean isDefaultOutputFolder(CPListElementAttribute attrib) {
        return attrib.getValue() == null;
    }

    public static boolean isIncluded(IJavaElement selection, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ContainsPath, 4);
            IPackageFragmentRoot root = (IPackageFragmentRoot)selection.getAncestor(3);
            IClasspathEntry entry = root.getRawClasspathEntry();
            if (entry == null) {
                return false;
            }
            boolean bl = ClasspathModifier.contains(selection.getPath().removeFirstSegments(root.getPath().segmentCount()), entry.getInclusionPatterns(), new SubProgressMonitor(monitor, 2));
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean isExcluded(IResource resource, IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot root = ClasspathModifier.getFragmentRoot(resource, project, null);
        if (root == null) {
            return false;
        }
        String fragmentName = ClasspathModifier.getName(resource.getFullPath(), root.getPath());
        fragmentName = ClasspathModifier.completeName(fragmentName);
        IClasspathEntry entry = root.getRawClasspathEntry();
        return entry != null && ClasspathModifier.contains(new Path(fragmentName), entry.getExclusionPatterns(), null);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean parentExcluded(IResource resource, IJavaProject project) throws JavaModelException {
        if (resource.getFullPath().equals(project.getPath())) {
            return false;
        }
        root = ClasspathModifier.getFragmentRoot(resource, project, null);
        if (root == null) {
            return true;
        }
        path = resource.getFullPath().removeFirstSegments(root.getPath().segmentCount());
        entry = root.getRawClasspathEntry();
        if (entry != null) ** GOTO lbl13
        return true;
lbl-1000:
        // 1 sources

        {
            if (ClasspathModifier.contains(path, entry.getExclusionPatterns(), null)) {
                return true;
            }
            path = path.removeLastSegments(1);
lbl13:
            // 2 sources

            ** while (path.segmentCount() > 0)
        }
lbl14:
        // 1 sources

        return false;
    }

    public static boolean hasDefaultOutputFolder(IPackageFragmentRoot root) throws JavaModelException {
        return root.getRawClasspathEntry().getOutputLocation() == null;
    }

    public static boolean hasOutputFolders(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_CheckOutputFolders, roots.length);
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getRawClasspathEntry().getOutputLocation() != null) {
                    return true;
                }
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    public static String escapeSpecialChars(String value) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '\u00a0': {
                    buf.append(" ");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean isSourceFolder(IJavaProject project) throws JavaModelException {
        return ClasspathModifier.getClasspathEntryFor(project.getPath(), project, 3) != null;
    }

    public static boolean isDefaultFragment(IPackageFragment fragment) {
        return fragment.isDefaultPackage();
    }

    public static boolean includeFiltersEmpty(IResource resource, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ExamineInputFilters, 4);
            IPackageFragmentRoot root = ClasspathModifier.getFragmentRoot(resource, project, new SubProgressMonitor(monitor, 4));
            if (root != null) {
                IClasspathEntry entry = root.getRawClasspathEntry();
                boolean bl = entry.getInclusionPatterns().length == 0;
                return bl;
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean filtersSet(IPackageFragmentRoot root) throws JavaModelException {
        if (root == null) {
            return false;
        }
        IClasspathEntry entry = root.getRawClasspathEntry();
        IPath[] inclusions = entry.getInclusionPatterns();
        IPath[] exclusions = entry.getExclusionPatterns();
        if (inclusions != null && inclusions.length > 0) {
            return true;
        }
        return exclusions != null && exclusions.length > 0;
    }

    public static CPListElement addToClasspath(IResource resource, List<CPListElement> existingEntries, List<CPListElement> newEntries, IJavaProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CPListElement entry;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 2);
            ClasspathModifier.exclude(resource.getFullPath(), existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CPListElement cPListElement = entry = new CPListElement(project, 3, resource.getFullPath(), resource);
            return cPListElement;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean isArchive(IFile file, IJavaProject project) throws JavaModelException {
        if (!ArchiveFileFilter.isArchivePath(file.getFullPath(), true)) {
            return false;
        }
        return project != null && project.exists() && project.findPackageFragmentRoot(file.getFullPath()) == null;
    }

    public static CPListElement addToClasspath(IJavaElement javaElement, List<CPListElement> existingEntries, List<CPListElement> newEntries, IJavaProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CPListElement entry;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 10);
            CPListElement cPListElement = entry = new CPListElement(project, 3, javaElement.getPath(), javaElement.getResource());
            return cPListElement;
        }
        finally {
            monitor.done();
        }
    }

    public static IJavaProject removeFromClasspath(IJavaProject project, List<CPListElement> existingEntries, IProgressMonitor monitor) {
        CPListElement elem = ClasspathModifier.getListElement(project.getPath(), existingEntries);
        if (elem != null) {
            existingEntries.remove(elem);
        }
        return project;
    }

    public static List<CPListElement> removeFilters(IPath path, IJavaProject project, List<CPListElement> existingEntries) {
        if (path == null) {
            return Collections.emptyList();
        }
        IPath projPath = project.getPath();
        if (projPath.isPrefixOf(path)) {
            path = path.removeFirstSegments(projPath.segmentCount()).addTrailingSeparator();
        }
        ArrayList<CPListElement> result = new ArrayList<CPListElement>();
        for (CPListElement element : existingEntries) {
            IPath[] inclusion;
            boolean hasChange = false;
            IPath[] exlusions = (IPath[])element.getAttribute("exclusion");
            if (exlusions != null) {
                ArrayList<IPath> exlusionList = new ArrayList<IPath>(exlusions.length);
                int i = 0;
                while (i < exlusions.length) {
                    if (!exlusions[i].equals(path)) {
                        exlusionList.add(exlusions[i]);
                    } else {
                        hasChange = true;
                    }
                    ++i;
                }
                element.setAttribute("exclusion", exlusionList.toArray(new IPath[exlusionList.size()]));
            }
            if ((inclusion = (IPath[])element.getAttribute("inclusion")) != null) {
                ArrayList<IPath> inclusionList = new ArrayList<IPath>(inclusion.length);
                int i = 0;
                while (i < inclusion.length) {
                    if (!inclusion[i].equals(path)) {
                        inclusionList.add(inclusion[i]);
                    } else {
                        hasChange = true;
                    }
                    ++i;
                }
                element.setAttribute("inclusion", inclusionList.toArray(new IPath[inclusionList.size()]));
            }
            if (!hasChange) continue;
            result.add(element);
        }
        return result;
    }

    private static IResource exclude(String name, IPath fullPath, CPListElement entry, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        IResource result;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, 6);
            IPath[] excludedPath = (IPath[])entry.getAttribute("exclusion");
            IPath[] newExcludedPath = new IPath[excludedPath.length + 1];
            name = ClasspathModifier.completeName(name);
            Path path = new Path(name);
            if (!ClasspathModifier.contains(path, excludedPath, new SubProgressMonitor(monitor, 2))) {
                System.arraycopy(excludedPath, 0, newExcludedPath, 0, excludedPath.length);
                newExcludedPath[excludedPath.length] = path;
                entry.setAttribute("exclusion", newExcludedPath);
                entry.setAttribute("inclusion", ClasspathModifier.remove(path, (IPath[])entry.getAttribute("inclusion"), new SubProgressMonitor(monitor, 4)));
            }
            result = fullPath == null ? null : ClasspathModifier.getResource(fullPath, project);
        }
        finally {
            monitor.done();
        }
        return result;
    }

    public static void exclude(IPath path, List<CPListElement> existingEntries, List<CPListElement> newEntries, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IPath rootPath;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, 1);
            CPListElement elem = null;
            CPListElement existingElem = null;
            int i = 0;
            do {
                if ((rootPath = path.removeLastSegments(++i)).segmentCount() == 0) {
                    return;
                }
                elem = ClasspathModifier.getListElement(rootPath, newEntries);
            } while ((existingElem = ClasspathModifier.getListElement(rootPath, existingEntries)) == null && elem == null);
            if (elem == null) {
                elem = existingElem;
            }
            ClasspathModifier.exclude(path.removeFirstSegments(path.segmentCount() - i).toString(), null, elem, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    public static IResource exclude(IJavaElement javaElement, CPListElement entry, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            String name = ClasspathModifier.getName(javaElement.getPath(), entry.getPath());
            IResource iResource = ClasspathModifier.exclude(name, javaElement.getPath(), entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return iResource;
        }
        finally {
            monitor.done();
        }
    }

    public static void unExclude(IResource resource, CPListElement entry, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveExclusion, 10);
            String name = ClasspathModifier.getName(resource.getFullPath(), entry.getPath());
            IPath[] excludedPath = (IPath[])entry.getAttribute("exclusion");
            IPath[] newExcludedPath = ClasspathModifier.remove(new Path(ClasspathModifier.completeName(name)), excludedPath, new SubProgressMonitor(monitor, 3));
            entry.setAttribute("exclusion", newExcludedPath);
        }
        finally {
            monitor.done();
        }
    }

    public static void resetFilters(IJavaElement element, CPListElement entry, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ResetFilters, 3);
            List<Path> exclusionList = ClasspathModifier.getFoldersOnCP(element.getPath(), project, new SubProgressMonitor(monitor, 2));
            IPath outputLocation = (IPath)entry.getAttribute("output");
            if (outputLocation != null) {
                IPath[] exclusionPatterns = (IPath[])entry.getAttribute("exclusion");
                if (ClasspathModifier.contains(new Path(ClasspathModifier.completeName(outputLocation.lastSegment())), exclusionPatterns, null)) {
                    exclusionList.add(new Path(ClasspathModifier.completeName(outputLocation.lastSegment())));
                }
            }
            IPath[] exclusions = exclusionList.toArray(new IPath[exclusionList.size()]);
            entry.setAttribute("inclusion", new IPath[0]);
            entry.setAttribute("exclusion", exclusions);
        }
        finally {
            monitor.done();
        }
    }

    public static CPListElementAttribute resetOutputFolder(CPListElement entry, IJavaProject project) throws JavaModelException {
        entry.setAttribute("output", null);
        CPListElementAttribute outputFolder = new CPListElementAttribute(entry, "output", entry.getAttribute("output"), true);
        return outputFolder;
    }

    public static CPListElement getClasspathEntry(List<CPListElement> elements, CPListElement cpElement) {
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i).getPath().equals(cpElement.getPath())) {
                return elements.get(i);
            }
            ++i;
        }
        elements.add(cpElement);
        return cpElement;
    }

    public static CPListElement getListElement(IPath path, List<CPListElement> elements) {
        int i = 0;
        while (i < elements.size()) {
            CPListElement element = elements.get(i);
            if (element.getEntryKind() == 3 && element.getPath().equals(path)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static void commitClassPath(List<CPListElement> newEntries, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 2);
        try {
            IClasspathEntry[] entries = ClasspathModifier.convert(newEntries);
            IPath outputLocation = project.getOutputLocation();
            IJavaModelStatus status = JavaConventions.validateClasspath(project, entries, outputLocation);
            if (!status.isOK()) {
                throw new JavaModelException(status);
            }
            BuildPathSupport.setEEComplianceOptions(project, newEntries);
            project.setRawClasspath(entries, outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    public static void commitClassPath(CPJavaProject cpProject, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 2);
        try {
            List<CPListElement> cpListElements = cpProject.getCPListElements();
            IClasspathEntry[] entries = ClasspathModifier.convert(cpListElements);
            IPath outputLocation = cpProject.getDefaultOutputLocation();
            IJavaProject javaProject = cpProject.getJavaProject();
            IJavaModelStatus status = JavaConventions.validateClasspath(javaProject, entries, outputLocation);
            if (!status.isOK()) {
                throw new JavaModelException(status);
            }
            BuildPathSupport.setEEComplianceOptions(javaProject, cpListElements);
            javaProject.setRawClasspath(entries, outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    public static List<?> getCorrespondingElements(List<?> entries, IJavaProject project) {
        ArrayList<IAdaptable> result = new ArrayList<IAdaptable>();
        int i = 0;
        while (i < entries.size()) {
            Object element = entries.get(i);
            IPath path = element instanceof IResource ? ((IResource)element).getFullPath() : ((IJavaElement)element).getPath();
            IResource resource = ClasspathModifier.getResource(path, project);
            if (resource != null) {
                IJavaElement elem = JavaCore.create(resource);
                if (elem != null && project.isOnClasspath(elem)) {
                    result.add(elem);
                } else {
                    result.add(resource);
                }
            }
            ++i;
        }
        return result;
    }

    private static IResource getResource(IPath path, IJavaProject project) {
        return project.getProject().getWorkspace().getRoot().findMember(path);
    }

    private static boolean contains(IPath path, IPath[] paths, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (path == null) {
            return false;
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ComparePaths, paths.length);
            if (path.getFileExtension() == null) {
                path = new Path(ClasspathModifier.completeName(path.toString()));
            }
            int i = 0;
            while (i < paths.length) {
                if (paths[i].equals(path)) {
                    return true;
                }
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    private static String completeName(String name) {
        if (!JavaCore.isJavaLikeFileName(name)) {
            name = String.valueOf(name) + "/";
            name = name.replace('.', '/');
            return name;
        }
        return name;
    }

    private static IPath[] remove(IPath path, IPath[] paths, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemovePath, paths.length + 5);
            if (!ClasspathModifier.contains(path, paths, new SubProgressMonitor(monitor, 5))) {
                IPath[] iPathArray = paths;
                return iPathArray;
            }
            ArrayList<IPath> newPaths = new ArrayList<IPath>();
            int i = 0;
            while (i < paths.length) {
                monitor.worked(1);
                if (!paths[i].equals(path)) {
                    newPaths.add(paths[i]);
                }
                ++i;
            }
            IPath[] iPathArray = newPaths.toArray(new IPath[newPaths.size()]);
            return iPathArray;
        }
        finally {
            monitor.done();
        }
    }

    private static List<Path> getFoldersOnCP(IPath path, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<Path> srcFolders = new ArrayList<Path>();
        IClasspathEntry[] cpEntries = project.getRawClasspath();
        int i = 0;
        while (i < cpEntries.length) {
            IPath cpPath = cpEntries[i].getPath();
            if (path.isPrefixOf(cpPath) && path.segmentCount() + 1 == cpPath.segmentCount()) {
                srcFolders.add(new Path(ClasspathModifier.completeName(cpPath.lastSegment())));
            }
            ++i;
        }
        return srcFolders;
    }

    private static String getName(IPath path, IPath rootPath) {
        return path.removeFirstSegments(rootPath.segmentCount()).toString();
    }

    public static void setNewEntry(List<CPListElement> existingEntries, List<CPListElement> newEntries, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_SetNewEntry, existingEntries.size());
            int i = 0;
            while (i < newEntries.size()) {
                CPListElement entry = newEntries.get(i);
                ClasspathModifier.validateAndAddEntry(entry, existingEntries, project);
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IClasspathEntry[] convert(List<CPListElement> list) {
        IClasspathEntry[] entries = new IClasspathEntry[list.size()];
        int i = 0;
        while (i < list.size()) {
            CPListElement element = list.get(i);
            entries[i] = element.getClasspathEntry();
            ++i;
        }
        return entries;
    }

    private static void validateAndAddEntry(CPListElement entry, List<CPListElement> existingEntries, IJavaProject project) throws CoreException {
        IPath path = entry.getPath();
        IPath projPath = project.getProject().getFullPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IStatus validate = workspaceRoot.getWorkspace().validatePath(path.toString(), 2);
        StatusInfo rootStatus = new StatusInfo();
        rootStatus.setOK();
        boolean isExternal = ClasspathModifier.isExternalArchiveOrLibrary(entry);
        if (!isExternal && validate.matches(4) && !project.getPath().equals(path)) {
            rootStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, validate.getMessage()));
            throw new CoreException(rootStatus);
        }
        if (!isExternal && !project.getPath().equals(path)) {
            IResource res = workspaceRoot.findMember(path);
            if (res != null) {
                if (res.getType() != 2 && res.getType() != 1) {
                    rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                    throw new CoreException(rootStatus);
                }
            } else {
                IFileStore store;
                URI projLocation = project.getProject().getLocationURI();
                if (projLocation != null && (store = EFS.getStore((URI)projLocation).getFileStore(path)).fetchInfo().exists()) {
                    rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                    throw new CoreException(rootStatus);
                }
            }
        }
        int i = 0;
        while (i < existingEntries.size()) {
            CPListElement curr = existingEntries.get(i);
            if (curr.getEntryKind() == 3 && path.equals(curr.getPath()) && !project.getPath().equals(path)) {
                rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                throw new CoreException(rootStatus);
            }
            ++i;
        }
        if (!isExternal && !entry.getPath().equals(project.getPath())) {
            ClasspathModifier.exclude(entry.getPath(), existingEntries, new ArrayList<CPListElement>(), project, null);
        }
        IPath outputLocation = project.getOutputLocation();
        ClasspathModifier.insertAtEndOfCategory(entry, existingEntries);
        IClasspathEntry[] entries = ClasspathModifier.convert(existingEntries);
        IJavaModelStatus status = JavaConventions.validateClasspath(project, entries, outputLocation);
        if (!status.isOK()) {
            IJavaModelStatus status2;
            if (outputLocation.equals(projPath) && (status2 = JavaConventions.validateClasspath(project, entries, outputLocation)).isOK()) {
                if (project.isOnClasspath(project)) {
                    rootStatus.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSFandOL, BasicElementLabels.getPathLabel(outputLocation, false)));
                } else {
                    rootStatus.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceOL, BasicElementLabels.getPathLabel(outputLocation, false)));
                }
                return;
            }
            rootStatus.setError(status.getMessage());
            throw new CoreException(rootStatus);
        }
        if (ClasspathModifier.isSourceFolder(project) || project.getPath().equals(path)) {
            rootStatus.setWarning(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSF);
            return;
        }
        rootStatus.setOK();
    }

    private static void insertAtEndOfCategory(CPListElement entry, List<CPListElement> existingEntries) {
        int length = existingEntries.size();
        CPListElement[] elements = existingEntries.toArray(new CPListElement[length]);
        int i = 0;
        while (i < length && elements[i].getClasspathEntry().getEntryKind() != entry.getClasspathEntry().getEntryKind()) {
            ++i;
        }
        if (i < length) {
            ++i;
            while (i < length && elements[i].getClasspathEntry().getEntryKind() == entry.getClasspathEntry().getEntryKind()) {
                ++i;
            }
            existingEntries.add(i, entry);
            return;
        }
        switch (entry.getClasspathEntry().getEntryKind()) {
            case 3: {
                existingEntries.add(0, entry);
                break;
            }
            default: {
                existingEntries.add(entry);
            }
        }
    }

    private static boolean isExternalArchiveOrLibrary(CPListElement entry) {
        if (entry.getEntryKind() == 1 || entry.getEntryKind() == 5) {
            return !(entry.getResource() instanceof IFolder);
        }
        return false;
    }

    public static boolean isInExternalOrArchive(IJavaElement element) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
        return root != null && (root.isArchive() || root.isExternal());
    }

    private static boolean equalEntryKind(IClasspathEntry entry, int kind) {
        return entry.getEntryKind() == kind;
    }

    public static ClasspathModifierQueries.OutputFolderValidator getValidator(final List<?> newElements, IJavaProject project) throws JavaModelException {
        return new ClasspathModifierQueries.OutputFolderValidator(newElements, project){

            public boolean validate(IPath outputLocation) {
                int i = 0;
                while (i < newElements.size()) {
                    if (this.isInvalid(newElements.get(i), outputLocation)) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.fEntries.length) {
                    if (this.isInvalid(this.fEntries[i], outputLocation)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            private boolean isInvalid(Object object, IPath outputLocation) {
                IPath path = null;
                if (object instanceof IFolder) {
                    path = this.getFolderPath(object);
                } else if (object instanceof IJavaElement) {
                    path = this.getJavaElementPath(object);
                } else if (object instanceof IClasspathEntry) {
                    path = this.getCPEntryPath(object);
                }
                return this.isSubFolderOf(path, outputLocation);
            }

            private IPath getFolderPath(Object element) {
                return ((IFolder)element).getFullPath();
            }

            private IPath getJavaElementPath(Object element) {
                return ((IJavaElement)element).getPath();
            }

            private IPath getCPEntryPath(Object entry) {
                return ((IClasspathEntry)entry).getPath();
            }

            private boolean isSubFolderOf(IPath path1, IPath path2) {
                if (path1 == null || path2 == null) {
                    return path1 == null && path2 == null;
                }
                return path2.matchingFirstSegments(path1) == path2.segmentCount();
            }
        };
    }
}

