/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.corext.callhierarchy.CallSearchResultCollector;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodReferencesSearchRequestor;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallerMethodWrapper
extends MethodWrapper {
    private boolean fExpandWithConstructors;
    private boolean fIsExpandWithConstructorsSet;

    public CallerMethodWrapper(MethodWrapper parent, MethodCall methodCall) {
        super(parent, methodCall);
    }

    protected IJavaSearchScope getSearchScope() {
        return CallHierarchy.getDefault().getSearchScope();
    }

    @Override
    protected String getTaskName() {
        return CallHierarchyMessages.CallerMethodWrapper_taskname;
    }

    @Override
    public MethodWrapper createMethodWrapper(MethodCall methodCall) {
        return new CallerMethodWrapper(this, methodCall);
    }

    @Override
    public boolean canHaveChildren() {
        IMember member = this.getMember();
        if (member instanceof IField) {
            if (this.getLevel() == 1) {
                return true;
            }
            int mode = this.getFieldSearchMode();
            return mode == 2 || mode == 4;
        }
        return member instanceof IMethod || member instanceof IType;
    }

    @Override
    protected Map<String, MethodCall> findChildren(IProgressMonitor progressMonitor) {
        try {
            SubProgressMonitor monitor = new SubProgressMonitor(progressMonitor, 95, 2);
            this.checkCanceled(progressMonitor);
            IMember member = this.getMember();
            SearchPattern pattern = null;
            IType type = null;
            if (member instanceof IType) {
                type = (IType)member;
            } else if (member instanceof IInitializer && !Flags.isStatic(member.getFlags())) {
                type = (IType)member.getParent();
            }
            if (type != null) {
                if (type.isAnonymous()) {
                    CallSearchResultCollector resultCollector = new CallSearchResultCollector();
                    IJavaElement parent = type.getParent();
                    if (parent instanceof IMember) {
                        IMember parentMember = (IMember)parent;
                        ISourceRange nameRange = type.getNameRange();
                        int start = nameRange != null ? nameRange.getOffset() : -1;
                        int len = nameRange != null ? nameRange.getLength() : 0;
                        resultCollector.addMember(type, parentMember, start, start + len);
                        return resultCollector.getCallers();
                    }
                } else {
                    pattern = type.getParent() instanceof IMethod ? SearchPattern.createPattern(type, 8192, 24) : SearchPattern.createPattern(type.getFullyQualifiedName('.'), 3, 2, 24);
                }
            }
            if (pattern == null) {
                int limitTo = 2;
                if (member.getElementType() == 8) {
                    limitTo = this.getFieldSearchMode();
                }
                pattern = SearchPattern.createPattern(member, limitTo, 24);
            }
            if (pattern == null) {
                return new HashMap<String, MethodCall>(0);
            }
            SearchEngine searchEngine = new SearchEngine();
            MethodReferencesSearchRequestor searchRequestor = new MethodReferencesSearchRequestor();
            IJavaSearchScope defaultSearchScope = this.getSearchScope();
            boolean isWorkspaceScope = SearchEngine.createWorkspaceScope().equals(defaultSearchScope);
            IJavaSearchScope searchScope = isWorkspaceScope ? this.getAccurateSearchScope(defaultSearchScope, member) : defaultSearchScope;
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, searchRequestor, monitor);
            return searchRequestor.getCallers();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return new HashMap<String, MethodCall>(0);
        }
    }

    private IJavaSearchScope getAccurateSearchScope(IJavaSearchScope defaultSearchScope, IMember member) throws JavaModelException {
        if (!JdtFlags.isPrivate(member)) {
            return defaultSearchScope;
        }
        if (member.getCompilationUnit() != null) {
            return SearchEngine.createJavaSearchScope(new IJavaElement[]{member.getCompilationUnit()});
        }
        if (member.getClassFile() != null) {
            return SearchEngine.createJavaSearchScope(new IJavaElement[]{member.getAncestor(4)});
        }
        return defaultSearchScope;
    }

    public boolean getExpandWithConstructors() {
        return this.fIsExpandWithConstructorsSet && this.fExpandWithConstructors;
    }

    public void setExpandWithConstructors(boolean value) {
        this.fExpandWithConstructors = value;
        this.fIsExpandWithConstructorsSet = true;
    }

    public boolean isExpandWithConstructorsSet() {
        return this.fIsExpandWithConstructorsSet;
    }
}

