/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.AbstractToStringGenerator;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.CustomBuilderGenerator;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.StringBuilderChainGenerator;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.StringBuilderGenerator;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.StringConcatenationGenerator;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.StringFormatGenerator;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.ToStringGenerationContext;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.ToStringGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.ToStringTemplateParser;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateToStringOperation
implements IWorkspaceRunnable {
    private IJavaElement fInsert;
    private CompilationUnitRewrite fRewrite;
    private ToStringGenerationContext fContext;
    private AbstractToStringGenerator fGenerator;
    private CompilationUnit fUnit;
    public static final int STRING_CONCATENATION = 0;
    public static final int STRING_BUILDER = 1;
    public static final int STRING_BUILDER_CHAINED = 2;
    public static final int STRING_FORMAT = 3;
    public static final int CUSTOM_BUILDER = 4;
    private static final String[] hardcoded_styles = new String[]{CodeGenerationMessages.GenerateToStringOperation_stringConcatenation_style_name, CodeGenerationMessages.GenerateToStringOperation_stringBuilder_style_name, CodeGenerationMessages.GenerateToStringOperation_StringBuilder_chained_style_name, CodeGenerationMessages.GenerateToStringOperation_string_format_style_name, CodeGenerationMessages.GenerateToStringOperation_customStringBuilder_style_name};

    private GenerateToStringOperation(IJavaElement insert, ToStringGenerationContext context, AbstractToStringGenerator generator, CompilationUnit unit, CompilationUnitRewrite rewrite) {
        this.fInsert = insert;
        this.fContext = context;
        this.fRewrite = rewrite;
        this.fUnit = unit;
        this.fGenerator = generator;
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(CodeGenerationMessages.GenerateToStringOperation_description);
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.findDeclaration(this.fContext.getTypeBinding(), this.fRewrite.getRoot());
            ListRewrite rewriter = this.fRewrite.getASTRewrite().getListRewrite(declaration, declaration.getBodyDeclarationsProperty());
            if (this.fContext.getTypeBinding() != null && rewriter != null) {
                MethodDeclaration toStringMethod = this.fGenerator.generateToStringMethod();
                List list = (List)declaration.getStructuralProperty(declaration.getBodyDeclarationsProperty());
                BodyDeclaration replace = this.findMethodToReplace(list, toStringMethod);
                if (replace == null || ((Boolean)toStringMethod.getProperty("override_method")).booleanValue()) {
                    this.insertMethod(toStringMethod, rewriter, replace);
                }
                List<MethodDeclaration> helperMethods = this.fGenerator.generateHelperMethods();
                for (MethodDeclaration method : helperMethods) {
                    replace = this.findMethodToReplace(list, method);
                    if (replace != null && !((Boolean)method.getProperty("override_method")).booleanValue()) continue;
                    this.insertMethod(method, rewriter, replace);
                }
                JavaModelUtil.applyEdit((ICompilationUnit)this.fUnit.getJavaElement(), this.fRewrite.createChange(true).getEdit(), false, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    public RefactoringStatus checkConditions() {
        return this.fGenerator.checkConditions();
    }

    protected void insertMethod(MethodDeclaration method, ListRewrite rewriter, BodyDeclaration replace) throws JavaModelException {
        if (replace != null) {
            rewriter.replace(replace, method, null);
        } else {
            ASTNode insertion = StubUtility2.getNodeToInsertBefore(rewriter, this.fInsert);
            if (insertion != null) {
                rewriter.insertBefore(method, insertion, null);
            } else {
                rewriter.insertLast(method, null);
            }
        }
    }

    protected BodyDeclaration findMethodToReplace(List<BodyDeclaration> list, MethodDeclaration method) {
        for (BodyDeclaration bodyDecl : list) {
            MethodDeclaration method2;
            if (!(bodyDecl instanceof MethodDeclaration) || !(method2 = (MethodDeclaration)bodyDecl).getName().getIdentifier().equals(method.getName().getIdentifier()) || method2.parameters().size() != method.parameters().size()) continue;
            Iterator iterator1 = method.parameters().iterator();
            Iterator iterator2 = method2.parameters().iterator();
            boolean ok = true;
            while (iterator1.hasNext()) {
                if (((SingleVariableDeclaration)iterator1.next()).getType().subtreeMatch(new ASTMatcher(), ((SingleVariableDeclaration)iterator2.next()).getType())) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return method2;
        }
        return null;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static String[] getStyleNames() {
        return hardcoded_styles;
    }

    private static AbstractToStringGenerator createToStringGenerator(int toStringStyle) {
        switch (toStringStyle) {
            case 0: {
                return new StringConcatenationGenerator();
            }
            case 1: {
                return new StringBuilderGenerator();
            }
            case 2: {
                return new StringBuilderChainGenerator();
            }
            case 3: {
                return new StringFormatGenerator();
            }
            case 4: {
                return new CustomBuilderGenerator();
            }
        }
        throw new IllegalArgumentException("Undefined toString() code style: " + toStringStyle);
    }

    public static ToStringTemplateParser createTemplateParser(int toStringStyle) {
        return new ToStringTemplateParser();
    }

    public static GenerateToStringOperation createOperation(ITypeBinding typeBinding, Object[] selectedBindings, CompilationUnit unit, IJavaElement elementPosition, ToStringGenerationSettings settings) {
        AbstractToStringGenerator generator = GenerateToStringOperation.createToStringGenerator(settings.toStringStyle);
        ToStringTemplateParser parser = GenerateToStringOperation.createTemplateParser(settings.toStringStyle);
        parser.parseTemplate(settings.stringFormatTemplate);
        CompilationUnitRewrite rewrite = new CompilationUnitRewrite((ICompilationUnit)unit.getTypeRoot(), unit);
        ToStringGenerationContext context = new ToStringGenerationContext(parser, selectedBindings, settings, typeBinding, rewrite);
        generator.setContext(context);
        return new GenerateToStringOperation(elementPosition, context, generator, unit, rewrite);
    }
}

