/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.StringBuilderGenerator;

public class StringBuilderChainGenerator
extends StringBuilderGenerator {
    protected Block temporaryBlock = null;
    protected Expression temporaryExpression = null;

    protected void appendExpression(Expression expression) {
        MethodInvocation appendInvocation = this.fAst.newMethodInvocation();
        if (this.temporaryExpression != null) {
            appendInvocation.setExpression(this.temporaryExpression);
        } else {
            appendInvocation.setExpression(this.fAst.newSimpleName(this.fBuilderVariableName));
        }
        appendInvocation.setName(this.fAst.newSimpleName("append"));
        appendInvocation.arguments().add(expression);
        this.temporaryExpression = appendInvocation;
    }

    protected void flushBuffer() {
        if (this.fBuffer.length() > 0) {
            if (this.temporaryBlock == null) {
                this.temporaryBlock = this.toStringMethod.getBody();
            }
            StringLiteral literal = this.fAst.newStringLiteral();
            literal.setLiteralValue(this.fBuffer.toString());
            this.appendExpression(literal);
            this.fBuffer.setLength(0);
        }
    }

    protected void flushTemporaryExpression() {
        this.flushBuffer();
        if (this.temporaryBlock != null && this.temporaryExpression != null) {
            this.temporaryBlock.statements().add(this.fAst.newExpressionStatement(this.temporaryExpression));
            this.temporaryExpression = null;
        }
    }

    protected void addElement(Object element, Block block) {
        if (block != this.temporaryBlock) {
            this.flushTemporaryExpression();
            this.temporaryBlock = block;
        }
        if (element instanceof String) {
            this.fBuffer.append((String)element);
        }
        if (element instanceof Expression) {
            this.flushBuffer();
            this.appendExpression((Expression)element);
        }
    }

    protected void addMemberCheckNull(Object member, boolean addSeparator) {
        IfStatement ifStatement = this.fAst.newIfStatement();
        ifStatement.setExpression(this.createInfixExpression(this.createMemberAccessExpression(member, true, true), InfixExpression.Operator.NOT_EQUALS, this.fAst.newNullLiteral()));
        Block thenBlock = this.fAst.newBlock();
        this.flushTemporaryExpression();
        String[] arrayString = this.getContext().getTemplateParser().getBody();
        int i = 0;
        while (i < arrayString.length) {
            this.addElement(this.processElement(arrayString[i], member), thenBlock);
            ++i;
        }
        if (addSeparator) {
            this.addElement(this.getContext().getTemplateParser().getSeparator(), thenBlock);
        }
        this.flushTemporaryExpression();
        if (thenBlock.statements().size() == 1 && !this.getContext().isForceBlocks()) {
            ifStatement.setThenStatement((Statement)ASTNode.copySubtree(this.fAst, (ASTNode)thenBlock.statements().get(0)));
        } else {
            ifStatement.setThenStatement(thenBlock);
        }
        this.toStringMethod.getBody().statements().add(ifStatement);
    }

    protected void complete() throws CoreException {
        this.flushTemporaryExpression();
        super.complete();
    }
}

