/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.AbstractToStringGenerator;

public class StringBuilderGenerator
extends AbstractToStringGenerator {
    protected StringBuffer fBuffer;
    protected String fBuilderVariableName;
    protected final String APPEND_METHOD_NAME = "append";

    protected void flushBuffer(Block target) {
        if (this.fBuffer.length() > 0) {
            StringLiteral literal = this.fAst.newStringLiteral();
            literal.setLiteralValue(this.fBuffer.toString());
            if (target == null) {
                target = this.toStringMethod.getBody();
            }
            target.statements().add(this.fAst.newExpressionStatement(this.createMethodInvocation(this.fBuilderVariableName, "append", (Expression)literal)));
            this.fBuffer.setLength(0);
        }
    }

    protected void initialize() {
        super.initialize();
        this.fBuilderVariableName = this.createNameSuggestion(this.getContext().is50orHigher() ? "builder" : "buffer", 5);
        this.fBuffer = new StringBuffer();
        VariableDeclarationFragment fragment = this.fAst.newVariableDeclarationFragment();
        fragment.setName(this.fAst.newSimpleName(this.fBuilderVariableName));
        ClassInstanceCreation classInstance = this.fAst.newClassInstanceCreation();
        Name typeName = this.addImport(this.getContext().is50orHigher() ? "java.lang.StringBuilder" : "java.lang.StringBuffer");
        classInstance.setType(this.fAst.newSimpleType(typeName));
        fragment.setInitializer(classInstance);
        VariableDeclarationStatement vStatement = this.fAst.newVariableDeclarationStatement(fragment);
        vStatement.setType(this.fAst.newSimpleType((Name)ASTNode.copySubtree(this.fAst, typeName)));
        this.toStringMethod.getBody().statements().add(vStatement);
    }

    protected void complete() throws CoreException {
        this.flushBuffer(null);
        super.complete();
        ReturnStatement rStatement = this.fAst.newReturnStatement();
        rStatement.setExpression(this.createMethodInvocation(this.fBuilderVariableName, "toString", null));
        this.toStringMethod.getBody().statements().add(rStatement);
    }

    protected void addElement(Object element, Block block) {
        if (element instanceof String) {
            this.fBuffer.append((String)element);
        }
        if (element instanceof Expression) {
            this.flushBuffer(block);
            block.statements().add(this.fAst.newExpressionStatement(this.createMethodInvocation(this.fBuilderVariableName, "append", (Expression)element)));
        }
    }

    protected void addMemberCheckNull(Object member, boolean addSeparator) {
        IfStatement ifStatement = this.fAst.newIfStatement();
        ifStatement.setExpression(this.createInfixExpression(this.createMemberAccessExpression(member, true, true), InfixExpression.Operator.NOT_EQUALS, this.fAst.newNullLiteral()));
        Block thenBlock = this.fAst.newBlock();
        this.flushBuffer(null);
        String[] arrayString = this.getContext().getTemplateParser().getBody();
        int i = 0;
        while (i < arrayString.length) {
            this.addElement(this.processElement(arrayString[i], member), thenBlock);
            ++i;
        }
        if (addSeparator) {
            this.addElement(this.getContext().getTemplateParser().getSeparator(), thenBlock);
        }
        this.flushBuffer(thenBlock);
        if (thenBlock.statements().size() == 1 && !this.getContext().isForceBlocks()) {
            ifStatement.setThenStatement((Statement)ASTNode.copySubtree(this.fAst, (ASTNode)thenBlock.statements().get(0)));
        } else {
            ifStatement.setThenStatement(thenBlock);
        }
        this.toStringMethod.getBody().statements().add(ifStatement);
    }

    protected void addElement(Object element) {
        this.addElement(element, this.toStringMethod.getBody());
    }
}

