/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;

public class ASTBatchParser {
    private static final int MAX_AT_ONCE;

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        int ratio = (int)Math.round((double)maxMemory / 6.7108864E7);
        switch (ratio) {
            case 0: {
                MAX_AT_ONCE = 25;
                break;
            }
            case 1: {
                MAX_AT_ONCE = 100;
                break;
            }
            case 2: {
                MAX_AT_ONCE = 200;
                break;
            }
            case 3: {
                MAX_AT_ONCE = 300;
                break;
            }
            case 4: {
                MAX_AT_ONCE = 400;
                break;
            }
            default: {
                MAX_AT_ONCE = 500;
            }
        }
    }

    public final void createASTs(ICompilationUnit[] compilationUnits, String[] bindingKeys, ASTRequestor requestor, IProgressMonitor monitor) {
        if (compilationUnits.length == 0) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", compilationUnits.length);
        try {
            ICompilationUnit[][] splited = ASTBatchParser.splitByProject(compilationUnits);
            int i = 0;
            while (i < splited.length) {
                ICompilationUnit[] units = splited[i];
                if (units.length <= MAX_AT_ONCE) {
                    this.createParser(units[0].getJavaProject()).createASTs(units, bindingKeys, requestor, new SubProgressMonitor(monitor, units.length));
                } else {
                    List<ICompilationUnit> list = Arrays.asList(units);
                    int end = 0;
                    int cursor = 0;
                    while (cursor < units.length) {
                        end = Math.min(end + MAX_AT_ONCE, units.length);
                        List<ICompilationUnit> toParse = list.subList(cursor, end);
                        this.createParser(units[0].getJavaProject()).createASTs(toParse.toArray(new ICompilationUnit[toParse.size()]), bindingKeys, requestor, new SubProgressMonitor(monitor, toParse.size()));
                        cursor = end;
                    }
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected ASTParser createParser(IJavaProject project) {
        ASTParser result = ASTParser.newParser(4);
        result.setResolveBindings(true);
        result.setProject(project);
        return result;
    }

    private static ICompilationUnit[][] splitByProject(ICompilationUnit[] units) {
        if (ASTBatchParser.hasOnlyOneProject(units)) {
            return new ICompilationUnit[][]{units};
        }
        Hashtable<IJavaProject, ArrayList<ICompilationUnit>> projectTable = new Hashtable<IJavaProject, ArrayList<ICompilationUnit>>();
        int i = 0;
        while (i < units.length) {
            ICompilationUnit unit = units[i];
            ArrayList<ICompilationUnit> list = (ArrayList<ICompilationUnit>)projectTable.get(unit.getJavaProject());
            if (list == null) {
                list = new ArrayList<ICompilationUnit>();
                projectTable.put(unit.getJavaProject(), list);
            }
            list.add(unit);
            ++i;
        }
        Collection values = projectTable.values();
        ICompilationUnit[][] result = new ICompilationUnit[values.size()][];
        int i2 = 0;
        for (ArrayList cus : values) {
            result[i2] = cus.toArray(new ICompilationUnit[cus.size()]);
            ++i2;
        }
        return result;
    }

    private static boolean hasOnlyOneProject(ICompilationUnit[] units) {
        IJavaProject javaProject = units[0].getJavaProject();
        int i = 1;
        while (i < units.length) {
            if (!javaProject.equals(units[i].getJavaProject())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

