/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeScopeBuilder
extends ASTVisitor {
    private IBinding fIgnoreBinding;
    private Selection fIgnoreRange;
    private Scope fScope;
    private List<Scope> fScopes;

    public static Scope perform(BodyDeclaration node, IBinding ignore) {
        CodeScopeBuilder collector = new CodeScopeBuilder((ASTNode)node, ignore);
        node.accept(collector);
        return collector.fScope;
    }

    public static Scope perform(BodyDeclaration node, Selection ignore) {
        CodeScopeBuilder collector = new CodeScopeBuilder((ASTNode)node, ignore);
        node.accept(collector);
        return collector.fScope;
    }

    private CodeScopeBuilder(ASTNode node, IBinding ignore) {
        this.fScope = new Scope(null, node.getStartPosition(), node.getLength());
        this.fScopes = new ArrayList<Scope>();
        this.fIgnoreBinding = ignore;
    }

    private CodeScopeBuilder(ASTNode node, Selection ignore) {
        this.fScope = new Scope(null, node.getStartPosition(), node.getLength());
        this.fScopes = new ArrayList<Scope>();
        this.fIgnoreRange = ignore;
    }

    @Override
    public boolean visit(CatchClause node) {
        this.fScopes.add(this.fScope);
        this.fScope = new Scope(this.fScope, node.getStartPosition(), node.getLength());
        return true;
    }

    @Override
    public void endVisit(CatchClause node) {
        this.fScope = this.fScopes.remove(this.fScopes.size() - 1);
    }

    @Override
    public boolean visit(SimpleName node) {
        if (this.fIgnoreBinding != null && Bindings.equals(this.fIgnoreBinding, node.resolveBinding())) {
            return false;
        }
        if (this.fIgnoreRange != null && this.fIgnoreRange.covers(node)) {
            return false;
        }
        this.fScope.addName(node.getIdentifier());
        return false;
    }

    @Override
    public boolean visit(QualifiedName node) {
        node.getQualifier().accept(this);
        return false;
    }

    @Override
    public boolean visit(MethodInvocation node) {
        Expression receiver = node.getExpression();
        if (receiver == null) {
            SimpleName name = node.getName();
            if (this.fIgnoreBinding == null || !Bindings.equals(this.fIgnoreBinding, name.resolveBinding())) {
                node.getName().accept(this);
            }
        } else {
            receiver.accept(this);
        }
        this.accept(node.arguments());
        return false;
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        this.fScope.addName(node.getDeclaration().getName().getIdentifier());
        return false;
    }

    @Override
    public boolean visit(Block node) {
        this.fScopes.add(this.fScope);
        this.fScope = new Scope(this.fScope, node.getStartPosition(), node.getLength());
        return true;
    }

    @Override
    public void endVisit(Block node) {
        this.fScope = this.fScopes.remove(this.fScopes.size() - 1);
    }

    @Override
    public boolean visit(ForStatement node) {
        this.fScopes.add(this.fScope);
        this.fScope = new Scope(this.fScope, node.getStartPosition(), node.getLength());
        return true;
    }

    @Override
    public void endVisit(ForStatement node) {
        this.fScope = this.fScopes.remove(this.fScopes.size() - 1);
    }

    private void accept(List<Expression> list) {
        int size;
        if (list == null || (size = list.size()) == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            list.get(i).accept(this);
            ++i;
        }
    }

    public static class Scope {
        private Scope fParent;
        private int fStart;
        private int fLength;
        private List<String> fNames;
        private List<Scope> fChildren;
        private int fCursorOffset;

        Scope(Scope parent, int start, int length) {
            this.fParent = parent;
            this.fStart = start;
            this.fLength = length;
            if (this.fParent != null) {
                this.fParent.addChild(this);
            }
        }

        public void setCursor(int offset) {
            this.fCursorOffset = offset;
        }

        private void addChild(Scope child) {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList<Scope>(2);
            }
            this.fChildren.add(child);
        }

        private void addName(String name) {
            if (this.fNames == null) {
                this.fNames = new ArrayList<String>(2);
            }
            this.fNames.add(name);
        }

        public Scope findScope(int start, int length) {
            if (this.fStart <= start && start + length <= this.fStart + this.fLength) {
                if (this.fChildren == null) {
                    return this;
                }
                Iterator<Scope> iter = this.fChildren.iterator();
                while (iter.hasNext()) {
                    Scope scope = iter.next().findScope(start, length);
                    if (scope == null) continue;
                    return scope;
                }
                return this;
            }
            return null;
        }

        public String createName(String candidate, boolean add) {
            int i = 1;
            String result = candidate;
            while (this.isInUse(result)) {
                result = String.valueOf(candidate) + i++;
            }
            if (add) {
                this.addName(result);
            }
            return result;
        }

        public boolean isInUse(String name) {
            if (this.internalIsInUse(name)) {
                return true;
            }
            if (this.fChildren != null) {
                for (Scope child : this.fChildren) {
                    if (this.fCursorOffset >= child.fStart || !child.isInUseDown(name)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean internalIsInUse(String name) {
            if (this.fNames != null && this.fNames.contains(name)) {
                return true;
            }
            if (this.fParent != null) {
                return this.fParent.internalIsInUse(name);
            }
            return false;
        }

        private boolean isInUseDown(String name) {
            if (this.fNames != null && this.fNames.contains(name)) {
                return true;
            }
            if (this.fChildren == null) {
                return false;
            }
            for (Scope scope : this.fChildren) {
                if (!scope.isInUseDown(name)) continue;
                return true;
            }
            return false;
        }
    }
}

