/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.refactoring.code.OperatorPrecedence;

public class NecessaryParenthesesChecker {
    private static Expression getExpression(ParenthesizedExpression node) {
        Expression expression = node.getExpression();
        while (expression instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        return expression;
    }

    private static boolean expressionTypeNeedsParentheses(Expression expression) {
        int type = expression.getNodeType();
        return type == 27 || type == 16 || type == 38 || type == 37 || type == 11 || type == 62 || type == 3 || type == 7;
    }

    private static boolean locationNeedsParentheses(StructuralPropertyDescriptor locationInParent) {
        if (locationInParent instanceof ChildListPropertyDescriptor && locationInParent != InfixExpression.EXTENDED_OPERANDS_PROPERTY) {
            return false;
        }
        return locationInParent != VariableDeclarationFragment.INITIALIZER_PROPERTY && locationInParent != SingleVariableDeclaration.INITIALIZER_PROPERTY && locationInParent != ReturnStatement.EXPRESSION_PROPERTY && locationInParent != EnhancedForStatement.EXPRESSION_PROPERTY && locationInParent != ForStatement.EXPRESSION_PROPERTY && locationInParent != WhileStatement.EXPRESSION_PROPERTY && locationInParent != DoStatement.EXPRESSION_PROPERTY && locationInParent != AssertStatement.EXPRESSION_PROPERTY && locationInParent != AssertStatement.MESSAGE_PROPERTY && locationInParent != IfStatement.EXPRESSION_PROPERTY && locationInParent != SwitchStatement.EXPRESSION_PROPERTY && locationInParent != SwitchCase.EXPRESSION_PROPERTY && locationInParent != ArrayAccess.INDEX_PROPERTY && locationInParent != ThrowStatement.EXPRESSION_PROPERTY && locationInParent != SynchronizedStatement.EXPRESSION_PROPERTY && locationInParent != ParenthesizedExpression.EXPRESSION_PROPERTY;
    }

    private static boolean isAllOperandsHaveSameType(InfixExpression expression) {
        ITypeBinding binding = expression.getLeftOperand().resolveTypeBinding();
        if (binding == null) {
            return false;
        }
        ITypeBinding current = expression.getRightOperand().resolveTypeBinding();
        if (binding != current) {
            return false;
        }
        for (Expression operand : expression.extendedOperands()) {
            current = operand.resolveTypeBinding();
            if (binding == current) continue;
            return false;
        }
        return true;
    }

    private static boolean isExpressionIntegerType(Expression expression) {
        ITypeBinding binding = expression.resolveTypeBinding();
        if (binding == null) {
            return false;
        }
        if (!binding.isPrimitive()) {
            return false;
        }
        String name = binding.getName();
        return NecessaryParenthesesChecker.isIntegerNumber(name);
    }

    private static boolean isExpressionStringType(Expression expression) {
        ITypeBinding binding = expression.resolveTypeBinding();
        if (binding == null) {
            return false;
        }
        return "java.lang.String".equals(binding.getQualifiedName());
    }

    private static boolean isAssociative(InfixExpression expression) {
        InfixExpression.Operator operator = expression.getOperator();
        if (operator == InfixExpression.Operator.PLUS) {
            return NecessaryParenthesesChecker.isExpressionStringType(expression) || NecessaryParenthesesChecker.isExpressionIntegerType(expression) && NecessaryParenthesesChecker.isAllOperandsHaveSameType(expression);
        }
        if (operator == InfixExpression.Operator.TIMES) {
            return NecessaryParenthesesChecker.isExpressionIntegerType(expression) && NecessaryParenthesesChecker.isAllOperandsHaveSameType(expression);
        }
        return operator == InfixExpression.Operator.CONDITIONAL_AND || operator == InfixExpression.Operator.CONDITIONAL_OR || operator == InfixExpression.Operator.AND || operator == InfixExpression.Operator.OR || operator == InfixExpression.Operator.XOR;
    }

    private static boolean isIntegerNumber(String name) {
        return "int".equals(name) || "long".equals(name) || "byte".equals(name) || "char".equals(name) || "short".equals(name);
    }

    private static boolean needsParenthesesInInfixExpression(Expression expression, InfixExpression parentInfix, StructuralPropertyDescriptor locationInParent) {
        if (locationInParent == InfixExpression.LEFT_OPERAND_PROPERTY) {
            return false;
        }
        if (NecessaryParenthesesChecker.isAssociative(parentInfix)) {
            if (expression instanceof InfixExpression) {
                InfixExpression infixExpression = (InfixExpression)expression;
                InfixExpression.Operator operator = infixExpression.getOperator();
                if (NecessaryParenthesesChecker.isExpressionStringType(parentInfix)) {
                    if (parentInfix.getOperator() == InfixExpression.Operator.PLUS && operator == InfixExpression.Operator.PLUS && NecessaryParenthesesChecker.isExpressionStringType(infixExpression)) {
                        return !NecessaryParenthesesChecker.isExpressionStringType(infixExpression.getLeftOperand()) && !NecessaryParenthesesChecker.isExpressionStringType(parentInfix.getLeftOperand());
                    }
                    return true;
                }
                if (parentInfix.getOperator() != InfixExpression.Operator.TIMES) {
                    return false;
                }
                if (operator == InfixExpression.Operator.TIMES) {
                    return false;
                }
                return operator == InfixExpression.Operator.REMAINDER || operator == InfixExpression.Operator.DIVIDE;
            }
            return false;
        }
        return true;
    }

    public static boolean canRemoveParentheses(Expression expression) {
        return NecessaryParenthesesChecker.canRemoveParentheses(expression, expression.getParent(), expression.getLocationInParent());
    }

    public static boolean canRemoveParentheses(Expression expression, ASTNode parent, StructuralPropertyDescriptor locationInParent) {
        if (!(expression instanceof ParenthesizedExpression)) {
            return false;
        }
        return !NecessaryParenthesesChecker.needsParentheses(NecessaryParenthesesChecker.getExpression((ParenthesizedExpression)expression), parent, locationInParent);
    }

    public static boolean needsParentheses(Expression expression, ASTNode parent, StructuralPropertyDescriptor locationInParent) {
        if (!NecessaryParenthesesChecker.expressionTypeNeedsParentheses(expression)) {
            return false;
        }
        if (!NecessaryParenthesesChecker.locationNeedsParentheses(locationInParent)) {
            return false;
        }
        if (parent instanceof Expression) {
            int parentPrecedence;
            Expression parentExpression = (Expression)parent;
            int expressionPrecedence = OperatorPrecedence.getExpressionPrecedence(expression);
            if (expressionPrecedence > (parentPrecedence = OperatorPrecedence.getExpressionPrecedence(parentExpression))) {
                return false;
            }
            if (expressionPrecedence < parentPrecedence) {
                return true;
            }
            if (parentExpression instanceof InfixExpression) {
                return NecessaryParenthesesChecker.needsParenthesesInInfixExpression(expression, (InfixExpression)parentExpression, locationInParent);
            }
            return parentExpression instanceof ConditionalExpression && locationInParent == ConditionalExpression.EXPRESSION_PROPERTY;
        }
        return true;
    }
}

