/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.text.edits.TextEditGroup;

public class VariableDeclarationRewrite {
    public static void rewriteModifiers(SingleVariableDeclaration declarationNode, int includedModifiers, int excludedModifiers, ASTRewrite rewrite, TextEditGroup group) {
        ModifierRewrite listRewrite = ModifierRewrite.create(rewrite, declarationNode);
        listRewrite.setModifiers(includedModifiers, excludedModifiers, group);
    }

    public static void rewriteModifiers(VariableDeclarationExpression declarationNode, int includedModifiers, int excludedModifiers, ASTRewrite rewrite, TextEditGroup group) {
        ModifierRewrite listRewrite = ModifierRewrite.create(rewrite, declarationNode);
        listRewrite.setModifiers(includedModifiers, excludedModifiers, group);
    }

    public static void rewriteModifiers(FieldDeclaration declarationNode, VariableDeclarationFragment[] toChange, int includedModifiers, int excludedModifiers, ASTRewrite rewrite, TextEditGroup group) {
        List<VariableDeclarationFragment> fragmentsToChange = Arrays.asList(toChange);
        AST ast = declarationNode.getAST();
        List fragments = declarationNode.fragments();
        Iterator iter = fragments.iterator();
        ListRewrite blockRewrite = declarationNode.getParent() instanceof AbstractTypeDeclaration ? rewrite.getListRewrite(declarationNode.getParent(), ((AbstractTypeDeclaration)declarationNode.getParent()).getBodyDeclarationsProperty()) : rewrite.getListRewrite(declarationNode.getParent(), AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
        VariableDeclarationFragment lastFragment = (VariableDeclarationFragment)iter.next();
        FieldDeclaration lastStatement = declarationNode;
        if (fragmentsToChange.contains(lastFragment)) {
            ModifierRewrite modifierRewrite = ModifierRewrite.create(rewrite, declarationNode);
            modifierRewrite.setModifiers(includedModifiers, excludedModifiers, group);
        }
        ListRewrite fragmentsRewrite = null;
        while (iter.hasNext()) {
            boolean changeCurrent;
            VariableDeclarationFragment currentFragment = (VariableDeclarationFragment)iter.next();
            HashMap<VariableDeclarationFragment, MovedFragment> lookup = (HashMap<VariableDeclarationFragment, MovedFragment>)rewrite.getProperty(MovedFragment.class.getName());
            if (lookup == null) {
                lookup = new HashMap<VariableDeclarationFragment, MovedFragment>();
                rewrite.setProperty(MovedFragment.class.getName(), lookup);
            }
            MovedFragment currentMovedFragment = (MovedFragment)lookup.get(currentFragment);
            boolean changeLast = fragmentsToChange.contains(lastFragment);
            if (changeLast != (changeCurrent = fragmentsToChange.contains(currentFragment)) || lookup.containsKey(lastFragment)) {
                ModifierRewrite modifierRewrite = null;
                if (currentMovedFragment != null) {
                    if (currentMovedFragment.fUsesOriginalModifiers) {
                        modifierRewrite = ModifierRewrite.create(rewrite, currentMovedFragment.fDeclaration);
                        ListRewrite listRewrite = rewrite.getListRewrite(currentMovedFragment.fDeclaration, FieldDeclaration.MODIFIERS2_PROPERTY);
                        List extendedList = listRewrite.getRewrittenList();
                        int i = 0;
                        while (i < extendedList.size()) {
                            ASTNode curr = (ASTNode)extendedList.get(i);
                            if (curr instanceof Modifier) {
                                rewrite.remove(curr, group);
                            }
                            ++i;
                        }
                    }
                } else {
                    VariableDeclarationFragment moveTarget = (VariableDeclarationFragment)rewrite.createMoveTarget(currentFragment);
                    FieldDeclaration newStatement = (FieldDeclaration)ast.createInstance(FieldDeclaration.class);
                    rewrite.getListRewrite(newStatement, FieldDeclaration.FRAGMENTS_PROPERTY).insertLast(moveTarget, group);
                    lookup.put(currentFragment, new MovedFragment(moveTarget, newStatement, !changeCurrent));
                    rewrite.set(newStatement, FieldDeclaration.TYPE_PROPERTY, rewrite.createCopyTarget(declarationNode.getType()), group);
                    modifierRewrite = ModifierRewrite.create(rewrite, newStatement);
                    modifierRewrite.copyAllAnnotations(declarationNode, group);
                    blockRewrite.insertAfter(newStatement, lastStatement, group);
                    fragmentsRewrite = rewrite.getListRewrite(newStatement, FieldDeclaration.FRAGMENTS_PROPERTY);
                    lastStatement = newStatement;
                }
                if (modifierRewrite != null) {
                    if (changeCurrent) {
                        int newModifiers = declarationNode.getModifiers() & ~excludedModifiers | includedModifiers;
                        modifierRewrite.setModifiers(newModifiers, excludedModifiers, group);
                    } else {
                        int newModifiers = declarationNode.getModifiers();
                        modifierRewrite.setModifiers(newModifiers, 0, group);
                    }
                }
            } else if (fragmentsRewrite != null) {
                VariableDeclarationFragment fragment0;
                boolean usesOriginalModifiers = true;
                if (currentMovedFragment != null) {
                    fragment0 = currentMovedFragment.fMoveTarget;
                    usesOriginalModifiers = currentMovedFragment.fUsesOriginalModifiers;
                    rewrite.getListRewrite(currentMovedFragment.fDeclaration, FieldDeclaration.FRAGMENTS_PROPERTY).remove(fragment0, group);
                } else {
                    fragment0 = (VariableDeclarationFragment)rewrite.createMoveTarget(currentFragment);
                }
                lookup.put(currentFragment, new MovedFragment(fragment0, lastStatement, usesOriginalModifiers));
                fragmentsRewrite.insertLast(fragment0, group);
            }
            lastFragment = currentFragment;
        }
    }

    public static void rewriteModifiers(VariableDeclarationStatement declarationNode, VariableDeclarationFragment[] toChange, int includedModifiers, int excludedModifiers, ASTRewrite rewrite, TextEditGroup group) {
        List<VariableDeclarationFragment> fragmentsToChange = Arrays.asList(toChange);
        AST ast = declarationNode.getAST();
        List fragments = declarationNode.fragments();
        Iterator iter = fragments.iterator();
        ListRewrite blockRewrite = null;
        ASTNode parentStatement = declarationNode.getParent();
        if (parentStatement instanceof SwitchStatement) {
            blockRewrite = rewrite.getListRewrite(parentStatement, SwitchStatement.STATEMENTS_PROPERTY);
        } else if (parentStatement instanceof Block) {
            blockRewrite = rewrite.getListRewrite(parentStatement, Block.STATEMENTS_PROPERTY);
        } else {
            Assert.isTrue(false);
        }
        VariableDeclarationFragment lastFragment = (VariableDeclarationFragment)iter.next();
        VariableDeclarationStatement lastStatement = declarationNode;
        boolean modifiersModified = false;
        if (fragmentsToChange.contains(lastFragment)) {
            ModifierRewrite modifierRewrite = ModifierRewrite.create(rewrite, declarationNode);
            modifierRewrite.setModifiers(includedModifiers, excludedModifiers, group);
            modifiersModified = true;
        }
        ListRewrite fragmentsRewrite = null;
        while (iter.hasNext()) {
            VariableDeclarationFragment currentFragment = (VariableDeclarationFragment)iter.next();
            if (fragmentsToChange.contains(lastFragment) != fragmentsToChange.contains(currentFragment)) {
                VariableDeclarationStatement newStatement = ast.newVariableDeclarationStatement((VariableDeclarationFragment)rewrite.createMoveTarget(currentFragment));
                newStatement.setType((Type)rewrite.createCopyTarget(declarationNode.getType()));
                ModifierRewrite modifierRewrite = ModifierRewrite.create(rewrite, newStatement);
                if (fragmentsToChange.contains(currentFragment)) {
                    modifierRewrite.copyAllAnnotations(declarationNode, group);
                    int newModifiers = declarationNode.getModifiers() & ~excludedModifiers | includedModifiers;
                    modifierRewrite.setModifiers(newModifiers, excludedModifiers, group);
                } else {
                    modifierRewrite.copyAllModifiers(declarationNode, group, modifiersModified);
                }
                blockRewrite.insertAfter(newStatement, lastStatement, group);
                fragmentsRewrite = rewrite.getListRewrite(newStatement, VariableDeclarationStatement.FRAGMENTS_PROPERTY);
                lastStatement = newStatement;
            } else if (fragmentsRewrite != null) {
                ASTNode fragment0 = rewrite.createMoveTarget(currentFragment);
                fragmentsRewrite.insertLast(fragment0, group);
            }
            lastFragment = currentFragment;
        }
    }

    private static class MovedFragment {
        final VariableDeclarationFragment fMoveTarget;
        final ASTNode fDeclaration;
        boolean fUsesOriginalModifiers;

        public MovedFragment(VariableDeclarationFragment moveTarget, ASTNode declaration, boolean usesOriginalModifiers) {
            this.fMoveTarget = moveTarget;
            this.fDeclaration = declaration;
            this.fUsesOriginalModifiers = usesOriginalModifiers;
        }
    }
}

