/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTMatchingFragmentFinder;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.text.edits.TextEditGroup;

class SimpleFragment
extends ASTFragment {
    private final ASTNode fNode;

    SimpleFragment(ASTNode node) {
        Assert.isNotNull(node);
        this.fNode = node;
    }

    public IASTFragment[] getMatchingFragmentsWithNode(ASTNode node) {
        if (!JdtASTMatcher.doNodesMatch(this.getAssociatedNode(), node)) {
            return new IASTFragment[0];
        }
        IASTFragment match = ASTFragmentFactory.createFragmentForFullSubtree(node);
        Assert.isTrue(match.matches(this) || this.matches(match));
        return new IASTFragment[]{match};
    }

    public boolean matches(IASTFragment other) {
        return other.getClass().equals(this.getClass()) && JdtASTMatcher.doNodesMatch(other.getAssociatedNode(), this.getAssociatedNode());
    }

    public IASTFragment[] getSubFragmentsMatching(IASTFragment toMatch) {
        return ASTMatchingFragmentFinder.findMatchingFragments(this.getAssociatedNode(), (ASTFragment)toMatch);
    }

    public int getStartPosition() {
        return this.fNode.getStartPosition();
    }

    public int getLength() {
        return this.fNode.getLength();
    }

    public ASTNode getAssociatedNode() {
        return this.fNode;
    }

    public void replace(ASTRewrite rewrite, ASTNode replacement, TextEditGroup textEditGroup) {
        if (replacement instanceof Name && this.fNode.getParent() instanceof ParenthesizedExpression) {
            rewrite.replace(this.fNode.getParent(), replacement, textEditGroup);
        } else {
            rewrite.replace(this.fNode, replacement, textEditGroup);
        }
    }

    public int hashCode() {
        return this.fNode.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleFragment other = (SimpleFragment)obj;
        return this.fNode.equals(other.fNode);
    }
}

