/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeStyleFix
extends CompilationUnitRewriteOperationsFix {
    public static CompilationUnitRewriteOperationsFix[] createNonStaticAccessFixes(CompilationUnit compilationUnit, IProblemLocation problem) {
        if (!CodeStyleFix.isNonStaticAccess(problem)) {
            return null;
        }
        ToStaticAccessOperation[] operations = CodeStyleFix.createToStaticAccessOperations(compilationUnit, new HashMap<ASTNode, Block>(), problem, false);
        if (operations == null) {
            return null;
        }
        String label1 = Messages.format(FixMessages.CodeStyleFix_ChangeAccessToStatic_description, operations[0].getAccessorName());
        CompilationUnitRewriteOperationsFix fix1 = new CompilationUnitRewriteOperationsFix(label1, compilationUnit, operations[0]);
        if (operations.length > 1) {
            String label2 = Messages.format(FixMessages.CodeStyleFix_ChangeAccessToStaticUsingInstanceType_description, operations[1].getAccessorName());
            CompilationUnitRewriteOperationsFix fix2 = new CompilationUnitRewriteOperationsFix(label2, compilationUnit, operations[1]);
            return new CompilationUnitRewriteOperationsFix[]{fix1, fix2};
        }
        return new CompilationUnitRewriteOperationsFix[]{fix1};
    }

    public static CompilationUnitRewriteOperationsFix createAddFieldQualifierFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        if (570425423 != problem.getProblemId()) {
            return null;
        }
        AddThisQualifierOperation operation = CodeStyleFix.getUnqualifiedFieldAccessResolveOperation(compilationUnit, problem);
        if (operation == null) {
            return null;
        }
        String groupName = operation.getDescription();
        return new CodeStyleFix(groupName, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{operation});
    }

    public static CompilationUnitRewriteOperationsFix createIndirectAccessToStaticFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        if (!CodeStyleFix.isIndirectStaticAccess(problem)) {
            return null;
        }
        ToStaticAccessOperation[] operations = CodeStyleFix.createToStaticAccessOperations(compilationUnit, new HashMap<ASTNode, Block>(), problem, false);
        if (operations == null) {
            return null;
        }
        String label = Messages.format(FixMessages.CodeStyleFix_ChangeStaticAccess_description, operations[0].getAccessorName());
        return new CodeStyleFix(label, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{operations[0]});
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean addThisQualifier, boolean changeNonStaticAccessToStatic, boolean qualifyStaticFieldAccess, boolean changeIndirectStaticAccessToDirect, boolean qualifyMethodAccess, boolean qualifyStaticMethodAccess, boolean removeFieldQualifier, boolean removeMethodQualifier) {
        if (!(addThisQualifier || changeNonStaticAccessToStatic || qualifyStaticFieldAccess || changeIndirectStaticAccessToDirect || qualifyMethodAccess || qualifyStaticMethodAccess || removeFieldQualifier || removeMethodQualifier)) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation>();
        if (addThisQualifier || qualifyStaticFieldAccess || qualifyMethodAccess || qualifyStaticMethodAccess) {
            CodeStyleVisitor codeStyleVisitor = new CodeStyleVisitor(compilationUnit, addThisQualifier, qualifyStaticFieldAccess, qualifyMethodAccess, qualifyStaticMethodAccess, operations);
            compilationUnit.accept(codeStyleVisitor);
        }
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        CodeStyleFix.addToStaticAccessOperations(compilationUnit, locations, changeNonStaticAccessToStatic, changeIndirectStaticAccessToDirect, operations);
        if (removeFieldQualifier || removeMethodQualifier) {
            ThisQualifierVisitor visitor = new ThisQualifierVisitor(removeFieldQualifier, removeMethodQualifier, compilationUnit, operations);
            compilationUnit.accept(visitor);
        }
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] operationsArray = operations.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[operations.size()]);
        return new CodeStyleFix(FixMessages.CodeStyleFix_change_name, compilationUnit, operationsArray);
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean addThisQualifier, boolean changeNonStaticAccessToStatic, boolean changeIndirectStaticAccessToDirect) {
        if (!(addThisQualifier || changeNonStaticAccessToStatic || changeIndirectStaticAccessToDirect)) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation>();
        if (addThisQualifier) {
            int i = 0;
            while (i < problems.length) {
                AddThisQualifierOperation operation;
                IProblemLocation problem = problems[i];
                if (problem.getProblemId() == 570425423 && (operation = CodeStyleFix.getUnqualifiedFieldAccessResolveOperation(compilationUnit, problem)) != null) {
                    operations.add(operation);
                }
                ++i;
            }
        }
        CodeStyleFix.addToStaticAccessOperations(compilationUnit, problems, changeNonStaticAccessToStatic, changeIndirectStaticAccessToDirect, operations);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] operationsArray = operations.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[operations.size()]);
        return new CodeStyleFix(FixMessages.CodeStyleFix_change_name, compilationUnit, operationsArray);
    }

    private static void addToStaticAccessOperations(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean changeNonStaticAccessToStatic, boolean changeIndirectStaticAccessToDirect, List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> result) {
        if (!changeNonStaticAccessToStatic && !changeIndirectStaticAccessToDirect) {
            return;
        }
        HashMap<ASTNode, Block> createdBlocks = new HashMap<ASTNode, Block>();
        int i = 0;
        while (i < problems.length) {
            ToStaticAccessOperation op;
            Expression qualifier;
            ToStaticAccessOperation[] nonStaticAccessInformation;
            boolean isIndirectStaticAccess;
            IProblemLocation problem = problems[i];
            boolean isNonStaticAccess = changeNonStaticAccessToStatic && CodeStyleFix.isNonStaticAccess(problem);
            boolean bl = isIndirectStaticAccess = changeIndirectStaticAccessToDirect && CodeStyleFix.isIndirectStaticAccess(problem);
            if (!(!isNonStaticAccess && !isIndirectStaticAccess || (nonStaticAccessInformation = CodeStyleFix.createToStaticAccessOperations(compilationUnit, createdBlocks, problem, true)) == null || (qualifier = (op = nonStaticAccessInformation[0]).fQualifier) instanceof MethodInvocation && CodeStyleFix.isMethodArgument(qualifier))) {
                result.add(op);
            }
            ++i;
        }
    }

    private static boolean isMethodArgument(Expression expression) {
        ASTNode parent = expression;
        while (parent instanceof Expression) {
            if (parent.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY) {
                return true;
            }
            if (parent.getLocationInParent() == ConstructorInvocation.ARGUMENTS_PROPERTY) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isIndirectStaticAccess(IProblemLocation problem) {
        return problem.getProblemId() == 570425422 || problem.getProblemId() == 603979895;
    }

    public static boolean isNonStaticAccess(IProblemLocation problem) {
        return problem.getProblemId() == 570425420 || problem.getProblemId() == 603979893;
    }

    private static ToStaticAccessOperation[] createToStaticAccessOperations(CompilationUnit astRoot, HashMap<ASTNode, Block> createdBlocks, IProblemLocation problem, boolean conservative) {
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return null;
        }
        Expression qualifier = null;
        IBinding accessBinding = null;
        if (selectedNode instanceof QualifiedName) {
            QualifiedName name = (QualifiedName)selectedNode;
            qualifier = name.getQualifier();
            accessBinding = name.resolveBinding();
        } else if (selectedNode instanceof SimpleName) {
            ASTNode parent = selectedNode.getParent();
            if (parent instanceof FieldAccess) {
                FieldAccess fieldAccess = (FieldAccess)parent;
                qualifier = fieldAccess.getExpression();
                accessBinding = fieldAccess.getName().resolveBinding();
            } else if (parent instanceof QualifiedName) {
                QualifiedName qualifiedName = (QualifiedName)parent;
                qualifier = qualifiedName.getQualifier();
                accessBinding = qualifiedName.getName().resolveBinding();
            }
        } else if (selectedNode instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)selectedNode;
            qualifier = methodInvocation.getExpression();
            accessBinding = methodInvocation.getName().resolveBinding();
        } else if (selectedNode instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)selectedNode;
            qualifier = fieldAccess.getExpression();
            accessBinding = fieldAccess.getName().resolveBinding();
        }
        if (accessBinding != null && qualifier != null) {
            if (conservative && ASTResolving.findParentStatement(qualifier) == null) {
                return null;
            }
            ToStaticAccessOperation declaring = null;
            ITypeBinding declaringTypeBinding = CodeStyleFix.getDeclaringTypeBinding(accessBinding);
            if (declaringTypeBinding != null) {
                declaringTypeBinding = declaringTypeBinding.getTypeDeclaration();
                declaring = new ToStaticAccessOperation(declaringTypeBinding, qualifier, createdBlocks);
            }
            ToStaticAccessOperation instance = null;
            ITypeBinding instanceTypeBinding = Bindings.normalizeTypeBinding(qualifier.resolveTypeBinding());
            if (instanceTypeBinding != null && (instanceTypeBinding = instanceTypeBinding.getTypeDeclaration()).getTypeDeclaration() != declaringTypeBinding) {
                instance = new ToStaticAccessOperation(instanceTypeBinding, qualifier, createdBlocks);
            }
            if (declaring != null && instance != null) {
                return new ToStaticAccessOperation[]{declaring, instance};
            }
            return new ToStaticAccessOperation[]{declaring};
        }
        return null;
    }

    private static ITypeBinding getDeclaringTypeBinding(IBinding accessBinding) {
        if (accessBinding instanceof IMethodBinding) {
            return ((IMethodBinding)accessBinding).getDeclaringClass();
        }
        if (accessBinding instanceof IVariableBinding) {
            return ((IVariableBinding)accessBinding).getDeclaringClass();
        }
        return null;
    }

    private static AddThisQualifierOperation getUnqualifiedFieldAccessResolveOperation(CompilationUnit compilationUnit, IProblemLocation problem) {
        SimpleName name = CodeStyleFix.getName(compilationUnit, problem);
        if (name == null) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (binding == null || binding.getKind() != 3) {
            return null;
        }
        ImportRewrite imports = StubUtility.createImportRewrite(compilationUnit, true);
        String replacement = CodeStyleFix.getThisExpressionQualifier(((IVariableBinding)binding).getDeclaringClass(), imports, name);
        if (replacement == null) {
            return null;
        }
        if (replacement.length() == 0) {
            replacement = null;
        }
        return new AddThisQualifierOperation(replacement, name);
    }

    private static String getThisExpressionQualifier(ITypeBinding declaringClass, ImportRewrite imports, SimpleName name) {
        ITypeBinding parentType;
        ITypeBinding currType = parentType = Bindings.getBindingOfParentType(name);
        while (currType != null && !Bindings.isSuperType(declaringClass, currType)) {
            currType = currType.getDeclaringClass();
        }
        if (currType == null) {
            declaringClass = declaringClass.getTypeDeclaration();
            currType = parentType;
            while (currType != null && !Bindings.isSuperType(declaringClass, currType)) {
                currType = currType.getDeclaringClass();
            }
        }
        if (currType != parentType) {
            if (currType == null) {
                return null;
            }
            if (currType.isAnonymous()) {
                return null;
            }
            return imports.addImport(currType);
        }
        return "";
    }

    private static SimpleName getName(CompilationUnit compilationUnit, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        while (selectedNode instanceof QualifiedName) {
            selectedNode = ((QualifiedName)selectedNode).getQualifier();
        }
        if (!(selectedNode instanceof SimpleName)) {
            return null;
        }
        return (SimpleName)selectedNode;
    }

    private CodeStyleFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] operations) {
        super(name, compilationUnit, operations);
    }

    private static final class AddStaticQualifierOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final SimpleName fName;
        private final ITypeBinding fDeclaringClass;

        public AddStaticQualifierOperation(ITypeBinding declaringClass, SimpleName name) {
            this.fDeclaringClass = declaringClass;
            this.fName = name;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            CompilationUnit compilationUnit = cuRewrite.getRoot();
            this.importType(this.fDeclaringClass, this.fName, cuRewrite.getImportRewrite(), compilationUnit);
            TextEditGroup group = this.fName.resolveBinding() instanceof IMethodBinding ? this.createTextEditGroup(FixMessages.CodeStyleFix_QualifyMethodWithDeclClass_description, cuRewrite) : this.createTextEditGroup(FixMessages.CodeStyleFix_QualifyFieldWithDeclClass_description, cuRewrite);
            IJavaElement javaElement = this.fDeclaringClass.getJavaElement();
            if (javaElement instanceof IType) {
                Name qualifierName = compilationUnit.getAST().newName(((IType)javaElement).getElementName());
                SimpleName simpleName = (SimpleName)rewrite.createMoveTarget(this.fName);
                QualifiedName qualifiedName = compilationUnit.getAST().newQualifiedName(qualifierName, simpleName);
                rewrite.replace(this.fName, qualifiedName, group);
            }
        }
    }

    private static final class AddThisQualifierOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final String fQualifier;
        private final SimpleName fName;

        public AddThisQualifierOperation(String qualifier, SimpleName name) {
            this.fQualifier = qualifier;
            this.fName = name;
        }

        public String getDescription() {
            String nameLabel = BasicElementLabels.getJavaElementName(this.fName.getIdentifier());
            String qualifierLabel = this.fQualifier == null ? "this" : BasicElementLabels.getJavaElementName(String.valueOf(this.fQualifier) + ".this");
            return Messages.format(FixMessages.CodeStyleFix_QualifyWithThis_description, new Object[]{nameLabel, qualifierLabel});
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(this.getDescription(), cuRewrite);
            AST ast = rewrite.getAST();
            FieldAccess fieldAccess = ast.newFieldAccess();
            ThisExpression thisExpression = ast.newThisExpression();
            if (this.fQualifier != null) {
                thisExpression.setQualifier(ast.newName(this.fQualifier));
            }
            fieldAccess.setExpression(thisExpression);
            fieldAccess.setName((SimpleName)rewrite.createMoveTarget(this.fName));
            rewrite.replace(this.fName, fieldAccess, group);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CodeStyleVisitor
    extends GenericVisitor {
        private final List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> fResult;
        private final ImportRewrite fImportRewrite;
        private final boolean fFindUnqualifiedAccesses;
        private final boolean fFindUnqualifiedStaticAccesses;
        private final boolean fFindUnqualifiedMethodAccesses;
        private final boolean fFindUnqualifiedStaticMethodAccesses;

        public CodeStyleVisitor(CompilationUnit compilationUnit, boolean findUnqualifiedAccesses, boolean findUnqualifiedStaticAccesses, boolean findUnqualifiedMethodAccesses, boolean findUnqualifiedStaticMethodAccesses, List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> resultingCollection) {
            this.fFindUnqualifiedAccesses = findUnqualifiedAccesses;
            this.fFindUnqualifiedStaticAccesses = findUnqualifiedStaticAccesses;
            this.fFindUnqualifiedMethodAccesses = findUnqualifiedMethodAccesses;
            this.fFindUnqualifiedStaticMethodAccesses = findUnqualifiedStaticMethodAccesses;
            this.fImportRewrite = StubUtility.createImportRewrite(compilationUnit, true);
            this.fResult = resultingCollection;
        }

        @Override
        public boolean visit(TypeDeclaration node) {
            if (!this.fFindUnqualifiedStaticAccesses && !this.fFindUnqualifiedStaticMethodAccesses && node.isInterface()) {
                return false;
            }
            return super.visit(node);
        }

        @Override
        public boolean visit(QualifiedName node) {
            if (this.fFindUnqualifiedAccesses || this.fFindUnqualifiedStaticAccesses) {
                Name simpleName = node;
                while (simpleName instanceof QualifiedName) {
                    simpleName = simpleName.getQualifier();
                }
                if (simpleName instanceof SimpleName) {
                    this.handleSimpleName((SimpleName)simpleName);
                }
            }
            return false;
        }

        @Override
        public boolean visit(SimpleName node) {
            if (this.fFindUnqualifiedAccesses || this.fFindUnqualifiedStaticAccesses) {
                this.handleSimpleName(node);
            }
            return false;
        }

        @Override
        public boolean visit(MethodInvocation node) {
            if (!this.fFindUnqualifiedMethodAccesses && !this.fFindUnqualifiedStaticMethodAccesses) {
                return true;
            }
            if (node.getExpression() != null) {
                return true;
            }
            IBinding binding = node.getName().resolveBinding();
            if (!(binding instanceof IMethodBinding)) {
                return true;
            }
            this.handleMethod(node.getName(), (IMethodBinding)binding);
            return true;
        }

        private void handleSimpleName(SimpleName node) {
            ASTNode firstExpression = node.getParent();
            if (firstExpression instanceof FieldAccess) {
                while (firstExpression instanceof FieldAccess) {
                    firstExpression = ((FieldAccess)firstExpression).getExpression();
                }
                if (!(firstExpression instanceof SimpleName)) {
                    return;
                }
                node = (SimpleName)firstExpression;
            } else if (firstExpression instanceof SuperFieldAccess) {
                return;
            }
            StructuralPropertyDescriptor parentDescription = node.getLocationInParent();
            if (parentDescription == VariableDeclarationFragment.NAME_PROPERTY || parentDescription == SwitchCase.EXPRESSION_PROPERTY) {
                return;
            }
            IBinding binding = node.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return;
            }
            this.handleVariable(node, (IVariableBinding)binding);
        }

        private void handleVariable(SimpleName node, IVariableBinding varbinding) {
            if (!varbinding.isField()) {
                return;
            }
            if (varbinding.isEnumConstant()) {
                return;
            }
            ITypeBinding declaringClass = varbinding.getDeclaringClass();
            if (Modifier.isStatic(varbinding.getModifiers())) {
                if (this.fFindUnqualifiedStaticAccesses) {
                    Initializer initializer = (Initializer)ASTNodes.getParent((ASTNode)node, Initializer.class);
                    StructuralPropertyDescriptor parentDescription = node.getLocationInParent();
                    if (initializer != null && Modifier.isStatic(initializer.getModifiers()) && Modifier.isFinal(varbinding.getModifiers()) && parentDescription == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                        return;
                    }
                    if (declaringClass.isAnonymous()) {
                        return;
                    }
                    this.fResult.add(new AddStaticQualifierOperation(declaringClass, node));
                }
            } else if (this.fFindUnqualifiedAccesses) {
                String qualifier = CodeStyleFix.getThisExpressionQualifier(declaringClass, this.fImportRewrite, node);
                if (qualifier == null) {
                    return;
                }
                if (qualifier.length() == 0) {
                    qualifier = null;
                }
                this.fResult.add(new AddThisQualifierOperation(qualifier, node));
            }
        }

        private void handleMethod(SimpleName node, IMethodBinding binding) {
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (Modifier.isStatic(binding.getModifiers())) {
                if (this.fFindUnqualifiedStaticMethodAccesses) {
                    if (declaringClass.isAnonymous()) {
                        return;
                    }
                    this.fResult.add(new AddStaticQualifierOperation(declaringClass, node));
                }
            } else if (this.fFindUnqualifiedMethodAccesses) {
                String qualifier = CodeStyleFix.getThisExpressionQualifier(declaringClass, this.fImportRewrite, node);
                if (qualifier == null) {
                    return;
                }
                if (qualifier.length() == 0) {
                    qualifier = null;
                }
                this.fResult.add(new AddThisQualifierOperation(qualifier, node));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThisQualifierVisitor
    extends GenericVisitor {
        private final CompilationUnit fCompilationUnit;
        private final List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> fOperations;
        private final boolean fRemoveFieldQualifiers;
        private final boolean fRemoveMethodQualifiers;

        public ThisQualifierVisitor(boolean removeFieldQualifiers, boolean removeMethodQualifiers, CompilationUnit compilationUnit, List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> result) {
            this.fRemoveFieldQualifiers = removeFieldQualifiers;
            this.fRemoveMethodQualifiers = removeMethodQualifiers;
            this.fCompilationUnit = compilationUnit;
            this.fOperations = result;
        }

        @Override
        public boolean visit(final FieldAccess node) {
            if (!this.fRemoveFieldQualifiers) {
                return true;
            }
            Expression expression = node.getExpression();
            if (!(expression instanceof ThisExpression)) {
                return true;
            }
            final SimpleName name = node.getName();
            if (this.hasConflict(expression.getStartPosition(), name, 18)) {
                return true;
            }
            Name qualifier = ((ThisExpression)expression).getQualifier();
            if (qualifier != null) {
                ITypeBinding outerClass = (ITypeBinding)qualifier.resolveBinding();
                if (outerClass == null) {
                    return true;
                }
                IVariableBinding nameBinding = (IVariableBinding)name.resolveBinding();
                if (nameBinding == null) {
                    return true;
                }
                ITypeBinding variablesDeclaringClass = nameBinding.getDeclaringClass();
                if (outerClass != variablesDeclaringClass) {
                    return true;
                }
                ITypeBinding enclosingTypeBinding = Bindings.getBindingOfParentType(node);
                if (enclosingTypeBinding == null || Bindings.isSuperType(variablesDeclaringClass, enclosingTypeBinding)) {
                    return true;
                }
            }
            this.fOperations.add(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation(){

                public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
                    ASTRewrite rewrite = cuRewrite.getASTRewrite();
                    TextEditGroup group = this.createTextEditGroup(FixMessages.CodeStyleFix_removeThis_groupDescription, cuRewrite);
                    rewrite.replace(node, rewrite.createCopyTarget(name), group);
                }
            });
            return super.visit(node);
        }

        @Override
        public boolean visit(final MethodInvocation node) {
            if (!this.fRemoveMethodQualifiers) {
                return true;
            }
            Expression expression = node.getExpression();
            if (!(expression instanceof ThisExpression)) {
                return true;
            }
            SimpleName name = node.getName();
            if (name.resolveBinding() == null) {
                return true;
            }
            if (this.hasConflict(expression.getStartPosition(), name, 17)) {
                return true;
            }
            Name qualifier = ((ThisExpression)expression).getQualifier();
            if (qualifier != null) {
                ITypeBinding declaringClass = ((IMethodBinding)name.resolveBinding()).getDeclaringClass();
                if (declaringClass == null) {
                    return true;
                }
                ITypeBinding caller = this.getDeclaringType(node);
                if (caller == null) {
                    return true;
                }
                ITypeBinding callee = (ITypeBinding)qualifier.resolveBinding();
                if (callee == null) {
                    return true;
                }
                if (callee.isAssignmentCompatible(declaringClass) && caller.isAssignmentCompatible(declaringClass)) {
                    return true;
                }
            }
            this.fOperations.add(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation(){

                public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
                    ASTRewrite rewrite = cuRewrite.getASTRewrite();
                    TextEditGroup group = this.createTextEditGroup(FixMessages.CodeStyleFix_removeThis_groupDescription, cuRewrite);
                    rewrite.remove(node.getExpression(), group);
                }
            });
            return super.visit(node);
        }

        private ITypeBinding getDeclaringType(MethodInvocation node) {
            ASTNode p = node;
            while (p != null) {
                if (!((p = p.getParent()) instanceof AbstractTypeDeclaration)) continue;
                return ((AbstractTypeDeclaration)p).resolveBinding();
            }
            return null;
        }

        private boolean hasConflict(int startPosition, SimpleName name, int flag) {
            ScopeAnalyzer analyzer = new ScopeAnalyzer(this.fCompilationUnit);
            IBinding[] declarationsInScope = analyzer.getDeclarationsInScope(startPosition, flag);
            int i = 0;
            while (i < declarationsInScope.length) {
                IBinding decl = declarationsInScope[i];
                if (decl.getName().equals(name.getIdentifier()) && name.resolveBinding() != decl) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ToStaticAccessOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final ITypeBinding fDeclaringTypeBinding;
        private final Expression fQualifier;
        private final HashMap<ASTNode, Block> fCreatedBlocks;

        public ToStaticAccessOperation(ITypeBinding declaringTypeBinding, Expression qualifier, HashMap<ASTNode, Block> createdBlocks) {
            this.fDeclaringTypeBinding = declaringTypeBinding;
            this.fQualifier = qualifier;
            this.fCreatedBlocks = createdBlocks;
        }

        public String getAccessorName() {
            return this.fDeclaringTypeBinding.getName();
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.CodeStyleFix_ChangeAccessUsingDeclaring_description, cuRewrite);
            if (this.fQualifier instanceof MethodInvocation || this.fQualifier instanceof ClassInstanceCreation) {
                this.extractQualifier(this.fQualifier, cuRewrite, group);
            }
            Type type = this.importType(this.fDeclaringTypeBinding, this.fQualifier, cuRewrite.getImportRewrite(), cuRewrite.getRoot());
            cuRewrite.getASTRewrite().replace(this.fQualifier, type, group);
        }

        private void extractQualifier(Expression qualifier, CompilationUnitRewrite cuRewrite, TextEditGroup group) {
            Statement statement = ASTResolving.findParentStatement(qualifier);
            if (statement == null) {
                return;
            }
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getAST();
            Expression expression = (Expression)astRewrite.createMoveTarget(qualifier);
            ExpressionStatement newStatement = ast.newExpressionStatement(expression);
            if (statement.getParent() instanceof Block) {
                Block block = (Block)statement.getParent();
                ListRewrite listRewrite = astRewrite.getListRewrite(block, Block.STATEMENTS_PROPERTY);
                listRewrite.insertBefore(newStatement, statement, group);
            } else {
                ASTNode lastStatement;
                Block block = this.fCreatedBlocks.containsKey(statement.getParent()) ? this.fCreatedBlocks.get(statement.getParent()) : ast.newBlock();
                ListRewrite listRewrite = astRewrite.getListRewrite(block, Block.STATEMENTS_PROPERTY);
                if (!this.fCreatedBlocks.containsKey(statement.getParent())) {
                    this.fCreatedBlocks.put(statement.getParent(), block);
                    lastStatement = astRewrite.createMoveTarget(statement);
                    listRewrite.insertLast(lastStatement, group);
                    ASTNode parent = statement.getParent();
                    astRewrite.set(parent, statement.getLocationInParent(), block, group);
                } else {
                    List rewrittenList = listRewrite.getRewrittenList();
                    lastStatement = (ASTNode)rewrittenList.get(rewrittenList.size() - 1);
                }
                listRewrite.insertBefore(newStatement, lastStatement, group);
            }
        }
    }
}

